/* SH/FTZ */

#define MAIN
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "ftz.h"
#include "output.h"

int program_function;
int p_ssn ;

int   d;      /* Tag im Jahr */
Date  date;   /* Datum       */
struct tm now;
time_t t;
int p_jahr, p_monat;
float p_x1, p_y1, p_x2, p_y2;
char pps;
char pcall1;
char pcall2;
char *p_ps;
char *p_call1;
char *p_call2;
char *ch;

Location target_location;
Location user_location;

int month_length[13] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 } ;

int get_program_function(char *program_name)
{
   int func;
   char *p;
   
   func=F_NIL;
   
   /* Abschneiden eines eventuellen Pfad-Namens */
   p=strrchr(program_name,'/');
   if (p==NULL)
   {
      p=program_name;
   }
   else
   {
      p++;	/* Zeiger auf Zeichen hinter '/' stellen */
   }
   
   strupr(p);	/* umwandeln in Gro-Buchstaben */

   if (strcmp(p,"FTZ6") == 0) 
     func = F_FTZ6;
   else 
    if (strcmp(p,"FTZ") == 0) 
      func = F_FTZ;   

   if (func==F_NIL)
   {
      /* Kann nur bei falscher Installation auftreten */
		printf("%s: Unknown function\n",p);
		exit(-1);
	}

   return (func);   
}

/* Ausfhren von SH/FTZ      */
void sh_ftz()
{
   int valid; 

   print_header(F_FTZ,"");
   valid=0;
   switch(target_location.pref[0])
      {
      	case '#':
            print_not_in_database(target_location.name);
            break;
         case '?':
            print_data_not_available(target_location.name);
            break;
         default:
            {
            /* target location */  
            p_x2  = (float) target_location.lat;        
            p_y2  = (float) target_location.lon;
            valid++;
            } 
     } 

/* abfrage */
            p_x1 = (float) user_location.lat;
            p_y1 = (float) user_location.lon;




if (valid!=0) 
   {
   ftz_kern(p_ssn,p_jahr,p_monat,p_x1,p_y1,p_x2,p_y2,p_ps,
   p_call1,p_call2);  
   print_foot(valid,F_FTZ);
   }
}

int main(int argc,char *argv[])
{
	char	*p;
	int 	j;

   /* Funktion des Programms festlegen */
   program_function=get_program_function(argv[0]);

   /* Alle bergabe-Parameter in den String list kopieren */
   switch(argc)
   {  /* Falls kein bergabeparameter bergeben wurde, */
     	/* dann Fehlermeldung */
      case 1:		   
         print_usage(argv[0]);
         exit(1);
         break;
      default:
         {
         }
	}
  
   /* Monat und Jahr ermitteln */
   time(&t);
   now = *gmtime(&t);
   p_jahr = now.tm_year;
   p_monat = now.tm_mon +1;
  
   /* ermitteln von SSN */ 
   p_ssn = pg_lookup_SSN(); 
 
         /* Suche in User-Datenbank  */
         user_location=pg_lookup_us_data(strlwr(argv[1]));
         if (strlen(user_location.pref)!=0)
         {
         	if (strlen(user_location.name)==0)
            {  
              /*  Dann keinen QTH-Eintrag gefunden */
               strcpy(user_location.pref,"?");
               strcpy(user_location.name,p);
            }
         }
 /*    	 Suche in Location.dat   evtl noch gebraucht 
         locs=scan_locations(strupr(p));	
         if (strlen(locations[max_loc].pref)!=0)
         {
         } */ 
   
         /* Suche in DXCC-DB */
         j=pg_lookup_dxcc_pfx(strlwr(argv[2]));
         if (j==0)
         {
         /* Es wurde kein Eintrag gefunden */
         strcpy(target_location.pref,"#");
         strcpy(target_location.name,p);
         } 

     p=strtok(NULL," \t\n");
         p_call1 = &pcall1;
         p_call2 = &pcall2;
         ch = strcpy(p_call1,argv[1]);
         ch = strcpy(p_call2,target_location.pref);


         p_ps = &pps; 
         pps = 'S'; 
         if (argc ==4) { 
            if ((*argv[3]=='l') || (*argv[3]=='L'))
               {  pps =  'L';}; };
  
/* Abhngig von der Programm-Funktion die Parameterliste abarbeiten */
   switch(program_function)
   {
      case F_FTZ:
                sh_ftz(); 
         break;
      case F_FTZ6:
                ftz_kern(p_ssn,p_jahr,p_monat,p_x1,p_y1,p_x2,p_y2,p_ps,
                p_call1, p_call1);
         break;
      default:
         break;
   }
	exit(0);
}
