/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) version, circa 1992).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABLITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#pragma  check_stack(off)

#include <windows.h>
#include <stdio.h>
#ifdef _DEBUG_
#include <stdarg.h>
#include <string.h>
#endif /* _DEBUG_ */

#include "vstdefs.h"
#include "vsttype.h"
#include "libxtrns.h"
#include "resource.h"   /* make sure the one in this directory is used! */

char textbuf[BUFLEN];
char tmpbuf[BUFLEN]; 
char msgbuf[BUFLEN]; 
char string[BUFLEN];

COLORREF BColors[16] = {
    0x00000000, 0x0000007f, 0x00007f00, 0x00007f7f,
    0x007f0000, 0x007f007f, 0x007f7f00, 0x007f7f7f,
    0x00bfbfbf, 0x000000ff, 0x0000ff00, 0x0000ffff,
    0x00ff0000, 0x00ff00ff, 0x00ffff00, 0x00ffffff
};

HWND Gwnd;
LOGBRUSH    BDrawBrush[NPAL];         /* All the colored brushes */
HBRUSH      hBDrawBrush[NPAL];        /* All the colored brush handles*/
COLORREF    BColors[NPAL];            /* colors we can use... */
HINSTANCE   hInstDLL;
static HICON hAsterisk, hQuestion;   /* Icon handles */
#ifdef _DEBUG_
void (*diag)(va_list, ...);
#else /* _DEBUG_ */
void diag(void) { }
#endif /* _DEBUG_ */

RECT ClRect;
#define NSCREENS 3

static char *cptitle[] = {
"Sattrack Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.",

"Xsat Copyright 1992 by David A. Curry",

"VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.",
};

static char *cppara1[] = {
"Permission to use, copy, modify, and distribute this software and its \
documentation for educational, research and non-profit purposes, without \
fee, and without a written agreement is hereby granted, provided that the \
above copyright notice and the following three paragraphs appear in all \
copies.",

"Permission to use, copy, modify, distribute, and sell this software and its \
documentation for any purpose is hereby granted without fee, provided that \
the above copyright notice appear in all copies and that both that copyright \
notice and this permission notice appear in supporting documentation. The \
author makes no representations about the suitability of this software for \
any purpose.  It is provided \"as is\" without express or implied warranty.",

"Permission is hereby granted to copy, modify and distribute VersaTrack \
in whole, or in part, for educational, non-profit and non-commercial use \
only, free of charge or obligation, and without agreement, provided that \
all copyrights and restrictions noted herein are observed and followed, and \
additionally, that this and all other copyright notices and accompanying \
paragraphs listed herein appear unaltered in all copies and in all derived \
work.",
};

static char *cppara2[] = {
"Permission to incorporate this software into commercial products may be \
obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way, \
Berkeley, CA 94709, USA.",

"David A. Curry, N9MSW, Purdue University, Engineering Computer Network, \
1285 Electrical Engineering Building, West Lafayette, IN 47907. \
davy@ecn.purdue.edu",

"This notice shall not in any way void or supersede any of the other authors \
rights or privileges.",
};

static char *cppara3[] = {
"IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, \
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF \
THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED \
OF THE POSSIBILITY OF SUCH DAMAGE.",
" ",
"Author can be contacted at the following address: 12342 Hunter's Chase Dr. \
#2114, Austin, TX 78729. sia@realtime.com",
};

static char *cppara4[] = {
"THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT \
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A \
PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN \"AS IS\" \
BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, \
UPDATES, ENHANCEMENTS, OR MODIFICATIONS.",

" ",

"VersaTrack IS PRESENTED FREE AND \"AS IS\", WITHOUT ANY WARRANTY OR SUPPORT. \
YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any \
direct, indirect, incidental, or consequential damage, loss of profits or \
other tangible or intangible losses or benefits, arising out of or related \
to its use. VersaTrack carries no warranty, explicit or implied, including \
but not limited to those of merchantablity and fitness for a particular \
purpose.",
};

static BOOL CALLBACK
UserMsgProc(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    int action;
    POINT *p;
    HDC hdc;
        
    switch(message) {
    case WM_INITDIALOG:
        p = DialogPos(hwnd);
        SendDlgItemMessage(hwnd, IDC_MSGTEXT, WM_SETTEXT, (WPARAM) 0, (LPARAM) msgbuf);
        SendDlgItemMessage(hwnd, IDC_MSGTEXT, WM_SETFOCUS, (WPARAM)
            GetParent(hwnd), (LPARAM) 0);
        SetWindowPos(hwnd, HWND_TOPMOST, (int)p->x, (int)p->y, 0, 0,
            SWP_NOSIZE|SWP_SHOWWINDOW);
        hdc = GetDC(hwnd);
        DrawIcon(hdc, 12, 17, hAsterisk);
        ReleaseDC(hwnd, hdc);
        return TRUE;

    case WM_COMMAND:
        action = LOWORD(wParam);
        if (action == IDOK) {
            EndDialog(hwnd, wParam);
            return TRUE;
        }
        break;

    case WM_CTLCOLORDLG:
    case WM_CTLCOLORSTATIC:
        SetTextColor((HDC)wParam, BColors[0]);
        SetBkColor((HDC)wParam, BColors[14]);
        return (BOOL) hBDrawBrush[14];

    default:
        break;
    }

    return FALSE;
}


static BOOL CALLBACK
YesNoProc(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    int action;
    POINT *p;
    HDC hdc;

    switch(message) {
    case WM_INITDIALOG:
        p = DialogPos(hwnd);
        SendDlgItemMessage(hwnd, IDC_YESNOTEXT, WM_SETTEXT, 0, (LPARAM) msgbuf);
        SendMessage(hwnd, DM_SETDEFID, (WPARAM) IDOK, (LPARAM) 0);
        SetWindowPos(hwnd, HWND_TOPMOST, (int)p->x, (int)p->y, 0, 0,
            SWP_NOSIZE|SWP_SHOWWINDOW);
        hdc = GetDC(hwnd);
        DrawIcon(hdc, 14, 20, hQuestion);
        ReleaseDC(hwnd, hdc);
        return TRUE;

    case WM_COMMAND:
        action = LOWORD(wParam);
        if (action == IDOK || action == IDCANCEL) {
            EndDialog(hwnd, (LOWORD(wParam) == IDOK) ? TRUE : FALSE);
            return TRUE;
        }
        break;

    case WM_CTLCOLORSTATIC:
    case WM_CTLCOLORDLG:
        SetTextColor((HDC)wParam, BColors[11]); /* was 15 */
        SetBkColor((HDC)wParam, BColors[7]);    /* was 5 */
        return (BOOL) hBDrawBrush[7];           /* was 5 */
    }

    return FALSE;
}

static int Cscreen;

BOOL CALLBACK
CpyRightProc(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    POINT *p;
        
    switch(message) {
    case WM_INITDIALOG:
        p = DialogPos(hwnd);
        if (Cscreen != NSCREENS-1)
            SendDlgItemMessage(hwnd, IDOK, WM_SETTEXT, 0, (LPARAM) "More..."); 

        SendDlgItemMessage(hwnd, IDC_TITLE, WM_SETTEXT, 0,
            (LPARAM) cptitle[Cscreen]);
        SendDlgItemMessage(hwnd, IDC_PARA1, WM_SETTEXT, 0,
            (LPARAM) cppara1[Cscreen]);
        SendDlgItemMessage(hwnd, IDC_PARA2, WM_SETTEXT, 0,
            (LPARAM) cppara2[Cscreen]);
        SendDlgItemMessage(hwnd, IDC_PARA3, WM_SETTEXT, 0,
            (LPARAM) cppara3[Cscreen]);
        SendDlgItemMessage(hwnd, IDC_PARA4, WM_SETTEXT, 0,
            (LPARAM) cppara4[Cscreen]);
        SetWindowPos(hwnd, HWND_TOPMOST, (int)p->x, (int)p->y, 0, 0,
            SWP_NOSIZE|SWP_SHOWWINDOW);
        break;
        
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK) {
            EndDialog(hwnd, wParam);
            return TRUE;
        }
        break;

    case WM_CTLCOLORDLG:
    case WM_CTLCOLORSTATIC:
        SetTextColor((HDC)wParam, BColors[0]);
        SetBkColor((HDC)wParam, BColors[8]);
        return (BOOL) hBDrawBrush[8];
    }
    
    return FALSE;
}

main() { return 0; }


WINAPI
DBReadInit(HINSTANCE hinsdll, DWORD reason, LPVOID reserved)
{
    int i;
#ifdef _DEBUG_
    extern void ConsClose();
#endif
                
    if (reason == DLL_PROCESS_ATTACH) {
        HDC hdc;

        hInstDLL = hinsdll;
#ifdef _DEBUG_
        diag = DebugFunc;
        diag("DBREAD.DLL: Debug Console Opened.\n");
#endif /* _DEBUG_ */
		hdc = GetDC(NULL);
        for (i=0; i < 16; i++) {
           	if (hdc)
	            BColors[i] = GetNearestColor(hdc, BColors[i]);
            BDrawBrush[i].lbStyle   = BS_SOLID;
            BDrawBrush[i].lbHatch   = 0;
            BDrawBrush[i].lbColor   = BColors[i];
            hBDrawBrush[i] = CreateBrushIndirect(&BDrawBrush[i]);
        }
        ReleaseDC(NULL, hdc);
        while (ShowCursor(FALSE) >=0 ) ;  /* remove anomallous show states */
        ShowCursor(TRUE);
        hAsterisk = LoadIcon(NULL, MAKEINTRESOURCE(IDI_ASTERISK));
        hQuestion = LoadIcon(NULL, MAKEINTRESOURCE(IDI_QUESTION));
    }
    else if (reason == DLL_PROCESS_DETACH) {
        for (i=0; i<16; i++) {
            if (hBDrawBrush[i])
                DeleteObject(hBDrawBrush[i]);
        }
#ifdef _DEBUG_
        ConsClose();
#endif /* _DEBUG_ */
    }
    return TRUE;
}


BOOL
GetEditText(hwnd, ItemId, buf, maxlen)
HWND hwnd;
int ItemId;
char *buf;
int maxlen;
{
    int i;
    char tbuf[80], *cp;
    
    i = SendDlgItemMessage(hwnd, ItemId, (UINT)WM_GETTEXTLENGTH,
            (WPARAM) 0, (LPARAM) 0);
    if (i <=0 || i >= sizeof(tbuf)-1)
        return FALSE;
    else if (i > 0) {
        SendDlgItemMessage(hwnd, ItemId, (UINT)WM_GETTEXT,
            (WPARAM) i+1, (LPARAM) tbuf);
        tbuf[i+1] = 0;
        cp = stripLeadingSpace(tbuf);
        strncpy(buf, cp, sizeof(tbuf));
        stripTrailingSpace(buf);
    }
    return TRUE;
}


void
usermsg(hwnd, msg)
HWND hwnd;
char *msg;
{
    strcpy(msgbuf,msg);

    if (IsIconic(hwnd)) {
        OpenIcon(hwnd);
        EnableWindow(hwnd, TRUE);
    }
    DialogBox(hInstDLL, MAKEINTRESOURCE(IDD_MESSAGE), hwnd, UserMsgProc);
}


BOOL
yesno(hwnd, msg)
HWND hwnd;
char *msg;
{
    int r;
    extern BOOL CALLBACK YesNoProc();

    strcpy(msgbuf,msg);

    if (IsIconic(hwnd)) {
        OpenIcon(hwnd);
        EnableWindow(hwnd, TRUE);
    }
    r = DialogBox(hInstDLL, MAKEINTRESOURCE(IDD_YESNO), hwnd, YesNoProc);
    return r;
}

void
fatal(hwnd, s)
HWND hwnd;
char *s;
{
    char xbuf[256];
    int e;
    extern char *StrError(int);
    
    e = GetLastError();
    sprintf(xbuf,"ERROR: %s (code %d) %s",s, e, StrError(e));
    usermsg(hwnd, s);
    ExitProcess(1);
}


void
Copyright(int version, HWND hwnd)
{
    for (Cscreen = 0; Cscreen < NSCREENS; Cscreen++)
        DialogBox(hInstDLL, MAKEINTRESOURCE(IDD_COPYRIGHT), hwnd, CpyRightProc);
}


POINT *
DialogPos(cwnd)
HWND cwnd;    /* position cwnd in center of pwnd */
{
    HWND pwnd;
    RECT pr,cr;
    static POINT p;
    int xmax, ymax;

    xmax = GetSystemMetrics(SM_CXSCREEN);
    ymax = GetSystemMetrics(SM_CYSCREEN);
    pwnd = GetParent(cwnd);

    GetClientRect(pwnd,&pr);
    GetClientRect(cwnd,&cr);
    p.x = p.y = 0;
    ClientToScreen(pwnd,&p);    /* upper left corner of parent on screen */
    if ((p.x < 20) || (p.x + (pr.right - pr.left)) > xmax+20) {
        pr.left = 0;
        pr.right = xmax;
        p.x = 0;
    }
    if ((p.y < 20) || (p.y + (pr.bottom - pr.top)) > ymax+20) {
        pr.top = 0;
        pr.bottom = ymax;
        p.y = 0;
    }
    p.x += ((pr.right - pr.left) - (cr.right - cr.left)) / 2;
    p.y += ((pr.bottom - pr.top) - (cr.bottom - cr.top)) / 2;
    return &p;
}

int
VSTLVersion()
{
    return VSTVERSION;
}
