#ifndef _CONSTANT_H
#define _CONSTANT_H
/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


/*
 * Elset propagation models
 */
#define TLEMEAN     0
#define NORADSGP4   1
#define NORADSPD4   2

#undef  ABS
#define ABS(x)      (((x) < 0) ? (-(x)) : (x) )
#undef  MIN
#define MIN(x,y)    (((x) < (y)) ? (x) : (y))
#undef  MAX
#define MAX(x,y)    (((x) > (y)) ? (x) : (y))
#undef  SQR
#define SQR(x)      ((x)*(x))


#undef  PI
#define PI                    3.14159265358979323846264338
#undef  TWOPI
#define TWOPI                 (2.0*PI)
#define FOURPI                (4.0*PI)
#define HALFPI                (0.5*PI)
#define THREEHALFPI           (1.5*PI)
#define CRD                   (360.0/TWOPI)        /* change rad into deg     */
#define CDR                   (TWOPI/360.0)        /* change deg into rad     */
#define CRREV                 (1.0/TWOPI)          /* change rad into rev     */
#define EPSILON               (HALFPI/1296000.0)   /* 0.125 arcsec in rad     */
#define MPD                   1440.0               /* minutes per day         */
#define MPD2                  (MPD*MPD)            /* (minutes per day)^2     */
#define MPD3                  (MPD2*MPD)           /* (minutes per day)^3     */
#define SPD                   86400.0              /* seconds per day         */
#define CMKM                  1.0e-3               /* change m to km          */
#define CKMNM                 (1.0/1.852)          /* change km to naut. mil. */
#define CHZKHZ                1.0e-3               /* change Hz to kHz        */
#define CKHZMHZ               1.0e-3               /* change kHz to MHz       */
#define CHZMHZ                1.0e-6               /* change Hz to MHz        */

#define EARTHRADIUS           6378.140             /* earth's equatorial radius [km]  */
#define EARTHECCEN            0.01675104           /* Earth's orbit eccentr.  */
#define F                     (1.0/298.257)        /* 0.003352813178  geoid model parameters  */
#define FF                    (F*F)
#define FFF                   (FF*F)
#define F1                    (-F - 0.5*FF)
#define F2                    (0.5*FF + 0.5*FFF)
#define F3                    (-1.0/3.0*FFF)
#define REFF0                 (1.0 - 0.5*F + 5.0/16.0*FF + 5.0/32.0*FFF)
#define REFF1                 (0.5*F - 13.0/64.0*FFF)
#define REFF2                 (-5.0/16.0*FF - 5.0/32.0*FFF)
#define REFF3                 (13.0/64.0*FFF)

#define SUNRADIUS             695980.0             /* equatorial radius [km]  */
#define SUNDISKRAD            (16.0*CAMR)          /* Sun disk radius [rad]   */
#define SUNPROX               48.0                 /* Sun prox limit [arcmin] */
#define SUNSEMIMAJORAXIS      149597892.0          /* 1 au [km]               */
#define TWILIGHT              (-6.0*CDR)           /* nautical twilight limit */
#define CVAC                  2.99792458e5         /* speed of light [km/s]   */

#define JULCENT               36525.0              /* mean solar days / jcy   */
#define TROPCENT              36524.219879         /* mean solar days / cy    */
#define TROPYEAR              (TROPCENT/100.0)     /* mean solar days / year  */
#define TROPICALYEAR          365.24219879         /* mean solar days / year  */
#define JULDAT1900            2415020.0            /* Julian date of 1900.0   */
#define JULDAT1950            2433282.423          /* Julian date of 1950.0   */
#define JULDAT2000            2451545.0            /* Julian date of 2000.0   */
#define SIDSOLAR              1.002737909350       /* sidereal rotation rate  */
#define SIDRATE               (TWOPI/SPD*SIDSOLAR) /* [rad/s]                 */
#define GM                    398603.2             /* [km^3/s^2]              */
#define GMSGP                 398600.7995          /* value used in SGP model */
#if 0
#define KEPLER                331.254038           /* see below               */
#endif
#define KEPLER                331.25403846464185
#define KEPLERSGP             42241.10831          /* value used in SGP model */
                                                   /* with a [km] and T [min] */

/* KEPLER = (GM / (4 PI^2) * 3600)^(1/3) / 1000  with a [km] and T [min]      */

#define BEACON                146.0            /* default beacon frequ. [MHz] */
#define MAXPHASE              256              /* max. value for phase number */
#define MAXMODES              10               /* max. number of sat. modes   */

#define VLOWELEV              (-20.0*CDR)      /* low elevation level 1 [rad] */
#define LOWELEV               (-4.0*CDR)       /* low elevation level 2 [rad] */
#define MAXELEV               (88.0*CDR)       /* (was 40) max elevation warn limit    */
#define MAXDAYS               2.0              /* limit for rise time search  */

/*
 * Some useful constants
 */

#define ZERO                  0.0
#define ONEPPB                1.0e-9
#define ONEPPM                1.0e-6
#define TWOPPM                2.0e-6
#define ONETHIRD              (1.0/3.0)
#define TWOTHIRDS             (2.0/3.0)
#define THREEHALFS            (3.0/2.0)
#define ONE                   1.0
#define ONEMEG                1.0e6
#define TWOMEG                2.0e6

/*
 * More Unit conversions
 */

#define CRH                   (24.0/TWOPI)         /* convert rad into hours  */
#define CRS                   (86400.0/TWOPI)      /* convert rad into sec    */
#define CRD                   (360.0/TWOPI)        /* convert rad into deg    */
#define CRAM                  (21600.0/TWOPI)      /* convert rad into arcmin */
#define CRAS                  (1296000.0/TWOPI)    /* convert rad into arcsec */
#define CDR                   (TWOPI/360.0)        /* convert deg into rad    */
#define CAMR                  (TWOPI/21600.0)      /* convert arcmin into rad */
#define CASR                  (TWOPI/1296000.0)    /* convert arcsec into rad */
#define CRREV                 (1.0/TWOPI)          /* convert rad into rev    */

#define HALFDEG               (0.5*CDR)            /* half a deg [rad]        */


/*
 * Atmospheric parameters used for calculation of refraction
 *  -- Not currently used in VersaTrack. --
 */

#define SCALEHEIGHT           8.0              /* atmosph. scale height [km]  */
#define ATMPRESS              760.0            /* standard atm. press. [mmHg] */
#define AMBTEMP               15.0             /* standard amb. temp.  [C]    */
#define RELHUMID              30.0             /* standard rel. humidity [%]  */
#define WAVEL                 0.550            /* wavelength of observ. [um]  */
#define REFWAVEL              0.550            /* reference wavelength [um]   */

#define GEOSYNC               1
#define GEOSTAT               2
#define GEOSYNCMOT            0.05             /* maximum deviation in mean   */
                                               /* motion from 1 rev/d for     */
                                               /* geosynchronous satellites   */

#define GEOSTATINC            (10.0*CDR)       /* maximum inclination [deg]   */
                                               /* for geostationary sats      */

#define SUNUPDATEINT          (15.0/MPD)       /* update interval Sun [d]     */
#define PRECUPDATEINT         (120.0/MPD)      /* update interval precession  */
#define NUTEUPDATEINT         (120.0/MPD)      /* update interval nutation    */

#endif /* _CONSTANT_H */
