.TH PREDICT 1 "28 March 2000" "KD2BD Software" "KD2BD Software"
.SH NAME
predict \- Track and predict passes of satellites in Earth orbit
.SH SYNOPSIS
\fB predict\fP [ -u \fItle_update_source\fP -t \fItlefile\fP -q \fIqthfile\fP -s ]
.SH DESCRIPTION
\fBPREDICT\fP is a multi-user satellite tracking and orbital prediction
program written under the Linux operating system by John A. Magliacane,
KD2BD.  \fBPREDICT\fP tracks and predicts passes of satellites based on
the geographical location of the ground station, the current date and
time as provided by the computer system's clock, and Keplerian orbital
data for the satellites of interest to the ground station.

The operation of \fBPREDICT\fP is uncomplicated by design.  The start-up
screen of the program lists the program's main functions.  Several tracking
and orbital prediction modes are available, as well as several utilities
to manage the program's orbital database.

Orbital predictions are useful for determining in advance when a satellite
is expected to come within range of a ground station.  They can also be
used to look back to previous passes to help to confirm or identify past
observations.

\fBPREDICT\fP includes two orbital prediction modes to predict any pass
above a ground station (main menu option \fB[P]\fP), or list only those
passes that might be visible to a ground station through optical means
(main menu option \fB[V]\fP).  In either mode, the user is asked to
select a satellite of interest from a menu, and then asked to enter
the date and time (in UTC) at which prediction calculations should
start.

The current date and time may be selected by default by entering nothing
and hitting simply the ENTER key when prompted to enter the starting date
and time.

Otherwise, the starting date and time should be entered in the form:

	\fIDDMonYY HH:MM:SS\fP

Entering the time is optional.  If it is omitted, 00:00:00 is assumed.
After the date and time is entered, orbital calculations are started
and prediction information is displayed on the screen.

Pressing the ENTER key, the \fBY\fP key, or the space bar advances the
orbital predictions to a screen listing the next available passes.
Pressing the \fBL\fP key allows the currently displayed screen plus any
subsequent screens to be logged to a text file in your current working
directory.  The name given to this file is the name of the satellite plus
a \fI.txt\fP extension.  Any slashes or spaces appearing in the satellite
name are replaced by the underscore (_) symbol.  The logging feature may
be toggled on and off at any time by pressing the \fBL\fP key.  Exiting
the orbital prediction mode by pressing \fBN\fP or hitting the \fBESC\fPape
key will also close the log file.  The log file will be appended with
additional information if additional predictions are conducted for the
same satellite with the logging feature turned on.

Selecting \fB[V]\fP from \fBPREDICT's\fP main menu will permit a ground
station to only predict passes for satellites that are potentially visible
through optical means.  Since all other passes are filtered out in this mode,
and since some satellites may never arrive over a ground station when optical
viewing conditions are possible, the program provides the option of breaking
out of visual orbital prediction mode by pressing the \fBESC\fPape key as
calculations are made.  A prompt is displayed at the bottom of the screen
to alert the user of this option.

In either orbital prediction mode, predictions will not be attempted for
satellites that can never rise above the ground station's horizon, or for
satellites in geostationary orbits.  If a satellite is in range at the
starting date and time specified, \fBPREDICT\fP will adjust the starting
date back in time until the point of AOS so that the prediction screen
displays the first pass in its entirety from start to finish.

In addition to predicting satellite passes, \fBPREDICT\fP allows satellites
to be tracked singly in real-time using \fBPREDICT's\fP Single Satellite
Tracking Mode (main menu option \fB[T]\fP), or simultaneously as a group
of 24 using the program's Multi-Satellite Tracking Mode (main menu option
\fB[M]\fP). The positions of the Sun and Moon are also displayed when
tracking satellites in real-time.

Selecting option \fB[T]\fP from \fBPREDICT's\fP main menu places the program
in Single Satellite Tracking Mode.  The user will be prompted to select the
satellite of interest, after which a screen will appear and display tracking
positions for the satellite selected.

If a soundcard is present on your machine and the Single Satellite
Tracking Mode is invoked with an uppercase \fBT\fP rather than a lowercase
\fBt\fP, \fBPREDICT\fP will make periodic voice announcements stating the
satellite's tracking coordinates in real-time.  Announcements such as:

\fB"This is PREDICT.  Satellite is at 5 6 degrees azimuth and 4 5 degrees elevation, and approaching."\fP

are made at intervals that are a function of how quickly the satellite is
moving across the sky.  Announcements can occur as frequently as every 50
seconds for satellites in low earth orbits such as the International Space
Station (370 km), or as infrequently as every 8 minutes for satellites in
very high orbits, such as the GE-2 geostationary satellite (35780 km).  Voice
announcements are performed as background processes so as not to interfere
with tracking calculations as the announcements are made.  Announcements
can be forced at any time by pressing the \fBT\fP key in Single Satellite
Tracking Mode (provided it was started with an uppercase \fBT\fP).

Selecting \fB[M]\fP from \fBPREDICT's\fP main menu places the program in a
real-time multi-satellite tracking mode.  In this mode, all 24 satellites
in the program's database are tracked simultaneously along with the positions
of the Sun and Moon.  Tracking data for the satellites is displayed in two
columns of 12 satellites each.  A letter displayed to the right of the
slant range indicates the satellite's sunlight and eclipse conditions.
If the satellite is experiencing an eclipse period, an \fBN\fP is displayed.
If the satellite is in sunlight and the ground station is under the cover
of darkness, a \fBV\fP is displayed to indicate the possibility that the
satellite is visible under the current conditions. If the satellite is in
sunlight while conditions at the ground station do not allow the satellite
to be seen, a \fBD\fP is displayed.  Satellites in range of the ground station
are displayed in \fBBOLD\fP lettering.  The AOS dates and times for the next
three satellites predicted to come into range are displayed on the bottom
of the screen between the tracking coordinates of the Sun and Moon.
Predictions are not made for satellites in geostationary orbits or for
satellites so low in inclination and/or altitude that they can never rise
above the horizon of the ground station.

\fBPREDICT\fP may be run under the X-Window System by invoking it through the
\fBxpredict\fP script contained with the software. \fBxpredict\fP requires
that \fIrxvt\fP be installed on your system, although the script can be
modified to use \fIxterm\fP.  Holding down the SHIFT key while pressing
the plus (+) and minus (-) keys allow \fBPREDICT's\fP window to be re-sized.
.SH OPTIONS
By default, \fBPREDICT\fP reads ground station location and orbital data
information from a pair of files located in the user's home directory under
a hidden subdirectory named \fI.predict\fP.  Ground station location information
is held in a file named \fIpredict.qth\fP, while orbital data information for
24 satellites is held in a file named \fIpredict.tle\fP.

If we wish to run \fBPREDICT\fP using data from alternate sources instead
of these default files, the names of such files may be passed to \fBPREDICT\fP
on the command line when the program is started.  For example, if we wish to
read the TLE file \fIvisual.tle\fP and the QTH file \fIholiday.qth\fP rather
than the default files, we could start \fBPREDICT\fP and pass the names of
these alternate files to the program in the following manner:

        \fIpredict -t visual.tle -q holiday.qth\fP

or

        \fIpredict -q holiday.qth -t visual.tle\fP

If the files specified are not located in the current working directory,
then their relative or absolute paths should also be specified along with
their names.

It is also possible to specify only one alternate file while using the
default for the other.  For example,

        \fIpredict -t visual.tle\fP

reads QTH information from the default \fI~/.predict/predict.qth\fP
location, and TLE information from \fIvisual.tle\fP, while

        \fIpredict -q bobs.qth\fP

reads ground station location information from \fIbobs.qth\fP and TLE
information from the default \fI~/.predict/predict.tle\fP location.

It is also possible to update \fBPREDICT's\fP satellite orbital database
using another command line option that updates the database from a NASA
two-line element data set.  \fBPREDICT\fP then quietly exits without
displaying anything to the screen, thereby eliminating the need for
entering the program and selecting the appropriate menu options.  This
option is invoked using the \fI-u\fP command line switch as follows:

        \fIpredict -u orbs248.tle\fP

This example updates \fBPREDICT's\fP default orbital database with the
Keplerian elements found in the file \fIorbs248.tle\fP.  If an alternate
datafile requires updating, it may also be specified on the command line
using the \fI-t\fP switch as follows:

        \fIpredict -t oscar.tle -u amateur.txt\fP

This example updates the \fIoscar.tle\fP orbital database with the
two-line element data contained in \fIamateur.txt\fP.

These options permit the automatic update of \fBPREDICT's\fP orbital data
files using Keplerian orbital data obtained through automatic means such
as FTP or pacsat satellite download.

For example, the following script can be used to update \fBPREDICT's\fP
orbital database via the Internet:

        #!/bin/sh
        ftp -n ftp.celestrak.com << !
        user anonymous $LOGNAME@$HOSTNAME
        binary
        cd /pub/elements
        get amateur.txt
        quit
        !
        predict -u amateur.txt

To truly automate the process of updating your orbital database, save the
above commands to a file in your home directory (such as \fIkepupdate\fP),
and add the following line to your crontab (type crontab -e to edit your
crontab):

        \fI0 2 * * * kepupdate\fP

and \fBPREDICT\fP will automatically update its database every day at
2:00 AM.

It is also possible to run \fBPREDICT\fP as a background process and direct
its display to an unused virtual console by using the following command:

        \fIpredict < /dev/tty8 > /dev/tty8 &\fP

Switching to virtual console number 8 (ALT-F8) will allow \fBPREDICT\fP
to be controlled and displayed even after you've logged out.

\fBPREDICT\fP may also be started in a mode in which it acts as a socket-based
server for client programs that poll \fBPREDICT\fP for real-time tracking
data.  To activate the server features, invoke \fBPREDICT\fP with the
\fI-s\fP switch:

	\fIpredict -s\fP

\fBPREDICT\fP will start in MultiTrack mode when started as a server so
that the tracking data for all the satellites in the program's database
is immediately available to any client programs that require it.  Real-time
tracking data is available to client programs when \fBPREDICT\fP is run
in either the MultiTrack or Single Satellite Tracking modes.  Sample code
suitable for creating client software is available in the documentation
supplied with \fBPREDICT\fP. 

.SH FILES
.TP
\fC~/.predict/predict.tle\fR
Default database of orbital data
.TP
\fC~/.predict/predict.qth\fR
Default ground station location information
.SH AUTHORS
\fBPREDICT\fP was written by John A. Magliacane, KD2BD (kd2bd@amsat.org).
The socket server code was contributed by Ivan Galysh, KD4HBO (igalysh@tidalwave.net).
