//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __WINDOW_H
#define  __WINDOW_H

#ifndef  __STDIO_H
#include <stdio.h>
#endif

class Config;

class Window
{
public:
          enum        { Visible, NotVisible };

          Window*       altWin;
   static char          buf[ 256 ];
   static int           capture;
   static char*         capPath;
   static char*         errPath;
          int           fg;
          int           bg;
          int           bottom;
          int           state;
          int           top;
   static Window*       ZERO;
          int           zoomed;

                        Window( const int left,  const int top,
                                const int right, const int bottom,
                                const int bg,    const int fg );
  virtual              ~Window();
          void          clear();
          void          clearLine( const int line );
          void          highlight( const unsigned bufLen,
                                   const unsigned offset,
                                   const unsigned len,
                                   const int      fg,
                                   const int      bg ) const;
          void          print( const char* );
          void          print( const char*, const unsigned );
          void          printALFD( const char* c );
          void          printColor( const int fg, const int bg, const char *c );
          void          printFatal( const char* );
          void          printHex( const char*, const unsigned );
          void          printLine( const int line, const char* c );
   static void          toggleCapture();
          void          zoom();

protected:
          int           ALFDlastPrint;
   static FILE*         captureFile;
          int           left;
   static const  char*  path;
          int           right;
          int           screenNum;
          int           xCur;
          int           yCur;
   static int           winCount;

          void          showMsgColor( const int, const int,
                                      const int, const int,
                                      const char*         ) const;
          void          capturePrint( const char* c );
          void          capturePrint( const char* c, const unsigned len );
          void          capturePrintHex( const char* c, const unsigned len );
};

#endif  __WINDOW_H
