//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __WINDOW_H
#include "window.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __WIN_H
#include "win.h"
#endif

char    Window::buf[ 256 ];
int     Window::capture = 0;
char*   Window::capPath = "";
FILE*   Window::captureFile = 0;
char*   Window::errPath = "";
int     Window::winCount = 0;
Window* Window::ZERO = 0;

Window::Window( const int   left,  const int top,
                const int   right, const int bottom,
                const int   bg,    const int fg )
              :
                left( left ), right( right ), top( top ),
                bottom( bottom ), bg( bg ), fg( fg ), state( Visible ),
                zoomed( 0 ), altWin( ZERO ), ALFDlastPrint( 0 )
// ------------------------------------------------------------------------
//  Constructor
// ------------------------------------------------------------------------
{
   if (!winCount)
   {
      initscwr();                                // init screen write funct
      initwin();                                 // init window functions
   }
   winCount++;
//   activate_virtual_screen( 2 );
//   activate_visible_screen();

   _setcursortype( _NOCURSOR );
}

Window::~Window()
// ------------------------------------------------------------------------
//  Destructor
// ------------------------------------------------------------------------
{
   winCount--;
   if (!winCount)
      dispose_screen( screenNum );
}

void Window::capturePrint( const char* c )
// --------------------------------------------------------------------------
//  Save null terminater string in the capture file.
// -------------------------------------------------------------------------
{
   if (!*c)                                      // ignore zero length string
      return;
   if (fputs( c, captureFile ) == EOF)
   {
      cputs( "\r\nError writing to capture file, " );
      cputs( sys_errlist[ errno ] );
      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
   }
}

void Window::capturePrint( const char* c, const unsigned len )
// --------------------------------------------------------------------------
//  Save a character array of len characters in the capture file.
// -------------------------------------------------------------------------
{
   if (fwrite( c, 1, len, captureFile ) != len )
   {
      cputs( "\r\nError writing to capture file, " );
      cputs( sys_errlist[ errno ] );
      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
   }
}

void Window::capturePrintHex( const char* c, const unsigned len )
// --------------------------------------------------------------------------
// File capture a data array in hexidecimal
// --------------------------------------------------------------------------
{
   int i;
   int j = 0;
   do
   {
      fputs( "\n", captureFile );
      fprintf( captureFile, "%03x:  ", j );
      for (i = j; i < j + 16; i++)
      {
         if (i < len)
            fprintf( captureFile, "%02x", c[ i ] );
         else
            fputs( "  ", captureFile );
         if ((i + 1) % 4 == 0)
            fputc( ' ', captureFile );
      }
      fputs( "  ", captureFile );
      for (i = j; i < j + 16; i++)
      {
         if (i < len)
            if ((c[ i ] >> 1) < 0x20)
               fputc( '.', captureFile );
            else
               fputc( c[ i ] >> 1, captureFile );
         else
            fputc( ' ', captureFile );
      }
      fputs( "  ", captureFile );
      for (i = j; i < j + 16; i++)
      {
         if (i == len)
            break;
         if ((c[ i ] < 0x20) || (c[ i ] > 0x7e))
            fputc( '.', captureFile );
         else
            fputc( c[ i ], captureFile );
      }
      j += 16;
   }  while (i < len);
}

void Window::clear()
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
//   if (state == NotVisible)
//      activate_virtual_screen( 2 );

   if (state == Visible)
   {
      window( left, top, right, bottom );
      textattr( (bg << 4) + fg );                // set color
      clrscr();
      xCur = 1;
      yCur = 1;
   }

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::clearLine( const int line )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
//   if (state == NotVisible)
//      activate_virtual_screen( 2 );

   if (state == Visible)
   {
      window( left, top, right, bottom );
      textattr( (bg << 4) + fg );                // set color
      gotoxy( 1, line );
      clreol();
      xCur = 1;
      yCur = line;
   }

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::highlight( const unsigned bufLen,
                        const unsigned offset,
                        const unsigned len,
                        const int      fg,
                        const int      bg ) const
// --------------------------------------------------------------------------
//    Highlight a portion of the buffer that was last written to the window.
//
// Parameters
//    bufLen - the length of the buffer that was last written
//    offset - the beginning of the portion that is to be highlighted
//    len    - the length of the portion that is to be highlighted
//    fg     - the foreground color of the highlighting
//    bg     - the background color of the highlighting
// --------------------------------------------------------------------------
{
   if (state == Visible)
   {

      // A buffer of 80 bytes results in a line feed, so we test for < 80.
      // We have assumeds that there will be no buffers longer than 163 bytes
      // that need to have highlighting.

      int line = top + yCur - 1;                 // last line absolute pos
      if (bufLen < 80)                           // if it wasn't a full line
      {}                                         // go for the last line in
      else                                       // the window; otherwise the
         if (bufLen < 160)
            line -= 1;                           // next to last
         else
            line -= 2;                           // second to last
      attrib( offset + 1, line, offset + len, line, fg, bg );
   }
}

void Window::print( const char* c )
// --------------------------------------------------------------------------
// Display a null terminated string and save it in the capture file.
// -------------------------------------------------------------------------
{
// if (state == NotVisible)
//    activate_virtual_screen( 2 );

   window( left, top, right, bottom );
   textattr( (bg << 4) + fg );                   // set color
   gotoxy( xCur, yCur );                         // set cursor pos

   if (state == Visible)
   {
      if (capture)
      {
         capturePrint( "\r\n" );
         capturePrint( c );
      }

      if (xCur != 1 || yCur != 1)                // don't add for top line
         cputs( "\r\n" );
      clreol();
      cputs( c );

      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
      ALFDlastPrint = 0;
   }
   else
      if (altWin != ZERO)
         altWin->print( c );
      else
         if (capture)
         {
            capturePrint( "\r\n" );
            capturePrint( c );
         }

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::print( const char* c, const unsigned len )
// --------------------------------------------------------------------------
//  Display a character array of len characters and save it in the capture.
//  Clean out control characters before displaying on the screen.
// -------------------------------------------------------------------------
{
// if (state == NotVisible)
//    activate_virtual_screen( 2 );

   window( left, top, right, bottom );
   textattr( (bg << 4) + fg );                   // set color
   gotoxy( xCur, yCur );                         // set cursor pos

   if (capture)
   {
      capturePrint( "\r\n" );
      capturePrint( c, len );
   }

   if (state == Visible)
   {
      char* cOut = new char[ len + 1 ];
      for (int i = 0; i < len; i++)              // clean out ctrl chars
         if (c[ i ] < 0x20 || c[ i ] > 0x7e)
            cOut[ i ] = '.';
         else
            cOut[ i ] = c[ i ];
      cOut[ i ] = 0;
      cputs( "\r\n" );
      clreol();
      cputs( cOut );
      delete cOut;

      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
      ALFDlastPrint = 0;
   }

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::printALFD( const char* c )
// --------------------------------------------------------------------------
// Same as print() except line feeds are not added.
// -------------------------------------------------------------------------
{
// if (state == NotVisible)
//    activate_virtual_screen( 2 );

   window( left, top, right, bottom );
   textattr( (bg << 4) + fg );                   // set color
   gotoxy( xCur, yCur );                         // set cursor pos

   if (state == Visible)
   {
      if (capture)
         capturePrint( c );
      if (!ALFDlastPrint)
         cputs( "\r\n" );
      cputs( c );
      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
      ALFDlastPrint = 1;
   }
   else
      if (altWin != ZERO)
         altWin->printALFD( c );
      else
         if (capture)
            capturePrint( c );

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::printColor( const int fg, const int bg, const char* c )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   print( c );
   unsigned len = strlen( c );
   highlight( len, 0, len, fg, bg );
}

void Window::printFatal( const char* c )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   window( left, top, right, bottom );
   textattr( (bg << 4) + fg );                   // set color
   gotoxy( xCur, yCur );                         // set cursor pos

   fcloseall();
   print( c );
   char* fileName = new char[ MAXPATH ];
   sprintf( fileName, "%sSATLINK.ERR", errPath );
   FILE* file = fopen( fileName, "at" );
   if (!file)
   {
      printf( "cannot open file %s", fileName );
      exit( 1 );
   }
   delete fileName;
   long timeNow = time( 0 );
   fprintf( file, "%s\n", ctime( &timeNow ) );
   fprintf( file, "%s\n", c );
   fclose( file );
   exit( 1 );
}

void Window::printHex( const char* c, const unsigned len )
// --------------------------------------------------------------------------
//  Display a data array in hexidecimal.
// --------------------------------------------------------------------------
{
//   if (state == NotVisible)
//      activate_virtual_screen( 2 );

   window( left, top, right, bottom );
   textattr( (bg << 4) + fg );                   // set color
   gotoxy( xCur, yCur );                         // set cursor pos

   if (capture)
      capturePrintHex( c, len );

   if (state == Visible)
   {
      int i, j = 0;
      do
      {
         cputs( "\r\n" );
         clreol();
         cprintf( "%03x:  ", j );
         for (i = j; i < j + 16; i++)
         {
            if (i < len)
               cprintf( "%02x", c[ i ] );
            else
               cputs( "  " );
            if ((i + 1) % 4 == 0)
               putch( ' ' );
         }
         cputs( "  " );
         for (i = j; i < j + 16; i++)
         {
            if (i < len)
               if ((c[ i ] >> 1) < 0x20)
                  putch( '.' );
               else
                  putch( c[ i ] >> 1 );
            else
               putch( ' ' );
         }
         cputs( "  " );
         for (i = j; i < j + 16; i++)
         {
            if (i == len)
               break;
            if ((c[ i ] < 0x20) || (c[ i ] > 0x7e))
               putch( '.' );
            else
               putch( c[ i ] );
         }
         j += 16;
      }  while (i < len);
      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
      ALFDlastPrint = 0;
   }

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::printLine( const int line, const char* c )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
//   if (state == NotVisible)
//      activate_virtual_screen( 2 );

   window( left, top, right, bottom );
   textattr( (bg << 4) + fg );                   // set color
   gotoxy( 1, line );                            // set cursor pos

   if (state == Visible)
   {
      // Both cputs and cprintf cause a new line in the window so
      // writeatnc is used.

      writeatnc( left, top + line - 1, (char*) c );
      xCur = wherex();                           // save new info cursor pos
      yCur = wherey();
   }

   if (capture)
   {
      capturePrint( "\r\n" );
      capturePrint( c );
   }

//   if (state == NotVisible)
//      activate_visible_screen();
}

void Window::toggleCapture()
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   if (capture)
   {
      capture = 0;
      fclose( captureFile );
   }
   else
   {
      time_t t = time( &t );                     // use the time to
      tm* tm = gmtime( &t );                     // make a 00YYMMDD file name
      char name[ 9 ];
      sprintf( (char*) &name, "%04i%02i%02i\x0", tm->tm_year, tm->tm_mon + 1,
                                                 tm->tm_mday );
      fnmerge( buf, 0, capPath, name, ".CAP" );  // merge the path components
      if ((captureFile = fopen( buf, "ab")) == 0)
         return;
      capture = 1;
      long timeNow = time( 0 );
      fprintf( captureFile, "\nCapture file opened: %s", ctime( &timeNow ) );
   }
}

void Window::zoom()
// ------------------------------------------------------------------------
//  This is currently coded only to zoom the frameWin.
// ------------------------------------------------------------------------
{
   static int origTop = top;
   static int origBot = bottom;
   if (zoomed)
   {
      top = origTop;
      bottom = origBot;
      window( left, top, right, bottom );
      clearLine( bottom - top + 1 );
      yCur = bottom - top;
      zoomed = 0;
   }
   else
   {
      print( " " );
      top = 2;
      bottom = 23;
      yCur = bottom - top + 1;
      clearbox( left, top, right, origTop - 1, fg, bg );
      zoomed = 1;
   }
}
