//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// --------------------------------------------------------------------------
// Visible and virtual screen and window functions
// --------------------------------------------------------------------------

#ifndef  __WIN_H
#define  __WIN_H

// The variable "active_screen" is defined in "scrwrite.c."  It must be
// defined elsewhere if "scrwrite.c" not used.

// Some of the functions that are not needed for SatLink are "commented out"
// to reduce the amount of compiled code.

// external interface prototypes

enum direction { up, down, left, right };

//    i n i t i a l i z e   a n d   t e r m i n a t e   f u n c t i o n s

void initwin();
void termwin();

//      v i s i b l e    a n d    v i r t u a l    f u n c t i o n s

void partsave( int x1, int y1, int x2, int y2, void * dest );
void part_restore( int x1, int y1, int x2, int y2, void * source );
void fillscreen( int x1, int y1, int x2, int y2, int f, int b, char c );
void getscreenword( int x, int y, int * attr, char * ch );
char getscreenchar( int x, int y );
int getscreenattr( int x, int y );
void getscreenstr( int x1, int x2, int y,  char * st );

//                   c u r s o r    f u n c t i o n s

void gotoXY( int x, int y);
int whereX();
int whereY();
void findcursor( int * x, int * y, int * top, int * bot );
void poscursor( int x, int y );
void sizecursor( int top, int bot );
void halfcursor();
void fullcursor();
void oncursor();
void offcursor();

//               s c r e e n   s a v i n g  f u n c t i o n s

void dispose_screen( int page );
int save_screen( int page );
void restore_screen( int page );
void part_restore_screen( int page, int x1, int y1,    // upper left
                                    int x2, int y2,    // lower right
                                    int  x, int  y );  // destination
void sliderestore_screen( int page, enum direction way );
void partsliderestore_screen( int page, enum direction way, int x1, int y1,
                                                            int x2, int y2 );

//   v i r t u a l    s c r e e n    s p e c i f i c   f u n c t i o n s

void clear_v_screen( int page );
int create_screen( int page, int lines );
void activate_visible_screen();
void activate_virtual_screen( int page );

//   v i s i b l e    s c r e e n    s p e c i f i c   f u n c t i o n s

void copyscreenblock( int x1, int y1, int x2, int y2, int x, int y );
void movescreenblock( int x1, int y1, int x2, int y2, int x, int y );
void scroll( enum direction way, int x1, int y1, int x2, int y2 );
void mkwin( int x1, int y1, int x2, int y2, int f, int b, int boxType );
void growmkwin( int x1, int y1, int x2, int y2, int f, int b, int boxType);
void rmwin();
void tempmessagech( int x, int y, int f, int b, char * st, char * ch );
void tempmessage( int x, int y, int f, int b, char * st );
void tempmessageboxch( int x1, int y1, int f, int b, int boxType,
                       char * st, char * ch );
void tempmessagebox( int x1, int y1, int f, int b, int boxType, char * st );

extern int w_fatal;                 // terminate program if fatal error

#define MAX_WINDOWS 10              // change this constant as necessary
#define MAX_SCREENS 10              // change this constant as necessary

#endif  __WIN_H
