//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// window functions

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __WIN_H
#include "win.h"
#endif

// internal prototypes

void winError( unsigned no );

typedef struct ScreenImage {
   int curx;                                     // cursor location
   int cury;
   int scantop;                                  // cursor shape
   int scanbot;
   int savedlines;
   int (*screenptr)[ 80 ];                       // pointer to screen data
} ScreenImage;

ScreenImage * screen[ MAX_SCREENS ];

/*
typedef struct WindowImage
{
   int curx;                                  
   int cury;
   int scantop;                               
   int scanbot;
   int coord[ 4 ];                               // window coords
   void * screenptr;                             
} WindowImage;

WindowImage * win[ MAX_WINDOWS ];
*/

int wError;               // global variable to report win errors
int w_fatal = 0;          // don't terminate program if fatal error
int displaylines;
int windowCounter = 0;
int screencounter = 0;
int active_v_screen = 0;
int starttop;             // used to record initial screen state when program is run
int startbot;
int startmode;

void far * base_of_screen;

void winError( int no )
// --------------------------------------------------------------------------
// Updates wError and optionally displays error message and halts program
// --------------------------------------------------------------------------
{
   wError = no;
   char * msgi;
   if (w_fatal)
   {
      switch (no)
      {
         case  1: msgi = "max screens exceeded"; break;
         case  2: msgi = "max windows exceeded"; break;
         case  3: msgi = "insufficient memory to create screen"; break;
         case  4: msgi = "screen not saved cannot activate."; break;
         case  5: msgi = "screen has not been created - cannot activate"; break;
         case  6: msgi = "screen has not been created - cannot dispose"; break;
         case  7: msgi = "screen has not been created - cannot restore"; break;
         case  8: msgi = "screen)es not exist cannot clear"; break;
         case  9: msgi = "insufficient memory for screen copy/move"; break;
         case 10: msgi = "visible screen must be active for window operations"; break;
         case 11: msgi = "visible screen must be active for message operations"; break;
         case 12: ; break; // reserved for non-fatal error settings condensed mode
         case 13: msgi = "can only save 25 screen lines - check const savedlines"; break;
         case 14: msgi = "'gettext' function error saving screen"; break;
         case 15: msgi = "'puttext' function error restoring screen"; break;
         default: msgi = "? -- utterly confused";
      }
      printf( "\nwin, fatal error: %s\n", msgi );
      delay( 5000 );           // display long enough to read if child process
      exit( 11 );              // returns errorlevel 11
   }
}

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//      v i s i b l e    a n d    v i r t u a l    f u n c t i o n s
//
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/*
void partsave( int x1, int y1, int x2, int y2, void * dest )
// --------------------------------------------------------------------------
// Transfers data from active virtual screen to dest
// --------------------------------------------------------------------------
{
   unsigned width = (x2 - x1 + 1)*2;
   for (int i = y1; i <= y2; i++)
      movedata ( FP_SEG( active_screen ),
                 FP_OFF( active_screen ) + (i - 1)*160 + (x1 - 1)*2,
                 FP_SEG( dest ),
                 FP_OFF( dest ) + (i - y1) * width,
                 width );
}
*/

void part_restore( int x1, int y1, int x2, int y2, void * source )
// --------------------------------------------------------------------------
// Restores data from source and transfers to active virtual screen
// --------------------------------------------------------------------------
{
   int width = (x2 - x1 + 1)*2;
   for (int i = y1; i <= y2; i++)
      movedata ( FP_SEG( source ),
                 FP_OFF( source ) + (i - y1) * width,
                 FP_SEG( active_screen ),
                 FP_OFF( active_screen ) + (i - 1)*160 + (x1 - 1)*2,
                 width );
}

/*
void fillscreen( int x1, int y1, int x2, int y2, int f, int b, char c )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   wError = 0;
   attrib( x1, y1, x2, y2, f, b );
   for (; y1 <= y2; y1++)
      horizline( x1, x2, y1, c );
}

void getscreenword( int x, int y, int * attr, char * ch )
// --------------------------------------------------------------------------
// Updates attr and ch with attribute and character bytes in screen
// location (x, y) of the active screen
// --------------------------------------------------------------------------
{
   struct
   {
      char ch;
      char attr;
   } sw;
   movedata (
              FP_SEG( active_screen ),
              FP_OFF( active_screen ) + (y - 1)*160 + (x - 1)*2,
              FP_SEG( &sw ),
              FP_OFF( &sw ),
              2 );
   *attr = sw.attr;
   *ch   = sw.ch;
}

char getscreenchar( int x, int y )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   int attr;
   char ch;
   getscreenword( x, y, &attr, &ch );
   return ch;
}

int getscreenattr( int x, int y )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   int attr;
   char ch;
   getscreenword( x, y, &attr, &ch );
   return attr;
}

void getscreenstr( int x1, int x2, int y,  char * st )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   st = "";
   for (int i = x1; i <= x2; i++)
   st[ i ] = getscreenchar( i, y );
}

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//                      c u r s o r    f u n c t i o n s
//
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

void gotoXY( int x, int y)
// --------------------------------------------------------------------------
// Intercepts normal Borland C++ gotoxy(), in case a virtual screen is
// active.
// --------------------------------------------------------------------------
{
   if (active_screen == base_of_screen)
      gotoxy( x, y );
   else
   {
       screen[ active_v_screen ]->curx = x;
       screen[ active_v_screen ]->cury = y;
   }
}

int whereX()
// --------------------------------------------------------------------------
// Use in place of normal Broland C++ wherex(), in case a virtual screen
// is active.
// --------------------------------------------------------------------------
{
   if (active_screen == base_of_screen)
      return wherex();
   else
      return screen[ active_v_screen ]->curx;
}

int whereY()
// --------------------------------------------------------------------------
// Use in place of normal Borland C++ wherex(), in case a virtual screen
// is active.
// --------------------------------------------------------------------------
{
   if (active_screen == base_of_screen)
      return wherey();
   else
      return screen[ active_v_screen ]->cury;
}
*/

void findcursor( int *x,   int *y, int *top, int *bot )
// --------------------------------------------------------------------------
// Get cursor coordinates and top/bot of screen
// --------------------------------------------------------------------------
{
   union {
      struct REGPACK x;
      struct BYTEREGS h;
   } reg;

   if (active_screen == base_of_screen)          // visible screen is active
   {
      reg.x.r_ax = 0x0f00;                       // get page in bx
      intr( 0x10, &reg.x );
      reg.x.r_ax = 0x0300;
      intr( 0x10, &reg.x );
      *x = reg.h.dl + 1;
      *y = reg.h.dh + 1;
      *top = reg.h.ch & 0x0F;
      *bot = reg.h.cl & 0x0F;
   }
   else                                          // virtual screen active_
      {
         *x = screen[ active_v_screen ]->curx;
         *y = screen[ active_v_screen ]->cury;
         *top = screen[ active_v_screen ]->scantop;
         *bot = screen[ active_v_screen ]->scanbot;
      }
}

void poscursor( int x, int y )
// --------------------------------------------------------------------------
// Set cursor position
// --------------------------------------------------------------------------
{
   struct REGPACK reg;

   if (active_screen == base_of_screen)          // visible screen is active
   {
      reg.r_ax = 0x0F00;                         // get page in bx
      intr( 0x10, &reg );
      reg.r_ax = 0x0200;
      reg.r_dx = ((y-1) << 8) | ((x-1) & 0x00ff);
      intr( 0x10, &reg );
   }
   else                                          // virtual screen active
   {
      screen[ active_v_screen ]->curx = x;
      screen[ active_v_screen ]->cury = y;
   }
}

void sizecursor( int top, int bot )
// --------------------------------------------------------------------------
// Set size of cursor
// --------------------------------------------------------------------------
{
   struct REGPACK reg;

   if (active_screen == base_of_screen)          // visible screen is active
   {
      reg.r_ax = 1 << 8;
      reg.r_cx = (top << 8) + bot;
      intr( 0x10, &reg );
   }
   else                                          // virtual screen active
   {
      screen[ active_v_screen ]->scantop = top;
      screen[ active_v_screen ]->scanbot = bot;
   }
}

/*
void halfcursor()
// --------------------------------------------------------------------------
// Set half cursor
// --------------------------------------------------------------------------
{
   if (base_of_screen == monoAddr)
      sizecursor( 8, 13 );
   else
      sizecursor( 4, 7 );
}

void fullcursor()
// --------------------------------------------------------------------------
// Set full cursor
// --------------------------------------------------------------------------
{
   if (base_of_screen == monoAddr)
      sizecursor( 0, 13 );
   else
      sizecursor( 0, 7 );
}

void oncursor()
// --------------------------------------------------------------------------
// Trun on cursor
// --------------------------------------------------------------------------
{
   if (base_of_screen == monoAddr)
      sizecursor( 12, 13 );
   else
      sizecursor( 6, 7 );
}

void offcursor()
// --------------------------------------------------------------------------
// Trun off cursor
// --------------------------------------------------------------------------
{
    sizecursor( 14, 0 );
}
*/

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//               s c r e e n   s a v i n g   f u n c t i o n s
//
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

void dispose_screen(int page)
// --------------------------------------------------------------------------
// Free allocated memory and set pointer to null.
// --------------------------------------------------------------------------
{
   if (!screen[ page ])
   {
      winError( 6 );
      return;
   }
   else
      wError = 0;
    delete screen[ page ]->screenptr;
    delete screen[ page ];
    screen[ page ] = 0;
    if (active_v_screen == page)
       activate_visible_screen();
    screencounter--;
}

int save_screen( int page )
// --------------------------------------------------------------------------
// Save screen display and cursor details
// --------------------------------------------------------------------------
{
   if (page > MAX_SCREENS)
   {
      winError( 1 );
      return 1;
   }
   if (screen[page] != 0 && displaylines != screen[ page ]->savedlines)
      dispose_screen( page );
   if (screen[ page ] == 0)                      // need to allocate memory
   {
      if ((screen[ page ] = new ScreenImage) == 0)
      {
         winError( 3 );
         return 1;
      }
      if ((screen[ page ]->screenptr = (int (*)[])
                                       (new int[ displaylines*80 ])) == 0)
      {
         winError( 3 );
         delete screen[ page ];
         screen[ page ] = 0;
         return 1;
      }
      screencounter++;
   }
                                                 // save cursor position and shape
   findcursor( &screen[ page ]->curx,    &screen[ page ]->cury,
               &screen[ page ]->scantop, &screen[ page ]->scanbot );
   screen[ page ]->savedlines = displaylines;
   if ((gettext( 1, 1, 80, displaylines, screen[ page ]->screenptr )) == 0)
   {
      winError( 14 );
      return 1;
   }
   wError = 0;
   return 0;
}

void restore_screen(int page)
// --------------------------------------------------------------------------
// Display a screen that was previously saved
// --------------------------------------------------------------------------
{
   if (screen[ page ] == 0)
   {
      winError( 7 );
      return;
   }
   else
      wError = 0;
   if (puttext( 1, 1, 80, screen[ page ]->savedlines,
                          screen[ page ]->screenptr) == 0)
   {
      winError( 15 );
      return;
   }
   poscursor( screen[ page ]->curx, screen[ page ]->cury );
   sizecursor( screen[ page ]->scantop, screen[ page ]->scanbot );
}

void part_restore_screen( int page, int x1, int y1,  // upper left
                                    int x2, int y2,  // lower right
                                    int  x, int  y ) // destination
// --------------------------------------------------------------------------
// Move from heap to screen,  part of saved screen
// --------------------------------------------------------------------------
{
   if (screen[ page ] == 0)
   {
      winError( 7 );
      return;
   }
   else
      wError = 0;

   y--;
   for (y1--; y1 < y2; y1++)                     // row 1, col 1 is 0,0
   {
      int dx = x - 1;
      for (int sx = x1 - 1; sx < x2; sx++)
      {
         active_screen[ y ][ dx ] = screen[ page ]->screenptr[ y1 ][ sx ];
         dx++;
      }
      y++;
   }
}

/*
void sliderestore_screen( int page, enum direction way )
// --------------------------------------------------------------------------
// display a screen that was previously saved,  with fancy slide
// --------------------------------------------------------------------------
{
   if (screen[page] == 0)
   {
      winError( 7 );
      return;
   }
   else
      wError = 0;
   switch (way)
   {
      case up :
         for (int i = displaylines; i >= 1; i--)
         {
            part_restore_screen( page,
                                 1, 1, 80, displaylines - i + 1, 1, i);
            delay( 50 );
         }
         break;
      case down:
         for (i = 1; i <= displaylines; i++)
         {
            part_restore_screen( page,
                                 1, displaylines - i + 1,
                                 80, displaylines, 1, 1 );
            delay( 50 );                         // savor the moment!
         }
         break;
      case left:
         for (i = 1; i <= 80; i++)
            part_restore_screen( page,
                                 1, 1, i, displaylines, 79 - i, 1 );
         break;
      case right:
         for (i = 80; i >= 1; i--)
            part_restore_screen( page, i, 1, 80, displaylines, 1, 1);
   }
   poscursor( screen[ page ]->curx, screen[ page ]->cury );
   sizecursor( screen[ page ]->scantop, screen[ page ]->scanbot );
}


void partsliderestore_screen( int page, enum direction way, int x1, int y1,
                                                            int x2, int y2 )
// --------------------------------------------------------------------------
// Display a screen that was previously saved, with fancy slide
// --------------------------------------------------------------------------
{
   if (screen[ page ]  == 0)
   {
      winError( 7 );
      return;
   }
   wError = 0;
   switch (way)
   {
      case up:
         for (int i = y2; i >= y1; i--)
         {
            part_restore_screen( page, x1, y1, x2, y1+ y2 - i, x1, i);
            delay( 50 );
         }
         break;
      case down:
         for (i = y1; i <= y2; i++)
         {
            part_restore_screen( page, x1, y1 + y2 - i, x2, y2, x1, y1 );
            delay( 50 );                         // savor the moment!
         }
         break;
      case left:
         for (i = x1; i <= x2; i++)
            part_restore_screen( page, x1, y1, i, y2, x1 + x2 - i, y1 );
         break;
      case right:
         for (i = x2; i >= x1; i--)
            part_restore_screen( page, i, y1, x2, y2, x1, y1 );
   }
}
*/

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//   v i r t u a l    s c r e e n    s p e c i f i c   f u n c t i o n s
//
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

void clear_v_screen( int page )
// --------------------------------------------------------------------------
// Clear virtual screen
// --------------------------------------------------------------------------
{
   if (screen[ page ] == 0)
   {
      winError( 8 );
      return;
   }
   else
      wError = 0;
   int (far *temp)[];
   temp = active_screen;
   active_screen = screen[ page ]->screenptr;
   clearbox( 1, 1, 80, screen[ page ]->savedlines, YELLOW, BLACK );
   active_screen = temp;
}

int create_screen( int page, int lines )
// --------------------------------------------------------------------------
// Create a screen
// --------------------------------------------------------------------------
{
   wError = 0;
   if (page > MAX_SCREENS)
   {
      winError( 1 );
      return 1;
   }
   if (screen[ page ] != 0 && lines != screen[ page ]->savedlines)
      dispose_screen( page );
   if (screen[ page ] == 0)                      // need to allocate memory
   {
      if ((screen[page] = new ScreenImage) == 0)
      {
         winError( 3 );
         return 1;
      }
      if ((screen[ page ]->screenptr = (int (*)[])
                                       (new int[ displaylines*80 ])) == 0)
      {
         winError( 3 );
         delete screen[ page ];
         screen[ page ] = 0;
         return 1;
      }
      screencounter++;
   }
   if (base_of_screen == colorAddr)
   {
      screen[ page ]->scantop = 12;
      screen[ page ]->scanbot = 13;
   }
   else
   {
      screen[ page ]->scantop = 6;
      screen[ page ]->scanbot = 7;
   }
   screen[ page ]->curx = 1;
   screen[ page ]->cury = 1;
   screen[ page ]->savedlines = lines;
   clear_v_screen( page );
   return 0;
}

void activate_visible_screen(void)
// --------------------------------------------------------------------------
// activate_visible_screen:
// --------------------------------------------------------------------------
{
   active_screen = ( int (far *)[] )base_of_screen;
   active_v_screen = 0;
}

void activate_virtual_screen( int page )
// --------------------------------------------------------------------------
// activate_virtual_screen:
// --------------------------------------------------------------------------
{
   if (screen[ page ] == 0)
      winError( 4 );
   else
   {
      wError = 0;
      active_screen = screen[ page ]->screenptr;
      active_v_screen = page;
   }
}


// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//   v i s i b l e    s c r e e n    s p e c i f i c   f u n c t i o n s
//
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/*
void copyscreenblock( int x1, int y1, int x2, int y2, int x, int y )
// --------------------------------------------------------------------------
// copies text and attributes from one part of screen to another
// --------------------------------------------------------------------------
{
   movetext( x1, y1, x2, y2, x, y );
}

void movescreenblock( int x1, int y1, int x2, int y2, int x, int y )
// --------------------------------------------------------------------------
// Moves text and attributes from one part of screen to another,
// replacing with blank character
// --------------------------------------------------------------------------
{
   wError = 0;
   char * sptr;
   if ((sptr = new char[ (y2 - y1 + 1) * (x2 - x1 + 1) * 2 ]) == 0)
   {
      winError( 9 );
      return;
   }
   partsave( x1, y1, x2, y2, sptr );
   for (int i = y1; i <= y2; i++)
      horizline( x1, x2, i, ' ' );
   part_restore( x, y, x + x2 - x1, y + y2 - y1, sptr );
   delete sptr;
}

void scroll( enum direction way, int x1, int y1, int x2, int y2 )
// --------------------------------------------------------------------------
// used for screen scrolling
// --------------------------------------------------------------------------
{
   const char replace_char = ' ';
   wError = 0;
   switch (way)
   {
      case up:
         copyscreenblock( x1, y1 + 1, x2, y2, x1, y1 );
         horizline( x1, x2, y2, replace_char );
         break;
      case down:
         copyscreenblock( x1, y1, x2, y2 - 1, x1, y1 + 1 );
         horizline( x1, x2, y1, replace_char );
         break;
      case left:
         copyscreenblock( x1 + 1, y1, x2, y2, x1, y1 );
         vertline( x2, y1, y2, replace_char );
         break;
      case right:
         copyscreenblock( x1, y1, x2 - 1, y2, x1 + 1, y1 );
         vertline( x1, y1, y2, replace_char );
   }
}

void createwin( int x1, int y1, int x2, int y2, int boxType )
// --------------------------------------------------------------------------
// called by mkwin and growmkwin
// --------------------------------------------------------------------------
{
   if (windowCounter >= MAX_WINDOWS)
   {
      winError( 2 );
      return;
   }
   if (boxType >= 5 && boxType <= 9 && x1 > 1)  // if there is a drop shadow
   {
       x1--;                                    // increase dimensions for box
       y2++;
   }
   WindowImage * wPtr;
   if ((wPtr = new WindowImage) == 0)           // allocate space
   {
      winError( 3 );
      return;
   }
   windowCounter++;
   win[ windowCounter ] = wPtr;
   if ((wPtr->screenptr = new char[ (y2-y1+1) * (x2-x1+1) * 2 ]) == 0)
   {
      delete wPtr;
      windowCounter--;
      winError( 3 );
      return;
   }
   wError = 0;
   partsave( x1, y1, x2, y2, wPtr->screenptr );
   wPtr->coord[ 1 ] = x1;
   wPtr->coord[ 2 ] = y1;
   wPtr->coord[ 3 ] = x2;
   wPtr->coord[ 4 ] = y2;
   findcursor( &wPtr->curx, &wPtr->cury, &wPtr->scantop, &wPtr->scanbot );
}

void mkwin( int x1, int y1, int x2, int y2, int f, int b, int boxType )
// --------------------------------------------------------------------------
// main function for creating window
// --------------------------------------------------------------------------
{
   if (active_v_screen != 0)
   {
      wError = 10;
      return;
   }
   wError = 0;
   createwin( x1, y1, x2, y2, boxType );
   int shadow = 0;
   if (boxType >= 5 && boxType <= 9 && x1 > 1)   // if there is a drop shadow
   {
      boxType -= 5;
      shadow = 1;
   }
   boxf( x1, y1, x2, y2, f, b, boxType );
   if (shadow)
   {
      y1++;
      y2++;
      vertline( x1 - 1, y1, y2, DARKGRAY, BLACK, '\xdb' );
      horizline( x1, x2 - 1, y2, DARKGRAY, BLACK, '\xdb' );
    }
}

void growmkwin( int x1, int y1, int x2, int y2, int f, int b, int boxType)
// --------------------------------------------------------------------------
// Same as mkwin but window explodes
// --------------------------------------------------------------------------
{
   if (active_v_screen != 0)
   {
      wError = 10;
      return;
   }
   wError = 0;
   createwin( x1, y1, x2, y2, boxType );
   int shadow = 0;
   if (boxType >= 5 && boxType <= 9 && x1 > 1)   // if there is a drop shadow
   {
      boxType -= 5;
      shadow = 1;
   }
   growfbox( x1, y1, x2, y2, f, b, boxType );
   if (shadow)
   {
      y1++;
      y2++;
      vertline( x1 - 1, y1, y2, DARKGRAY, BLACK, '\xdb' );
      horizline( x1, x2 - 1, y2, DARKGRAY, BLACK, '\xdb' );
   }
}

void rmwin()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (active_v_screen != 0)
   {
      wError = 10;
      return;
   }
   wError = 0;
   if (windowCounter > 0)
   {
      WindowImage * wp = win[ windowCounter ];
      part_restore( wp->coord[1],  wp->coord[2],  wp->coord[3],  wp->coord[4],
                     wp->screenptr );
      poscursor(  wp->curx,  wp->cury );
      sizecursor(  wp->scantop,  wp->scanbot );
      delete  wp->screenptr;
      delete wp;
      windowCounter--;
   }
}

void tempmessagech( int x, int y, int f, int b, char * st, char * ch )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   char savedline[ 160 ];
   if (active_v_screen != 0)
   {
      wError = 11;
      return;
   }
   wError = 0;
   partsave( x, y, (x - 1) + strlen( st ), y, savedline );
   writeat( x, y, f, b, st );
   *ch = getch();
   part_restore( x, y, (x - 1) + strlen( st ), y, savedline );
}

void tempmessage( int x, int y, int f, int b, char * st )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   char ch;
   tempmessagech( x, y, f, b, st, &ch );
}

void tempmessageboxch( int x1, int y1, int f, int b, int boxType,
                       char * st, char * ch )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (active_v_screen != 0)
   {
      wError = 11;
      return;
   }
   wError = 0;
   mkwin( x1, y1, x1 + 1 + strlen( st ), y1 + 2, f, b, boxType );
   writeat( x1 +1, y1 + 1, f, b, st );
   *ch = getch();
   rmwin();
}

void tempmessagebox( int x1, int y1, int f, int b, int boxType,
                     char * st )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   char ch;
   tempmessageboxch( x1, y1, f, b, boxType, st, &ch );
}
*/

void initwin(void)
// --------------------------------------------------------------------------
// Initialize windows functions
// --------------------------------------------------------------------------
{
   struct text_info ti;
   int x, y;

   gettextinfo( &ti );                           // record the initial state
   startmode = ti.currmode;                      // of screen when program
   displaylines = ti.screenheight;               // was executed
   base_of_screen = (void far *) video_addr();   // set video adapter addr
   active_screen = ( int (far *)[] )base_of_screen;
   findcursor( &x, &y, &starttop, &startbot );
}

void termwin()
// --------------------------------------------------------------------------
// Resets monitor mode and cursor settings to the state they
// were in at program startup.
// --------------------------------------------------------------------------
{
    textmode( startmode );
    sizecursor( starttop, startbot );
}
