//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __TERMINAL_H
#include "terminal.h"
#endif

#ifndef  __HWDEVICE_H
#include "hwdevice.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

Terminal::Terminal( unsigned& showDataHex ) : L1Protocol()
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{
   this->showDataHex = &showDataHex;
}

void Terminal::clean( char*& c, const unsigned count ) const
// ------------------------------------------------------------------------
//  Clean control characters out of array
// ------------------------------------------------------------------------
{
   char* cp = c;
   for (int i = 0; i < count; i++, cp++)
      if (!(*cp >= 0x20 && *cp <= 0x7e))
         if (*cp != '\r' && *cp != '\n')
            *cp = '.';
   c[ count ] = 0;                               // make it a string
}

void Terminal::flush( const char c )
// -------------------------------------------------------------------------
//  Handle poll request
// -------------------------------------------------------------------------
{
   if (loProto)
      ((HwDevice*) loProto)->flush( c );
}

void  Terminal::link( HwDevice& loPro )
// -------------------------------------------------------------------------
//  Link to hardware device
// -------------------------------------------------------------------------
{
   loProto = &loPro;
}

void Terminal::recvIn( MBuf& newBuf )
// -------------------------------------------------------------------------
//  Handle incoming Terminal mode data.
// -------------------------------------------------------------------------
{
   recvBytesIn += newBuf.cnt;                    // count bytes in
   recvFramesIn++;                               // count frames in
   clean( newBuf.data, newBuf.cnt );             // strip out control chars
   if (*showDataHex)                             // show data in hex
      frWin->printHex( newBuf.data, newBuf.cnt );
   else
      frWin->printALFD( newBuf.data );
   delete &newBuf;
}

int Terminal::send( MBuf& buf )
// -------------------------------------------------------------------------
//  Send an MBuf using Terminal mode; then delete the allocated memory.
//
//  The values returned are:
//           0 - Successfully sent the MBuf
//          >0 - Error, MBuf not sent (error code returned)
// -------------------------------------------------------------------------
{
	sendFramesOut++;                              // count outgoing frames
   sendBytesOut += buf.cnt;                      // count outgoing bytes
   if (!loProto)
      return 1;
   return loProto->send( buf );                  // send to hw device
}


