//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// SYNTAX.H

#ifndef SYNTAX_H
#define SYNTAX_H

#ifndef  __LEXICAL_H
#include "lexical.h"
#endif

class SStack;

class Equation
{
public:
   int     id;
   char*   keyTitle;
   SStack* stack;

           Equation();
   inline  ~Equation();
};

#define NUMADDOPS       2
#define NUMRELOPS       6
#define NUMPFHITEMS    23

class SyntaxAnalyzer
{
public:
           LexicalAnalyzer lex;
           Equation*       eqnList[ 15 ];
           int             eqnCount;

                           SyntaxAnalyzer( char* mycall, char* alias );
                           ~SyntaxAnalyzer();
           int             equationFile( char* path );
           void            defaultEqns();
           int             largestStackSize();

private:
           char*           statementToParse;
           Equation*       eqn;
           unsigned        maxEqnSize;
           SStack*         stack;
           unsigned        stackSize;
           char*           mycall;
           char*           alias;
           int             debug;
           int             errorFlag;
   static  short           AddOps[ NUMADDOPS ];
   static  short           RelOps[ NUMRELOPS ];
   static  short           PfhItems[ NUMPFHITEMS ];
   static  char*           errorMessages[ 15 ];

           Equation*       selectEquation( char* lineToParse );
           void            nameEquation();
           void            directive();
           void            equation();
           void            test();
           void            masks();
           void            keytitle();
           void            constant();
           void            value();
           void            simpleExpression();
           void            expression();
           int             inSet( short* set, int toFind, int numEntries );
           void            error( int errcode );

};

#endif
