//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __SYMBOL_H
#include "symbol.h"
#endif

#ifndef  __MATCH_H
#include "match.h"
#endif

char* Symbol::msg1 = "Memory allocation error (";

Symbol::Symbol() : type( -1 ), numVal( 0 ), str( 0 )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   *this->strVal = 0;
}

Symbol::Symbol( int type, unsigned long val )
              : type( type ), numVal( val ), str( 0 )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   *this->strVal = 0;
}

Symbol::Symbol( int type, char* val ) : type( type ), numVal( 0 ), str( 0 )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (val)
      strcpy( this->strVal, val );
   else
      *this->strVal = 0;
}

Symbol::Symbol( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this == &s)
      return;
   *this = s;
}

Symbol::~Symbol()
{}

void Symbol::set( int type, unsigned long val )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   this->type = type;
   this->numVal = val;
   this->str = 0;
   *this->strVal = 0;
}

void Symbol::set( int type, char* val )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   this->type = type;
   this->numVal = 0;
   if (val)
      strcpy( this->strVal, val );
   else
      *this->strVal = 0;
   this->str = 0;
}

void Symbol::append( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (strlen( this->strVal ) + strlen( s.strVal ) > MAXSYMLENGTH)
   {
      printf( "Symbol too long: <%s%s>\n", this->strVal, s.strVal );
      while (!kbhit());
      return;
   }
   strcat( this->strVal, s.strVal );
}

Symbol& Symbol::operator =( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this == &s)
      return *this;
   this->type = s.type;
   this->numVal = s.numVal;
   strcpy( this->strVal, s.strVal );
   this->str = s.str;
   return *this;
}

int Symbol::operator &&( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   return this->numVal && s.numVal;
}

int Symbol::operator ||( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   return this->numVal || s.numVal;
}

int Symbol::operator <( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this->str)
      return strcmp( this->str, s.strVal ) < 0;
   else
      if (*this->strVal)
         return strcmp( this->strVal, s.strVal ) < 0;
      else
         if (*s.strVal)
            return 0;
         else
            return this->numVal < s.numVal;
}

int Symbol::operator <=( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this->str)
      return strcmp( this->str, s.strVal ) <= 0;
   else
      if (*this->strVal)
         return strcmp( this->strVal, s.strVal ) <= 0;
      else
         if (*s.strVal)
            return 0;
         else
            return this->numVal <= s.numVal;
}

int Symbol::operator ==( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this->str)
      return match( s.strVal, this->str );
   else
      if (*this->strVal)
         return match( s.strVal, this->strVal ); // 1st parameter is pattern
      else
         if (*s.strVal)
            return 0;
         else
            return this->numVal == s.numVal;
/*
   if (this->str)
      return match( s.strVal, this->str );
   else
      if (*this->strVal)
         return match( s.strVal, this->strVal ); // 1st parameter is pattern
      else
         return this->numVal == s.numVal;
*/
}

int Symbol::operator !=( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this->str)
      return !match( s.strVal, this->str ) == 0;
   else
      if (*this->strVal)
         return !match( s.strVal, this->strVal );// 1st parameter is pattern
      else
         if (*s.strVal)
            return 0;
        else
           return this->numVal != s.numVal;
}

int Symbol::operator >=( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this->str)
      return strcmp( this->str, s.strVal ) >= 0;
   else
      if (*this->strVal)
         return strcmp( this->strVal, s.strVal ) >= 0;
      else
         if (*s.strVal)
            return 0;
         else
            return this->numVal >= s.numVal;
}

int Symbol::operator >( Symbol& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (this->str)
      return strcmp( this->str, s.strVal ) > 0;
   else
      if (*this->strVal)
         return strcmp( this->strVal, s.strVal ) > 0;
      else
         if (*s.strVal)
            return 0;
         else
            return this->numVal > s.numVal;
}

