//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// SSTACK.H

// Implements a stack of Symbols.

#ifndef __SSTACK_H
#define __SSTACK_H

class Symbol;

class SStack
{
public:
          int             debug;
          int             size;
          int             sp;
          int             errorFlag;

                          SStack( const int stackSize );
                          SStack( SStack& s );
                          ~SStack();
          void            reset() { sp = 0; }
          void            push( Symbol& s );
          Symbol*         pop();
          int             overflow() { return sp == this->size; }
          int             underflow() { return sp <= 0; }
          void            print() const;
          void            toLower();
          SStack& operator =( SStack& s );

private:
   static enum          { E_OUTOFMEMORY,
                          E_OVERFLOW,
                          E_UNDERFLOW };

          Symbol*         st;
   static char*           errorMessages[ 3 ];

          void            error( const int errorCode ) const;
};

#endif  __SSTACK_H
