//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __SSTACK_H
#include "sstack.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __CTYPE_H
#include <ctype.h>
#endif

#ifndef  __MEM_H
#include <mem.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __SYMBOL_H
#include "symbol.h"
#endif

char* SStack::errorMessages[] = { "Out of memory.",
                                  "Stack overflow.",
                                  "Stack underflow." };

SStack::SStack( const int stackSize ) : size( stackSize ), sp( -1 ),
                                        debug( 0 ), errorFlag( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   st = new Symbol[ stackSize ];
   if (stackSize && !st)
      error( E_OUTOFMEMORY );
   else
      sp = 0;
}

SStack::SStack( SStack& s ) : st( 0 )
// --------------------------------------------------------------------------
//  Copy constructor
// --------------------------------------------------------------------------
{
   if (this == &s)
      return;
   *this = s;
}

SStack::~SStack()
// --------------------------------------------------------------------------
//  Destructor
// --------------------------------------------------------------------------
{
   delete st;
}

SStack& SStack::operator =( SStack& s )
// --------------------------------------------------------------------------
//  Assignment operator
// --------------------------------------------------------------------------
{
   if (this != &s)
   {
      if (this->size < s.sp)                     // if not enough space
      {
         delete this->st;
         size = s.sp;
         this->st = new Symbol[ size ];
         if (size && !this->st)
         {
            this->sp = -1;
            error( E_OUTOFMEMORY );
         }
      }
      if (this->st)
      {
         this->sp = s.sp;
         memcpy( this->st, s.st, this->sp * sizeof( Symbol ) );

//       int i;
//       for (i = 0; i < this->sp; i++)
//       *this->st[ i ] = *s.st[ i ];
      }
   }
   return *this;
}

void SStack::push( Symbol& s )
// --------------------------------------------------------------------------
//  Push symbol address on the stack
// --------------------------------------------------------------------------
{
   if (this->debug && s.strVal)
      cprintf( "\r\npushed <%s>", s.strVal );
   if (this->sp >= 0 && this->sp < this->size )
      this->st[ sp++ ] = s;
   else
      error( E_OVERFLOW );
}

Symbol* SStack::pop()
// --------------------------------------------------------------------------
//  Pop symbol address from stack
// --------------------------------------------------------------------------
{
   if (debug && this->st[ sp-1 ].strVal)
      cprintf( "\r\npopped <%s>", this->st[ sp-1 ].strVal );
   if (sp)
      return &st[ --sp ];
   error( E_UNDERFLOW );
   return 0;
}

void SStack::print() const
// --------------------------------------------------------------------------
// Print tall the symbols on the stack.
// --------------------------------------------------------------------------
{
/*
   // Use this for easier debugging.  Remove to reduce program size.

   char* symbol[] =     {  "ENDOFLINE",               //  0
                           "ALIAS",                   //  1
                           "AND",                     //  2
                           "ASCTIME",                 //  3
                           "AUTO",                    //  4
                           "AX25_UPLOADER",           //  5
                           "BBS_MESSAGE_TYPE",        //  6
                           "BULLETIN_ID_NUMBER",      //  7
                           "COMPRESSION_DESC",        //  8
                           "COMPRESSION_TYPE",        //  9
                           "CREATE_TIME",             // 10
                           "DAY",                     // 11
                           "DAYS",                    // 12
                           "DEBUG",                   // 13
                           "DESTINATION",             // 14
                           "DOWNLOAD_COUNT",          // 15
                           "EQUATIONSIZE",            // 16
                           "EXPIRE_TIME",             // 17
                           "EXTRAMASK",               // 18
                           "F1",                      // 19
                           "F10",                     // 20
                           "F11",                     // 21
                           "F12",                     // 22
                           "F2",                      // 23
                           "F3",                      // 24
                           "F4",                      // 25
                           "F5",                      // 26
                           "F6",                      // 27
                           "F7",                      // 28
                           "F8",                      // 29
                           "F9",                      // 30
                           "FILE_DESCRIPTION",        // 31
                           "FILE_EXT",                // 32
                           "FILE_NAME",               // 33
                           "FILE_NUMBER",             // 34
                           "FILE_SIZE",               // 35
                           "FILE_TYPE",               // 36
                           "GETENVAR",                // 37
                           "HOUR",                    // 38
                           "HOURS",                   // 39
                           "INPUT",                   // 40
                           "KEYPRESS",                // 41
                           "KEYTITLE",                // 42
                           "KEYWORDS",                // 43
                           "LAST_MODIFIED_TIME",      // 44
                           "MASKAUTO",                // 45
                           "MASKDONE",                // 46
                           "MASKNEVER",               // 47
                           "MASKPRIORITY",            // 48
                           "MINUTE",                  // 49
                           "MINUTES",                 // 50
                           "MODULUS",                 // 51
                           "MOD",                     // 52
                           "MYADDR",                  // 53
                           "MYCALL",                  // 54
                           "NEVER",                   // 55
                           "OR",                      // 56
                           "PRECEDENCE",              // 57
                           "PRIORITY",                // 58
                           "SEU_FLAG",                // 59
                           "SOURCE",                  // 60
                           "TITLE",                   // 61
                           "TODAY",                   // 62
                           "UPLOAD_TIME",             // 63
                           "USER_FILE_NAME",          // 64
                           "WEEK",                    // 65
                           "WEEKS",                   // 66
                           "KBAND",                   // 67
                           "KBOR",                    // 68
                           "NOT",                     // 69
                           "OTHER",                   // 70
                           "IDENTIFIER",              // 71
                           "NUMCONSTANT",             // 72
                           "(",                       // 73
                           ")",                       // 74
                           "+",                       // 75
                           "-",                       // 76
                           "*",                       // 77
                           "/",                       // 78
                           "=",                       // 79
                           ",",                       // 80
                           ";",                       // 81
                           ":",                       // 82
                           "\\",                      // 83
                           "<",                       // 84
                           "<=",                      // 85
                           "!=",                      // 86
                           ">",                       // 87
                           ">=",                      // 88
                           "STRCONSTANT",             // 89
                           "STATUS" };                // 90
*/
   int i;
   for (i = 0; i < sp; i++)
   {
      Symbol* sp = &st[ i ];;
//    printf( "%i, Type = %s, numVal = %lu, strVal = %s, \n",
//            i, symbol[ sp->type ], sp->numVal, sp->strVal );
      cprintf( "\r\n%i, Type = %u, numVal = %lu, strVal = %s, ",
              i, sp->type, sp->numVal, sp->strVal );
   }
}

void SStack::toLower()
// --------------------------------------------------------------------------
//  Change all string symbols to lower case.
// --------------------------------------------------------------------------
{
   int i;
   for (i = 0; i < sp; i++)
   {
      char* cp = st[ i ].strVal;
      if (*cp)
         while (*cp != 0)
            *cp++ = tolower( *cp );
   }
}

void SStack::error( const int errorCode ) const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
      puts( errorMessages[ errorCode ] );
      puts( "Press any key to continue..." );
      while (!kbhit());
      getch();
}