//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef __SLIST_H
#define __SLIST_H

class StatusList;
class Window;

class StatusRec
{
public:
   inline                   StatusRec( const unsigned long fileNumber,
                                       const char          status,
                                       const long          lastTime );
                            StatusRec( const StatusRec& );
                            ~StatusRec() {};
private:
            signed   char   blockedFlag;
            unsigned long   fileNumber;
            unsigned long   lastTime;
            char            status;

            friend class    ActList;
            friend class    StatusList;
};

class Config;

class StatusList
{
public:
   static  enum sCode    { GRAB       = 0x00,
                           DOWNLOADED = 0x01,
                           AUTOMATIC  = 0x02,
                           NEVER      = 0x04,
                           PRIORITY   = 0x08,
                           ERROR      = 0x12 };

           StatusRec**     theArray;

                           StatusList( Config& cfg,
                                       Window& iWin,
                                       Window& frWin );
                           ~StatusList() {}
           void            displayRequested() const;
           void            load();
           void            unload() const;
           void            set( const unsigned long fileNumber,
                                const enum sCode status ) const;
   inline  int             status( const unsigned long fileNumber ) const;
   inline  int             status( const unsigned long fileNumber,
                                   const unsigned char fileType   ) const;
   inline  void            status( const unsigned long  fileNumber,
                                         int&           status,
                                         int&           blockedFlag ) const;
           int             blocked( const unsigned long fileNumber ) const;
           unsigned long   nextToDownload() const;
private:
           Config&         cfg;
           Window&         frWin;
           Window&         iWin;

           StatusRec&      lookup( const unsigned long fileNumber );
};

#endif
