//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __STDIO_H
#include <stdio.h>           // sprintf(), FILE
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>          // strlen()
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __ACTLIST_H
#include "actlist.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

StatusRec::StatusRec( const unsigned long fileNumber,
                      const char status,
                      const long lastTime )
                      :
                      fileNumber( fileNumber ),
                      status( status ),
                      lastTime( lastTime ),
                      blockedFlag( -1 )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{}

StatusRec::StatusRec( const StatusRec& s )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   status = s.status;
   lastTime = s.lastTime;
   blockedFlag = s.blockedFlag;
}

StatusList::StatusList( Config& cfg, Window& iWin, Window& frWin )
                      :
                      cfg( cfg ), iWin( iWin ), frWin( frWin )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   theArray = new StatusRec*[ 1000 ];
   if (!theArray)
   {
      fputs( "Error: out of Memory", stderr );
      exit( 1 );
   }
}

int StatusList::blocked( const unsigned long fileNumber ) const
{
// --------------------------------------------------------------------------
//  Get whether or not file is blocked.  Return -1 if the file is not found.
// --------------------------------------------------------------------------
   StatusRec* rp;
   for (int i = 0; i < 1000; i++)
   {
      rp = theArray[ i ];
      if (rp->fileNumber == fileNumber)
         return rp->blockedFlag;
   }
   return -1;
}

void StatusList::displayRequested() const
// --------------------------------------------------------------------------
//  Display the files that have been requested for downloading
// --------------------------------------------------------------------------
{
   for (int i = 0; i < 1000; i++)
      if (theArray[ i ]->status == PRIORITY ||
          theArray[ i ]->status == AUTOMATIC)
      {
         sprintf( iWin.buf, "Download:  %8lx %s", theArray[ i ]->fileNumber,
                  theArray[ i ]->status == PRIORITY ? "PRIORITY" : "AUTOMATIC" );
         iWin.print( iWin.buf );
      }
}

void StatusList::load()
// --------------------------------------------------------------------------
//  Load file status from SLIST.DAT
// --------------------------------------------------------------------------
{
   struct
   {
      unsigned long fileNumber;
      unsigned char status;
      char          dummy[3];
      long          lastTime;
   } sRec;

   char* fileName = new char[ strlen( cfg.workDir ) + 10 ];
   sprintf( fileName, "%sSLIST.DAT", cfg.workDir );

   FILE* sListFile;
   if ((sListFile = fopen( fileName, "rb" )) == 0) // if no file then
   {
      for (int i = 0; i < 1000; i++)               // an empty SLIST array
           theArray[ i ] = new StatusRec( 0, 0, 0 );
      delete fileName;
      return;
   }
   delete fileName;

   for (int i = 0; i < 1000; i++)
   {
      if (fread( &sRec, sizeof(sRec), 1, sListFile) != 1)
      {
         if (feof( sListFile ))
            frWin.printFatal( "Corrupted SLIST.DAT; end of file encountered" );
         else
            frWin.printFatal( "I/O error reading SLIST.DAT" );
      }
      theArray[ i ] = new StatusRec( sRec.fileNumber, sRec.status,
                                     sRec.lastTime );
   }
   fclose( sListFile );
}

unsigned long StatusList::nextToDownload() const
// --------------------------------------------------------------------------
//  Get the next file for downloading
// --------------------------------------------------------------------------
{
   unsigned long  fileNumber = 0;
   int            status = -1;
   unsigned long  time = 0xffffffffL;
   StatusRec*     rp;

   for (int i = 0; i < 1000; i++)
   {
      rp = theArray[ i ];
      if (rp->status == PRIORITY || rp->status == AUTOMATIC)
         if (rp->status > status)              // if higher ranking
         {                                       // then choose ith file
            fileNumber = rp->fileNumber;
            time = rp->lastTime;
            status = rp->status;
         }
         else
            if (rp->status == status)          // if same ranking
               if (rp->lastTime < time)        // then choose earlier file
               {
                  fileNumber = rp->fileNumber;
                  time = rp->lastTime;
               }
   }
   return fileNumber;
}

void StatusList::set( const unsigned long fileNumber,
                      const enum sCode    status        ) const
// --------------------------------------------------------------------------
// Update status of a file.  If the file record doesn't exist then create
// one for the file.
// --------------------------------------------------------------------------
{
   for (int i = 0; i < 1000; i++)
      if (theArray[ i ]->fileNumber == fileNumber)
         break;
   if (i != 1000)                                // if record exists
   {
      theArray[ i ]->status = status;            // update its status
      return;
   }

   int oldest = 0;
   unsigned long t = 0xffffffffL;

   for (i = 0; i < 1000; i++)
   {
      if (theArray[ i ]->lastTime < t)           // remember the oldest file
      {
         oldest = i;
         t = theArray[ i ]->lastTime;
      }
   }
   StatusRec* rp = theArray[ oldest ];
   rp->fileNumber = fileNumber;
   rp->status = status;
   rp->lastTime = time( 0 );
   rp->blockedFlag = 0;
}

int StatusList::status( const unsigned long fileNumber ) const
// --------------------------------------------------------------------------
//  Get file status
// --------------------------------------------------------------------------
{
   StatusRec* rp;
   for (int i = 0; i < 1000; i++)
   {
      rp = (StatusRec*) theArray[ i ];
      if (rp->fileNumber == fileNumber)
         break;
   }
   if (i != 1000)                                // if record exists
      return rp->status;                       // return status
   else
      return -1;                                 // else indicate no match
}

int StatusList::status( const unsigned long fileNumber,
                        const unsigned char fileType   ) const
// --------------------------------------------------------------------------
//  Get file status.  Use the file type to set the blocked file-type flag.
// --------------------------------------------------------------------------
{
   for (int i = 0; i < 1000; i++)
      if (theArray[ i ]->fileNumber == fileNumber)
      {
         if (cfg.blockedFType( fileType ))
            theArray[ i ]->blockedFlag = 1;
         else
            theArray[ i ]->blockedFlag = 0;
         return theArray[ i ]->status;           // return status
      }
   return -1;                                    // else indicate no match
}

void StatusList::status( const unsigned long  fileNumber,
                               int&           status,
                               int&           blockedFlag ) const
// --------------------------------------------------------------------------
//   Get file status and file-blocked flag
// --------------------------------------------------------------------------
{
   StatusRec* rp;
   for (int i = 0; i < 1000; i++)
   {
      rp = theArray[ i ];
      if (rp->fileNumber == fileNumber)
         break;
   }
   if (i != 1000)                                // if record exists
   {
      status = rp->status;
      blockedFlag = rp->blockedFlag;
   }
   else
      status = -1;
}

void StatusList::unload() const
// --------------------------------------------------------------------------
//  Write file status list to SLIST.DAT
// --------------------------------------------------------------------------
{
   struct
   {
      unsigned long fileNumber;
      unsigned char status;
      char          dummy[3];
      long          lastTime;
   } sRec = { 0, 0, { 0, 0, 0 }, 0 };

   char* fileName = new char[ strlen( cfg.workDir ) + 10 ];
   sprintf( fileName, "%sSLIST.DAT", cfg.workDir );

   FILE* sListFile;
   if (( sListFile = fopen( fileName, "w+b" )) == NULL) // overlay the file
      frWin.printFatal( "Cannot create SLIST.DAT file" );

   for (int i = 0; i < 1000; i++)
   {
      StatusRec* rp = theArray[ i ];
      sRec.fileNumber = rp->fileNumber;
      sRec.status = rp->status;
      sRec.lastTime = rp->lastTime;
      if (fwrite( &sRec, sizeof( sRec ), 1, sListFile) != 1) // write 'em
         frWin.printFatal( "Error writing to SLIST.DAT");
   }
   fclose( sListFile );
   delete fileName;
}


