//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// SLIP (Serial Line IP) encapsulation and control routines.

#ifndef  __SLIP_H
#define  __SLIP_H

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class HwDevice;

class Slip : public L1Protocol
{
public:
         enum        {  FR_END       = 0xC0,     // frame end
                        FR_ESC       = 0xDB,     // frame escape
                        T_FR_END     = 0xDC,     // transposed frame end
                        T_FR_ESC     = 0xDD  };  // transposed frame escape

                        Slip( unsigned  maxNewBufSize,
                              unsigned& logInFrames, unsigned& logOutFrames,
                              unsigned& loggingStatus );
                        ~Slip();

                           // link to lower / higher protocols
         void           link( HwDevice& loPro, L1Protocol& hiPro );

                           // save last incoming SLIP frame to log file
         void           logRecvIn();

                           // receive a filled MBuf to process
         void           recvIn( MBuf& );

                           // give xmtr outgoing MBuf to send
         int            send( MBuf& );

                           // specify directory for SLIP log file
         void           setLogFile( char* directory ) { dir = directory; }

private:
         char*          dir;
         unsigned       frLen;
         L1Protocol*    hiProto;
         char*          inBuf;
         unsigned       inBufSize;
         unsigned*      loggingStatus;
         HwDevice*      loProto;
         unsigned       maxNewBufSize;
         unsigned       maxFrameSize;
         FILE*          slipFileIn;
         FILE*          slipFileOut;

         void           log( const char *, const unsigned );
         MBuf*          encode( const MBuf & ) const;
         MBuf*          decode( char *, const unsigned );

};

#endif __SLIP_H
