//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __CTYPE_H
#include <ctype.h>
#endif

#ifndef  __MEM_H
#include <mem.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __PFHEADER_H
#include "pfheader.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __SSTACK_H
#include "sstack.h"
#endif

#ifndef  __SYNTAX_H
#include "syntax.h"
#endif

#ifndef  __SEMANTIC_H
#include "semantic.h"
#endif

SemanticsAnalyzer::SemanticsAnalyzer( const int stackSize )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   stack = new SStack( stackSize );
   if (!stack)
   {
      puts( "Out of memory" );
      puts( "Press any key to continue..." );
      while (!kbhit());
      getch();
   }
}

SemanticsAnalyzer::~SemanticsAnalyzer()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   delete stack;
}

unsigned SemanticsAnalyzer::resolve( Equation* eqn, PFileHeader* testPfh )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   *this->stack = *eqn->stack;                   // overloaded operator
   pfh = testPfh;
   Symbol* sp = getOprnd();
   if (!sp)
      return 0;
   unsigned rtnVal;
   switch (int( sp->numVal ))
   {
      case 0:
         rtnVal = 0;
         break;
      case 1:
         rtnVal = 1;
         break;
      default:
         rtnVal = 0;
         cprintf( "\r\nUnexpexted value, type = %i\r\n, numVal = %lu",
                 sp->type, sp->numVal );
   }
   return rtnVal;
}

Symbol* SemanticsAnalyzer::getOprnd()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   static Symbol* rtnSym;
   Symbol* sp;
   rtnSym = sp = this->stack->pop();
   if (!rtnSym)
      return 0;
   int rtnVal;
   Symbol *ap, *bp;
   switch (sp->type)
   {
      case LexicalAnalyzer::AND:
      case LexicalAnalyzer::OR:
      case LexicalAnalyzer::LESOP:
      case LexicalAnalyzer::LEQOP:
      case LexicalAnalyzer::EQOP:
      case LexicalAnalyzer::NEQOP:
      case LexicalAnalyzer::GEQOP:
      case LexicalAnalyzer::GTOP:
         bp = getOprnd();                        // recursive call
         ap = getOprnd();                        // recursive call
         switch( ap->type )                      // get pfh values
         {
            case LexicalAnalyzer::AX25_UPLOADER:
               ap->str = pfh->ax25_uploader;
               break;
            case LexicalAnalyzer::BBS_MESSAGE_TYPE:
               ap->numVal = pfh->bbs_message_type;
               break;
            case LexicalAnalyzer::BULLETIN_ID_NUMBER:
               ap->str = pfh->bulletin_id_number;
               break;
            case LexicalAnalyzer::COMPRESSION_DESC:
               ap->str = pfh->compression_description;
               break;
            case LexicalAnalyzer::COMPRESSION_TYPE:
               ap->numVal = pfh->compression_type;
               break;
            case LexicalAnalyzer::CREATE_TIME:
               ap->numVal = pfh->upload_time;
               break;
            case LexicalAnalyzer::DESTINATION:
               ap->str = pfh->destination;
               break;
            case LexicalAnalyzer::DOWNLOAD_COUNT:
               ap->numVal = pfh->download_count;
               break;
            case LexicalAnalyzer::EXPIRE_TIME:
               ap->numVal = pfh->expire_time;
               break;
            case LexicalAnalyzer::FILE_DESCRIPTION:
               ap->str = pfh->file_description;
               break;
            case LexicalAnalyzer::FILE_EXT:
               ap->str = pfh->file_ext;
               break;
            case LexicalAnalyzer::FILE_NAME:
               ap->str =  pfh->file_name;
               break;
            case LexicalAnalyzer::FILE_NUMBER:
               ap->numVal = pfh->file_number;
               break;
            case LexicalAnalyzer::FILE_SIZE:
               ap->numVal = pfh->file_size;
               break;
            case LexicalAnalyzer::FILE_TYPE:
               ap->numVal = pfh->file_type;
               break;
            case LexicalAnalyzer::KEYWORDS:
               ap->str = pfh->keywords;
               break;
            case LexicalAnalyzer::LAST_MODIFIED_TIME:
               ap->numVal = pfh->last_modified_time;
               break;
            case LexicalAnalyzer::PRECEDENCE:
               ap->numVal = pfh->priority;
               break;
            case LexicalAnalyzer::SEU_FLAG:
               ap->numVal = pfh->seu_flag;
               break;
            case LexicalAnalyzer::SOURCE:
               ap->str = pfh->source;
               break;
            case LexicalAnalyzer::TITLE:
               ap->str = pfh->title;
               break;
            case LexicalAnalyzer::UPLOAD_TIME:
               ap->numVal = pfh->upload_time;
               break;
            case LexicalAnalyzer::USER_FILE_NAME:
               ap->str = pfh->user_file_name;
               break;
            case LexicalAnalyzer::STATUS:
               ap->numVal = pfh->status;
               break;
         }
         switch (sp->type)
         {                                       // note: overloaded operators
            case LexicalAnalyzer::AND:
               rtnVal = *ap && *bp;
               break;
            case LexicalAnalyzer::OR:
               rtnVal = *ap || *bp;
               break;
            case LexicalAnalyzer::LESOP:
               rtnVal = *ap <  *bp;
               break;
            case LexicalAnalyzer::LEQOP:
               rtnVal = *ap <= *bp;
               break;
            case LexicalAnalyzer::EQOP:
               rtnVal = *ap == *bp;
               break;
            case LexicalAnalyzer::NEQOP:
               rtnVal = *ap != *bp;
               break;
            case LexicalAnalyzer::GEQOP:
               rtnVal = *ap >= *bp;
               break;
            case LexicalAnalyzer::GTOP:
               rtnVal = *ap  > *bp;
               break;
         }
         rtnSym->set( LexicalAnalyzer::NUMCONSTANT, rtnVal );
         break;
      case LexicalAnalyzer::AX25_UPLOADER:
      case LexicalAnalyzer::BBS_MESSAGE_TYPE:
      case LexicalAnalyzer::BULLETIN_ID_NUMBER:
      case LexicalAnalyzer::COMPRESSION_DESC:
      case LexicalAnalyzer::COMPRESSION_TYPE:
      case LexicalAnalyzer::CREATE_TIME:
      case LexicalAnalyzer::DESTINATION:
      case LexicalAnalyzer::DOWNLOAD_COUNT:
      case LexicalAnalyzer::EXPIRE_TIME:
      case LexicalAnalyzer::FILE_DESCRIPTION:
      case LexicalAnalyzer::FILE_EXT:
      case LexicalAnalyzer::FILE_NAME:
      case LexicalAnalyzer::FILE_NUMBER:
      case LexicalAnalyzer::FILE_SIZE:
      case LexicalAnalyzer::FILE_TYPE:
      case LexicalAnalyzer::KEYWORDS:
      case LexicalAnalyzer::LAST_MODIFIED_TIME:
      case LexicalAnalyzer::PRECEDENCE:
      case LexicalAnalyzer::SEU_FLAG:
      case LexicalAnalyzer::SOURCE:
      case LexicalAnalyzer::TITLE:
      case LexicalAnalyzer::UPLOAD_TIME:
      case LexicalAnalyzer::USER_FILE_NAME:
      case LexicalAnalyzer::STATUS:
      case LexicalAnalyzer::NUMCONSTANT:
      case LexicalAnalyzer::STRCONSTANT:
         break;
      default:
         cprintf( "\r\nUnexpected symbol %i, %lu", sp->type, sp->numVal );
         if ( *sp->strVal)
            cprintf( ", %s\r\n", sp->strVal );
         else
            cprintf( "\r\n" );
   }
   return rtnSym;
}
