//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// --------------------------------------------------------------------------
// Screen writing functions
// --------------------------------------------------------------------------

#ifndef __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

const void far* monoAddr = MK_FP( 0xb000, 0 );
const void far* colorAddr = MK_FP( 0xb800, 0 );
int (far *active_screen)[80];

void initscwr()
// --------------------------------------------------------------------------
// Initialize screen writing functions
// --------------------------------------------------------------------------
{
   active_screen = ( int (far *)[] )video_addr();  // set video adapter addr
}

const void far *video_addr()
// --------------------------------------------------------------------------
// Get video adapter base address
// --------------------------------------------------------------------------
{
   char far *mem;

   mem = ( char far* )MK_FP( 0x0000, 0x0449 );   // check video adapter
   if (mem[0] == 7)
       return monoAddr;                          // monochrome
   else
       return colorAddr;                         // color
}

int attr( int fg, int bg )
// --------------------------------------------------------------------------
// Calculates attribute byte
// --------------------------------------------------------------------------
{
   return (bg << 4) + fg;
}

void attrib( int x1, int y1, int x2, int y2, int fg, int bg )
// --------------------------------------------------------------------------
// Set screen attributes
// --------------------------------------------------------------------------
{
   int a = attr( fg, bg ) << 8;
   int col;
   for (int row = y1 - 1; row <= y2 - 1; row++)
      for (col = x1 - 1; col <= x2 - 1; col++)
         active_screen[ row ][ col ] =
                                   a | (active_screen[ row ][ col ] & 0x00ff);
}

void writeat( int  x, int  y, int fg, int bg, char * c )
// --------------------------------------------------------------------------
// Write a string on screen with specified attributes
// --------------------------------------------------------------------------
{
   int a = attr( fg, bg ) << 8;
   int i = 0;
   int len = strlen( c );
   for (int col = x - 1; i < len; col++)
   {
      active_screen[ y-1 ][ col ] = a | c[ i ];
      i++;
   }
}

void writeatnc( int x, int y, char * c )
// --------------------------------------------------------------------------
// Write a string on screen with no change in attributes
// --------------------------------------------------------------------------
{
   unsigned char i, col, len;

   i = 0;
   len = strlen( c );
   for (col = x - 1; i < len; col++)
   {
      active_screen[ y-1 ][ col ] =
                                (active_screen[ y-1 ][ col ] & 0xFF00) | c[i];
      i++;
   }
}

void horizline( int x1, int x2, int y, int fg, int bg, int typ )
// --------------------------------------------------------------------------
// Draw horizontal line on screen
// --------------------------------------------------------------------------
{
   int a = attr( fg, bg ) << 8;
   int linechar;
   switch (typ)
   {
      case 0:                          linechar = ' ';  break;
      case 1: case 3: case 6: case 8:  linechar = 0xC4; break;
      case 2: case 4: case 7: case 9:  linechar = 0xCD; break;
      default:                         linechar = typ;
   }
   for (int col = x1 - 1; col <= x2 - 1; col++)
      active_screen[ y-1 ][ col ] = a | linechar;
}

void horizline( int x1, int x2, int y, char ch )
// --------------------------------------------------------------------------
// Draw horizontal line on screen using the character provided without
// changing the screen attributes.
// --------------------------------------------------------------------------
{
   x1--;
   x2--;
//   y--;
   for (int col = x1; col <= x2; col++)
      active_screen[ y-1 ][ col ] = (active_screen[ y ][ col ] & 0xFF00) | ch;
}

void vertline( int  x, int y1, int y2, int fg, int bg, int typ )
// --------------------------------------------------------------------------
// Draw vertical line on screen
// --------------------------------------------------------------------------
{
   int a = attr( fg, bg ) << 8;
   int linechar;
   switch (typ)
   {
      case 0:                          linechar = ' ';  break;
      case 1: case 3: case 6: case 8:  linechar = 0xC4; break;
      case 2: case 4: case 7: case 9:  linechar = 0xCD; break;
      default:                         linechar = typ;
   }
   for (int row = y1 - 1; row <= y2 - 1; row++)
      active_screen[ row ][ x-1 ] = a | linechar;
}

void vertline( int x, int y1, int y2, char ch )
// --------------------------------------------------------------------------
// Draw vertical line on screen using the character provided without
// changing the screen attributes.
// --------------------------------------------------------------------------
{
   x--;
   y1--;
   y2--;
   for (int row = y1; row <= y2; row++)
      active_screen[ row ][ x ] = (active_screen[ row ][ x ] & 0xFF00) | ch;
}

void box( int x1, int y1, int x2, int y2, int  f, int  b, int boxtype )
// --------------------------------------------------------------------------
// Draw box on screen
// --------------------------------------------------------------------------
{
    char * corner1 = " \x0", * corner2 = " \x0", * corner3 = " \x0",
         * corner4 = " \x0", h_line, v_line;

   switch (boxtype)
   {
      case 0:
         corner1 = " \x0";
         corner2 = " \x0";
         corner3 = " \x0";
         corner4 = " \x0";
         h_line  = ' ';
         v_line  = ' ';
         break;
      case 1:
         corner1 = "\x0";
         corner2 = "\x0";
         corner3 = "\x0";
         corner4 = "\x0";
         h_line  = '';
         v_line  = '';
         break;
      case 2:
         corner1 = "\x0";
         corner2 = "\x0";
         corner3 = "\x0";
         corner4 = "\x0";
         h_line  = '';
         v_line  = '';
         break;
      case 3:
         corner1 = "\x0";
         corner2 = "\x0";
         corner3 = "\x0";
         corner4 = "\x0";
         h_line  = '';
         v_line  = '';
         break;
      case 4:
         corner1 = "\x0";
         corner2 = "\x0";
         corner3 = "\x0";
         corner4 = "\x0";
         h_line  = '';
         v_line  = '';
         break;
      default:
         corner1[0] = (char) boxtype;
         corner2[0] = (char) boxtype;
         corner3[0] = (char) boxtype;
         corner4[0] = (char) boxtype;
         h_line     = (char) boxtype;
         v_line     = (char) boxtype;
   }
    writeat( x1, y1, f, b, corner1 );
    horizline( x1+1, x2-1, y1, f, b, h_line );
    writeat( x2, y1, f, b, corner2 );
    vertline( x1, y1+1, y2-1, f, b, v_line );
    vertline( x2, y1+1, y2-1, f, b, v_line );
    writeat( x1, y2, f, b, corner3 );
    horizline( x1+1, x2-1, y2, f, b, h_line );
    writeat( x2, y2, f, b, corner4 );
}

void clearline( int y, int f, int b )
// --------------------------------------------------------------------------
// Clears a line on screen with attributes
// --------------------------------------------------------------------------
{
   horizline( 1, 80, y, f, b, ' ' );
}

void clearbox( int x1, int y1, int x2, int y2, int  f, int  b )
// --------------------------------------------------------------------------
// Clears a box on screen with attributes
// --------------------------------------------------------------------------
{
   if (x2 > 80)
      x2 = 80;
   for (int row = y1; row <= y2; row++)
      horizline( x1, x2, row, f, b, ' ' );
}

void boxf( int x1, int y1, int x2, int y2, int  f, int  b, int boxtype )
// --------------------------------------------------------------------------
// Draws box on screen with attributes and clears it
// --------------------------------------------------------------------------
{
   box( x1, y1, x2, y2, f, b, boxtype );
   clearbox( x1+1, y1+1, x2-1, y2-1, f, b );
}

