//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// Compiler options:  word alignment OFF
//                    unsigned characters ON

#ifndef  __SATLINK_H
#include "satlink.h"
#endif

#ifndef  __ALLOC_H
#include <alloc.h>
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __FCNTL_H
#include <fcntl.h>
#endif

#ifndef  __IO_H
#include <io.h>
#endif

#ifndef  __STAT_H
#include <sys//stat.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include "stdlib.h"
#endif

#ifndef  __STRING_H
#include "string.h"
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __DIRBCST_H
#include "dirbcst.h"
#endif

#ifndef  __FILEBCST_H
#include "filebcst.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __GETUE_H
#include "getue.h"
#endif

#ifndef  __HDLNOl3_H
#include "hdlnol3.h"
#endif

#ifndef  __HWDEVICE_H
#include "hwdevice.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __SLIP_H
#include "slip.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __TNCMGR_H
#include "tncmgr.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

SatLink* satLink;

void main( int argc, char **argv )
// -------------------------------------------------------------------------
// Program root
// -------------------------------------------------------------------------
{
   satLink = new SatLink();
   satLink->run( argc, argv );
   delete satLink;
}

unsigned SatLink::pgmExitFlag = 0;

SatLink::SatLink() : actList( 0 ),               // activity files list
                     ai( 0 ),                    // async interface
                     axpr( Ax25::ZERO ),
                     ddm( 0 ),                   // directory download manager
                     dev( 0 ),                   // hardware device pointer
                     dfm( 0 ),                   // directory file manager
                     dir( 0 ),                   // PFH directory viewer
                     firstHeard( 0 ),
                     kiss( 0 ),                  // KISS protocol object ptr
                     linkTable( LinkTable( 4 ) ),
                     logCs( 0 ),                 // log SLIP frame for callsign
                     parser( 0 ),                // select equation parser
                     sem( 0 ),                   // eqn semantics analyzer
                     slip( 0 ),                  // SLIP protocol object ptr
                     sList( 0 ),                 // download file status list
                     terminal( 0 ),              // terminal mode protocol
                     tncMgr( 0 )                 // TNC manager
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

SatLink::~SatLink()
// -------------------------------------------------------------------------
//  Destructor
// -------------------------------------------------------------------------
{}

void SatLink::exitProgram( const int exitCode )
// -------------------------------------------------------------------------
// program exit function
// -------------------------------------------------------------------------
{
   if (!ftl0User->bbsAxp)                        // if no object
   {                                             // then not connected
      pgmExitFlag = 1;                           // raise the flag
      cfg.exitCode = exitCode;
      cfg.putExitInfo();
      return;
   }
   switch (ftl0User->bbsAxp->state())            // else check connect state
   {
      case LAPB::DISCPENDING :
      case LAPB::DISCONNECTED :
      case LAPB::LISTEN :
         pgmExitFlag = 1;
         cfg.exitCode = exitCode;
         cfg.putExitInfo();
         break;
      default:
         if (exitCode == EXITONSATERROR)
            break;                               // ignore if connected
         ftl0User->handleEvent( Event::Request_Disconnect, NULBUF ); // disconnect
         exitAfterTimer->start( 15000 );         // give it 15 seconds more
   }
}

void SatLink::print() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   window( 1, 1, 80, 25 );                       // clean up screen
   textbackground( cfg.dataWinBg );
   textcolor( cfg.dataWinFg );
   clrscr();
   long timeNow = time( 0 );
   printf( "\n%s", ctime( &timeNow ) );
   printf( "Raw SLIP bytes in:                 %10lu\n",
           slip->recvBytesIn );
   printf( "Raw SLIP errors:                   %10u\n",
           unsigned(slip->sendErrCnt + slip->recvErrCnt));
   printf( "Raw SLIP frames in:                %10u\n",
           slip->recvFramesOut);
   printf( "Raw SLIP bytes out:                %10lu\n",
           slip->sendBytesOut );
   printf( "Raw SLIP frames out:               %10u\n\n",
           slip->sendFramesOut );
   printf( "Broadcast file frame bytes:        %10lu\n", fbm->recvBytesIn );
   printf( "Broadcast directory frame bytes:   %10lu\n\n", dbm->recvBytesIn);
   printf( "AX.25 frame errors:                %10u\n", axpr->recvErrCnt );
   printf( "Broadcast file frame errors:       %10u\n", fbm->recvErrCnt );
   printf( "Broadcast dir frame errors:        %10u\n\n", dbm->recvErrCnt);

   if (firstHeard)
   {
      char *logFileName = new char[ MAXPATH ];
      sprintf( logFileName, "%sBCST.LOG", cfg.workDir );
      FILE *logFile;
      if ((logFile = fopen( logFileName, "at" )) == 0)
      {
         sprintf( frameWin->buf, "Error opening logfile: %s", logFileName );
         frameWin->printFatal( frameWin->buf );  // say we had a problem
      }
      struct date dtStart;
      struct time tmStart;
      unixtodos( firstHeard, &dtStart, &tmStart );
      struct date dtNow;
      struct time tmNow;
      unixtodos( timeNow, &dtNow, &tmNow );
      char *bp = new char[ 80 ];
      unsigned long grossRate;
      if (exitAfterTimer->getState() == Timer::Expired)
         grossRate = slip->recvBytesIn / (timeNow - firstHeard - cfg.exitAfterMs / 1000);
      else                                       // else we forced an exit
         grossRate = slip->recvBytesIn / (timeNow - firstHeard);
      sprintf( bp, "%02i/%02i/%02i %02i:%02i:%02i - %02i:%02i:%02i : Max=%04lu Bps Gross=%04lu Bps Total Bytes=%08lu\n",
               dtStart.da_year - 1900, (int)dtStart.da_mon,
               (int)dtStart.da_day,
               (int)tmStart.ti_hour, (int)tmStart.ti_min,
               (int)tmStart.ti_sec,
               (int)tmNow.ti_hour, (int)tmNow.ti_min, (int)tmNow.ti_sec,
               sLine->highRate,
               grossRate,
               slip->recvBytesIn );
      fputs( bp, logFile );
      fclose( logFile );
   }
}

void SatLink::run( int argc, char **argv )
// -------------------------------------------------------------------------
//  Main program loop
// -------------------------------------------------------------------------
{
   if (argc < 2)
   {
      printf( "Parameter list missing\n" );
      return;
   }
   cfg.read( argv );                             // read configuration file

   // Read the exit information file if it exists.  This file is used to
   // interface with scheduling programs such as SatSked by Wayne Roth, WA2N.

   cfg.getExitInfo();

   // Create and start timer for timed exit.

   ExitPgmCallUp exitAfterCallUp( *this, EXITAFTERTIMER );
   exitAfterTimer = new Timer( "ExitAfter", exitAfterCallUp, cfg.exitAfterMs );

   initialize();                                 // initialize functions
   exitAfterTimer->start();

   // Create and start timer to abort program after the specified
   // interval.  Timers won't start if the interval is zero.

   ExitPgmCallUp abortCallUp( *this, ABORTTIMER );
   Timer* abortTimer = new Timer( "AbortAfter", abortCallUp, cfg.abortInterval );
   abortTimer->start();

   // This program is implemented with a service loop to poll hardware
   // related input functions: keyboard, timer, and communication.  These
   // functions could provide asynchronous control if redesigned as interrupt
   // service but the current implementation is easier to debug.

   // The comm interface receive functions are interrupt driven and load an
   // input buffer.  The file interface receive function simulates this by
   // reading a file and loading a buffer.  We poll a device to take data
   // from the buffer for processing.

   // The programExitFlag is set in exitProgram().  This function may be
   // call in various places such as timer "CallUp" functions.

   DlRateCallUp dlRateCallUp( *this );
   int heardPkt = 0;
   do
   {
      if (!heardPkt && axpr->recvFramesIn)       // once we receive a packet
      {
         heardPkt = 1;
         firstHeard = time( 0 );                 // remember when it occured
                                                 // calc downlink rate
         dlRateTimer = new Timer( "dlRate", dlRateCallUp, 5000 );
         dlRateTimer->start();
      }

      Timer::cycle();                            // cycle the timers
      if (cfg.simulate && cfg.simulationDelay)   // if we need to slow things
         delay( cfg.simulationDelay );           //  down
      dev->poll();                               // poll input device
      userMgr->kbRecv();                         // poll keyboard receiver
   } while (!pgmExitFlag);                       // do it for a while
   terminate();                                  // terminate functions
}

void SatLink::showDlRate()
//--------------------------------------------------------------------------
// Show the download rate information.  This is an expired timer function.
// Can't use an object class function for the timer call.
//--------------------------------------------------------------------------
{
   sLine->showDlRate( cfg, slip, *dlRateTimer, *exitAfterTimer, antennaControl );
   if (cfg.showMemory)
   {
      sprintf( infoWin->buf, "Free memory : %lu", farcoreleft() );
      infoWin->print( infoWin->buf );
   }
}

DlRateCallUp::DlRateCallUp( Object& obj ) : CallUp( obj )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void DlRateCallUp::func() const
// -------------------------------------------------------------------------
// Download rate timer call up function
// -------------------------------------------------------------------------
{
   ((SatLink&) obj).showDlRate();
}

ExitPgmCallUp::ExitPgmCallUp( Object& obj, int exitCode )
                            :
                              CallUp( obj ), exitCode( exitCode )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void ExitPgmCallUp::func() const
// -------------------------------------------------------------------------
// program exit function
// -------------------------------------------------------------------------
{
   ((SatLink&) obj).exitProgram( exitCode );
}

// End of SATLINK.CPP