//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// OrbitDRV-interface object class provided by Wayne Roth, WA2N

#ifndef  __ROTOR_H
#define  __ROTOR_H

#ifndef  __DOS.H
#include <dos.h>
#endif


class Rotor
{
public:
   int           orbitDrvPresent;
   int           rotorDrvPresent;

                 Rotor();
                 ~Rotor() {};
   void          setOrbitDrvTime( long dosTime );
   void          initialize( int orbitDriveSoftwareInterrupt );

private:
   long          correctedTimezone;
   double        currentJulianDate;
   double        julianCorrectedTimezone;
   int           orbitDrvInterrupt;

   double        cdateToJdate( struct date* dt, struct time* tm );
   unsigned long dayNum( int year, int month, int day );
   void          fixTimezone();
   void          rotorTsrDetect();
};

#endif   __ROTOR_H
