//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// OrbitDRV-interface object class provided by Wayne Roth, WA2N

#ifndef  __ROTOR_H
#include "rotor.h"
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

Rotor::Rotor()
     :
     julianCorrectedTimezone( 0 ),
     currentJulianDate( 0 ),
     correctedTimezone( 0 ),
     orbitDrvInterrupt( 0 ),
     rotorDrvPresent( 0 ),
     orbitDrvPresent( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{}

double Rotor::cdateToJdate( struct date* dt, struct time* tm )
// --------------------------------------------------------------------------
//  Convert DOS date and time to Julian using base of 1900 AD
//	 add in offset to get us to utc time.
// --------------------------------------------------------------------------
{
   double ut = ( (double)tm->ti_hour + (double)tm->ti_min/60 +
               (double)tm->ti_sec/3600 ) / 24;
   return (dayNum( dt->da_year, dt->da_mon, dt->da_day) + ut +
          julianCorrectedTimezone );
}

unsigned long Rotor::dayNum( int year, int month, int day )
// --------------------------------------------------------------------------
//  Number of days elapsed from Jan 1, 1900 to a given date
// --------------------------------------------------------------------------
{
   int days[] = {0,31,59,90,120,151,181,212,243,273,304,334};

   unsigned long y, d;

   if (year < 50)
      y = year + 2000;
   else
      if (year < 100)
         y = year + 1900;
      else
         y = year;
   d = (((y-1901)*1461) >> 2) + days[month-1] + day + 365;
   if (year % 4 == 0 && month > 2)
      d++;
   return d;
}

void Rotor::fixTimezone()
// --------------------------------------------------------------------------
//  Compensate for daylight savings time, if in effect.
// --------------------------------------------------------------------------
{
   time_t t = time( 0 );
   struct tm* area = localtime( &t );
   if (area->tm_isdst)
      correctedTimezone = timezone - 60 * 60;
   else
   correctedTimezone = timezone;
   julianCorrectedTimezone = correctedTimezone / ( 3600.0 * 24.0 );
}

void Rotor::initialize( int orbitDriveSoftwareInterrupt )
// --------------------------------------------------------------------------
//  Find out the local offset to GMT, be sure orbitDrv is installed,
//  set the dos interrupt.
// --------------------------------------------------------------------------
{
   orbitDrvInterrupt = orbitDriveSoftwareInterrupt;
   fixTimezone();
   rotorTsrDetect();
}

void Rotor::rotorTsrDetect()
// --------------------------------------------------------------------------
//  Check to see if the rotorDRV and orbitDRV TSRs are installed.
// --------------------------------------------------------------------------
{
   if (!orbitDrvInterrupt)
      return;
   char far* ptr = (char far*) getvect( orbitDrvInterrupt ) + 10;
   char idString[ 32 ];
   for (int i = 0; i < 32; i++)
      idString[ i ] = ptr[ i ];
   if (strncmp( idString, "RotorDRV", 8 ) == 0)
      rotorDrvPresent = 1;
   if(strncmp( idString + 8, "+OrbitDRV" ,8 ) == 0)
      orbitDrvPresent = 1;
}

void Rotor::setOrbitDrvTime( long dosTime )
// --------------------------------------------------------------------------
//  Set OrbitDRV to the current DOS time
// --------------------------------------------------------------------------
{
   struct REGPACK reg;
   struct date    dat;
   struct time    tm;

   if(!orbitDrvPresent)
      return;
   unixtodos( dosTime, &dat, &tm );              // convert to DOS time for printing
   getdate( &dat );
   gettime( &tm );
   currentJulianDate = cdateToJdate( &dat, &tm ) + 15019.0; // get Julian time
   reg.r_ds = FP_SEG( &currentJulianDate );
   reg.r_dx = FP_OFF( &currentJulianDate );
   reg.r_ax = 0xfa << 8;
   intr( orbitDrvInterrupt, &reg );
}
