//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

char* Event::eventStr[ 59 ] = { "No_Event",

                                "Rqst_Term_Mode",
                                "Rqst_Host_Mode",
                                "Rqst_Kiss_Mode",
                                "Host_Command",
                                "Terminal_Command",
                                "Rqst_Help",
                                "Rqst_Printer_Toggle",
                                "Rqst_Microsat_Chng",
                                "Rqst_DOS_Gateway",
                                "Rqst_Send_Break",
                                "Rqst_DCD_Toggle",
                                "Rqst_Dir_Rebuild",
                                "Rqst_Program_Exit",
                                "Rqst_Capture",
                                "Rqst_Toggle_Grab",
                                "Exit_Program",

                                "Rcv_Datalink_Frame",
                                "Rqst_Term_Data_Link",
                                "Request_Connect",
                                "Request_Passive",
                                "Request_Disconnect",
                                "Rcv_Stn_Busy_Resp",
                                "Rcv_Con_Ack_Resp",
                                "Data_Link_Established",
                                "Data_Link_Terminated",

                                "Rcv_AX25_Proto",
                                "Rcv_File_Proto",
                                "Rcv_Dir_Proto",
                                "RcvFTL0Proto",
                                "Rcv_No_L3_Proto",

                                "Connect_Delayed_Timeout",
                                "Rcv_Sat_Full_Frame",
                                "Rcv_Sat_Open_Frame",
                                "Rcv_LOGIN_RESP",

                                "User_Requests_Upload",
                                "File_Queued",
                                "Rcv_UL_GO_RESP",
                                "Rcv_UL_ERROR_RESP",
                                "Rcv_UL_ACK_RESP",
                                "Rcv_UL_NAK_RESP",

                                "User_Requests_Abort",

                                "User_Requests_Download",
                                "User_Requests_Directory",
                                "User_Requests_Selection",
                                "Rcv_DL_ABORTED_RESP",
                                "Rcv_DL_COMPLETED_RESP",
                                "Rcv_SELECT_RESP",
                                "Rcv_DATA",
                                "Rcv_DATA_END",
                                "Rcv_DL_ERROR_RESP",

                                "User_Requests_Fill_Dir",
                                "User_Requests_Begin_File",
                                "User_Requests_Fill_File",
                                "User_Requests_Stop_File",
                                "RcvBcstQueueFrame",

                                "Last_Heard_Timeout",
                                "AckTimerExpired",
                                "IdleTimerExpired" };

void Event::display( unsigned i, Window& win, Config& cfg )
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
{
   sprintf( win.buf, "Event = %s", Event::eventStr[ i ] );
   win.printColor( cfg.highlight3Fg, cfg.highlight3Bg, win.buf );
}

EventQueue::EventQueue( Config& cfg, Window& win )
                      :
                        cfg( cfg ), win( win ), count( 0 ),
                        qsize( QUEUE_SIZE )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void EventQueue::add( unsigned i, void* m )
// -------------------------------------------------------------------------
//  Add an event to the queue
// -------------------------------------------------------------------------
{
   if (cfg.debug)
   {
      win.printColor( cfg.highlight3Fg, cfg.highlight3Bg,
                           "Adding to EventQueue" );
      Event::display( i, win, cfg );
   }
   if (count == qsize)
   {
      sprintf( win.buf, "EventQueue overflowed at %i", count );
      win.printFatal( win.buf );
   }
   count++;
   list[ count-1 ].i = i;
   list[ count-1 ].m = m;
}

int EventQueue::empty()
// -------------------------------------------------------------------------
//  Determine if the queue is empty
// -------------------------------------------------------------------------
{
   if (count == 0)
      return 1;
   else
      return 0;
}

int EventQueue::next( unsigned* i, void** m )
// -------------------------------------------------------------------------
//  Retrieve and remove next event from the queue
//  Returns "FALSE" if queue is empty; otherwise "TRUE."
// -------------------------------------------------------------------------
{
	if (count == 0)
   {
      *i = Event::No_Event;
      *m = 0;
   }
   else
   {
      *i = list[0].i;
      *m = list[0].m;
      count--;
   	memmove( &list[0], &list[1], count*sizeof( Event ) );
   }
   if (cfg.debug)
   {
      win.printColor( cfg.highlight3Fg, cfg.highlight3Bg,
                      "Removing event from EventQueue" );
      Event::display( *i, win, cfg );
   }
   if (*i == Event::No_Event)
      return 0;
   else
      return 1;
}

void EventQueue::flush()
// -------------------------------------------------------------------------
//  Empty contents of the queue
// -------------------------------------------------------------------------
{
   if (cfg.debug)
      win.printColor( cfg.highlight3Fg, cfg.highlight3Bg,
                      "Flushing EventQueue" );
   int i;

   for (i = 0; i <  count && list[i].m != 0; i++)
      delete list[ i ].m;
   count = 0;
}


