//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __PFHEADER_H
#define  __PFHEADER_H

class Window;

class PFileHeader
{
public:
           enum             { ALL_MAIL,
                              MY_MAIL,
                              BULLETINS,
                              LOGS,
                              DONE,
                              REQUESTED,
                              KEPS,
                              IMAGES,
                              NEWS,
                              PB_PG,
                              ALL_FILES,
                              BBS,
                              URGENT };

   static   PFileHeader*      ZERO;
   static   char              statusChar[ 19 ];
                                                 // PACSAT header ID

   unsigned long file_number;                    // 0x01
   char          file_name[ 9 ];                 // 0x02
   char          file_ext[ 4 ];                  // 0x03 *
   unsigned long file_size;                      // 0x04
   unsigned long last_modified_time;             // 0x06 *
   unsigned char seu_flag;                       // 0x07 *
   unsigned char file_type;                      // 0x08
   unsigned long header_checksum;                // 0x0a
   char*         source;                         // 0x10
   char          ax25_uploader[ 7 ];             // 0x11
   unsigned long upload_time;                    // 0x12
   unsigned char download_count;                 // 0x13 *
   char*         destination;                    // 0x14
   unsigned long expire_time;                    // 0x17
   unsigned char priority;                       // 0x18
   unsigned char compression_type;               // 0x19
   unsigned char bbs_message_type;               // 0x20 *
   char*         bulletin_id_number;             // 0x21
   char*         title;                          // 0x22
   char*         keywords;                       // 0x23
   char*         file_description;               // 0x24 *
   char*         compression_description;        // 0x25
   char*         user_file_name;                 // 0x26
   unsigned long csum;                           // calculated checksum

   char          displayThis;
   unsigned      pFileHeaderSize;
   char          status;

                           PFileHeader( Window& iWin );
                           PFileHeader( const PFileHeader& p );
   virtual                 ~PFileHeader();
             unsigned      get( char* data, int cnt );
             void          display();
	     void 	   display( const unsigned position );
             int           displayable() { return displayThis; }
             void          displayOnScreen() const;
             int           displayOnScreen( const int );
   inline    int           operator ==( const PFileHeader& ) const;
   inline    int           operator !=( const PFileHeader& ) const;
   inline    int           operator <( const PFileHeader& ) const;
   inline    int           operator >( const PFileHeader& ) const;

private:
             char*         prtStr() const;
             Window&       iWin;
};

#define NOPFILEHEADER *(PFileHeader::ZERO)

#endif   __PFHEADER_H
