//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __PC_H
#include "pc.h"
#endif

// This flag is set by setirq() if IRQ 8-15 is used, indicating
// that the machine is a PC/AT with a second 8259 interrupt controller.
// If this flag is set, the interrupt return code will send an End of
// Interrupt command to the second 8259 as well as the first.

int isAT;

void clrBit( unsigned port, char bits )
// --------------------------------------------------------------------------
//  Clear bit(s) in I/O port
// --------------------------------------------------------------------------
{
   outportb( port, char( inportb( port ) & ~bits ) );
}

CastISR getIRQ( unsigned irq )
// --------------------------------------------------------------------------
//  Return pointer to hardware interrupt handler.
//  Takes IRQ numbers from 0-7 (0-15 on AT) and maps to actual 80?86 vectors
// --------------------------------------------------------------------------
{
   if (irq < 8)                                  // set interrupt vector
      return getvect( 8+irq );
   else
      if (irq < 16)
         return getvect( 0x70 + irq - 8 );
      else
         return 0;
}

int getMask( unsigned irq )
// --------------------------------------------------------------------------
// Return 1 if specified interrupt is enabled, 0 if not, -1 if invalid
// --------------------------------------------------------------------------
{
   if( irq < 8 )
      return (inportb( 0x21 ) & (1 << irq)) ? 0 : 1;
   else
   if (irq < 16)
   {
      irq -= 8;
		return (inportb( 0xa1 ) & (1 << irq)) ? 0 : 1;
   }
   else
      return -1;
}

int maskOff( unsigned irq )
// --------------------------------------------------------------------------
//  Disable hardware interrupt
// --------------------------------------------------------------------------
{
   if (irq < 8)
   {
      setBit( 0x21, char( 1 << irq ) );
   }
   else
      if (irq < 16)
      {
         irq -= 8;
         setBit( 0xa1, char( 1 << irq ) );
      }
      else
         {
            return -1;
         }
   return 0;
}

int maskOn( unsigned irq )
// --------------------------------------------------------------------------
//  Enable hardware interrupt
// --------------------------------------------------------------------------
{
   if( irq < 8)
   {
      clrBit( 0x21, char( 1 << irq ) );
   }
   else
      if (irq < 16)
      {
         irq -= 8;
         clrBit( 0xa1, char( 1 << irq) );
      }
      else
         return -1;
   return 0;
}

void setBit( unsigned port, char bits )
// --------------------------------------------------------------------------
//  Set bit(s) in I/O port
// --------------------------------------------------------------------------
{
   outportb( port, char( inportb( port ) | bits ) );
}

int setIRQ( unsigned irq, CastISR& handler )
// --------------------------------------------------------------------------
//  Install hardware interrupt handler.
//  Takes IRQ numbers from 0-7 (0-15 on AT) and maps to actual 80?86 vectors.
//  Note that bus line IRQ2 maps to IRQ9 on the AT.
// --------------------------------------------------------------------------
{
   if (irq < 8)                                  // Set interrupt vector
      setvect( 8+irq, handler );
   else
      if (irq < 16)
      {
         ::isAT = 1;
         setvect( 0x70 + irq - 8, handler );
      }
      else
         return -1;
	return 0;
}

void writeBit( unsigned port, char mask, int val )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   char x = inportb( port );
   if (val)
      x |= mask;
   else
      x &= ~mask;
   outportb( port, x );
}

void eoi()
// --------------------------------------------------------------------------
// Re-arm 8259 interrupt controller(s)
// Should be called just after taking an interrupt, instead of just
// before returning. This is because the 8259 inputs are edge triggered, and
// new interrupts arriving during an interrupt service routine might be
// missed.
// --------------------------------------------------------------------------
{
   if (isAT)
   {
      outportb( 0xa0, 0x0b );                    // read in-service
//      char c = inportb( 0xa0 );                  // secondary 8259
//      if (c & 0x0f)                              // if a secondary interrupt
//         outportb( 0xa0, 0x20 );                 // send EOI instruction
   }
   disable();
   outportb( 0x20, 0x20 );                       // primary 8259 EOI instruction
}
