//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __MSGLINE_H
#define  __MSGLINE_H

class MsgLine
{
public:
                         MsgLine ( const int line,
                                   const int bg, const int fg );
  virtual                ~MsgLine();
          void           print( const char* c ) const;
          void           printOff( const int offset, const char* c ) const;
          void           printRev( const char* c ) const;

protected:
          int            bg;
          int            fg;
          int            left;
          int            line;
          int            right;
          char*          msgBuf;
private:
   static int           initFlag;
};

class Config;
class L1Protocol;
class Rotor;
class Timer;

class StatusLine : MsgLine
{
public:
          unsigned long  highRate;

                         StatusLine( const int bg, const int fg );
          void           autoStatus( const char* s ) const;
          void           currentMode( const int tncMode ) const;
          void           dirStatus( const int count ) const;
          void           dirTotal( const unsigned long total ) const;
          void           errorTotal( const unsigned long count ) const;
          void           fileTotal( const unsigned long count ) const;
          void           linkStatus( const char* s ) const;
          void           showDlRate( Config&     cfg,
                                     L1Protocol* protocol,
                                     Timer&      dlRateTimer,
                                     Timer&      exitAfterTimer,
                                     Rotor&      antennaControl );
private:
};

class CmdLine : public MsgLine
{
public:
                         CmdLine( const int bg, const int fg );
          void           dirSelect() const;
          void           init() const;
          void           msg( const char* cp1, const unsigned long fileNumber,
                              const char* cp2 ) const;
private:
};

#endif   __MSGLINE_H

