//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __MSGBUF_H
#define  __MSGBUF_H

class Window;

class MBuf
{
public:
   //  prtMBufErr - Pointer to an alternate, user supplied, output function.
   //               Initialized to null, so default is to send error messages
   //               to stdout.

   static Window*    win;
          unsigned   size;                          // size of data buffer
          unsigned   cnt;                           // count of data in buffer
          char*      data;                          // working pointer to data
   static MBuf*      ZERO;                          // null buffer

   inline            MBuf();
   inline            MBuf( const unsigned );
   inline            MBuf( const char* newData, const unsigned newCnt );
                     MBuf( const MBuf& );
                     MBuf( const MBuf&, const unsigned, const unsigned );
   virtual           ~MBuf();
          void       append( MBuf & );
          int        pullChar();
          int        pullUp( char *, const unsigned );
          void       pushDown( const unsigned );
          void       reAlloc( const unsigned );

          MBuf&      operator =( const MBuf & );

private:
          char*      dupDataPtr;                    // pointer to data space
   static char*      errMsgMBuf1;
   static char*      errMsgMBuf2;
};

// Description -------------------------------------------------------------
//
//      Defines a message buffer class.
//
// Public Members
//
//     size - size in bytes of the allocated data space
//     cnt  - count in bytes of the data in the buffer
//     data - pointer to the first byte of data in the buffer
//
//     MBuf() 
//
//        Constructor for an empty MBuf.
//
//     MBuf( const unsigned )
//
//        Constructor for an MBuf of the specified size.
//
//     MBuf( const MBuf& )
//
//        Copy constructor; duplicates an MBuf.
//
//     MBuf( const MBuf&, const unsigned skipCnt, const unsigned copyCnt)
//
//        Copy constructor for a subset of the source data.  Skip past the
//        specified number of bytes of data and copy the specified amount.
//        Limit the size of the data space to the amount of data copied.
//
//     ~MBuf()
//
//        Destructor.
//
//     append( const MBuf& )
//
//        Append the data in the source MBuf to the data in this buffer 
//        and delete the source MBuf.
//
//     pullChar()
//
//        Pull single character from MBuf.  Return -1 if no data.
//
//     pullUp( char * buffer, const unsigned )
//
//        Copy bytes from the beginning of the data storage to the specified 
//        buffer and delete the bytes from the data storage.  Return the 
//        number of bytes actually pulled off.
//
//     pushDown( const unsigned )
//
//        Insert specified amount of bytes of room in front of the existing 
//        data.  This operation is the logical inverse of pullUp(), hence the 
//        name.
//
//     reAlloc( const unsigned )
//
//        Reallocate a message buffer to a different size.
//
//     operator =( const MBuf& )
//
//        Assignment operator for MBufs.
//
// Private Members
//
//     dupDataPtr - A pointer to the start of the allocated data space.  The
//                  data pointer may be offset from the first byte so the
//                  duplicate pointer is retained for use by the destructor.
//
// End ---------------------------------------------------------------------


#define NULBUF *(MBuf::ZERO)

#endif __MSGBUF_H
