//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include "stdlib.h"
#endif

#ifndef  __STRING_H
#include "string.h"
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

Log::Log( Config& cfg, Window& win ) : cfg( cfg ), win( win )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{}

void Log::write( const char* msg ) const
// --------------------------------------------------------------------------
// Put a message in the CONNECT.LOG file.
// --------------------------------------------------------------------------
{
   FILE* logFile;
   char* logFileName = new char[ strlen( cfg.workDir ) + 13 ];
   sprintf( logFileName, "%sCONNECT.LOG", cfg.workDir );
   if ((logFile = fopen( logFileName, "at" )) == 0)
   {
      sprintf( win.buf, "Error opening %s, %s", logFileName, sys_errlist[ errno ] );
      win.printFatal( win.buf );                // say we had a problem
      delete logFileName;
      return;
   }
   delete logFileName;
   long timeNow = time( 0 );
   struct date dtNow;
   struct time tmNow;
   unixtodos( timeNow, &dtNow, &tmNow );
   char* bp = new char[ 80 ];
   sprintf( bp, "%02i/%02i/%02i %02i:%02i:%02i  - %s\n",
            dtNow.da_year - 1900, (int)dtNow.da_mon, (int)dtNow.da_day,
            (int)tmNow.ti_hour, (int)tmNow.ti_min, (int)tmNow.ti_sec,
            msg );
   fputs( bp, logFile );
   delete bp;

   // We need to limit the number of open files and ensure that we see the
   // log, even if the computer hangs up, so we close the file each time.

   fclose( logFile );                            // close the open file and
}

