//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __PKTQUEUE_H
#include "pktqueue.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

void LAPB::recover()
// -------------------------------------------------------------------------
// Called whenever timer T1 expires
// -------------------------------------------------------------------------
{
   retrans = 1;
   retries++;
   if ((1L << retries) < cfg.bLimit)
      t1->set( t1->getDuration() * 2 );    // back off retransmit timer

   switch (state)
   {
      case SETUP:
         if (n2 != 0 && retries > n2)
         {
            txq->free();                    // purge xmit queue
            reason = LB_TIMEOUT;
            setState( DISCONNECTED );
         }
         else
         {
            sendCtl( COMMAND, SABM | PF );
            t1->start();
         }
         break;
      case DISCPENDING:
         if (n2 != 0 && retries > n2)
         {
            reason = LB_TIMEOUT;
            setState( DISCONNECTED );
         }
         else
         {
            sendCtl( COMMAND, DISC | PF );
            t1->start();
         }
         break;
      case CONNECTED:
      case RECOVERY:
         if (n2 != 0 && retries > n2)
         {
            sendCtl( RESPONSE, DM | PF ); // give up
            txq->free();                        // purge xmit queue
            reason = LB_TIMEOUT;
            setState( DISCONNECTED );
         }
         else
         {
            txEnq();                  // transmit poll
            setState( RECOVERY );
         }
         break;
      }
}

void LAPB::pollThem()
// -------------------------------------------------------------------------
// Send a poll (S-frame command with the poll bit set)
// -------------------------------------------------------------------------
{
   if (proto == Ax25::V1)                     // not supported in the old
      return;                                    // protocol

   switch (state)
   {
      case CONNECTED:
         retries = 0;
         txEnq();
         setState( RECOVERY );
         break;
   }
}

void LAPB::txEnq()
// -------------------------------------------------------------------------
// Transmit query
// -------------------------------------------------------------------------
{
   char ctl;

	// I believe that retransmitting the oldest unacked
	// I-frame tends to give better performance than polling,
	// as long as the frame isn't too "large", because
	// chances are that the I frame got lost anyway.
	// This is an option in LAPB, but not in the official AX.25.

   unsigned len = 0;
   if (txq)
      len = txq->len();
   if (len > 0 && (len < pthresh || proto == Ax25::V1))
   {
      // Retransmit oldest unacked I-frame

      MBuf* op = txq->initIterator( 0 );         // start iteration sequence
      MBuf* bp = new MBuf( *op );                // duplicate the MBuf
      ctl = PF | I | (((vs - unack) & MMASK) << 1) | (vr << 5);
      if (axp)
      axp->sendFrame( COMMAND, ctl, *bp );       // send the MBuf
   }
   else
   {
      ctl = rxq->len() >= window ? RNR|PF : RR|PF;
      sendCtl( COMMAND, ctl);
   }
   response = 0;
   t3->stop();
   t1->start();
}

T1CallUp::T1CallUp( Object& obj ) : CallUp( obj )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void T1CallUp::func() const
// -------------------------------------------------------------------------
// T1 timer call up function
// -------------------------------------------------------------------------
{
   ((LAPB&) obj).recover();
}

T3CallUp::T3CallUp( Object& obj ) : CallUp( obj )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void T3CallUp::func() const
// -------------------------------------------------------------------------
// T3 timer call up function
// -------------------------------------------------------------------------
{
   ((LAPB&) obj).pollThem();
}

