//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __LAPB_H
#define  __LAPB_H

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __OBJECT_H
#include "object.h"
#endif

class T1CallUp : public CallUp
{
public:
                         T1CallUp( Object& obj );
         void            func() const;
};

class T3CallUp : public CallUp
{
public:
                         T3CallUp( Object& obj );
         void            func() const;
};

// Level 2 sub-layer (LAPB)

class Ax25;
class CallUp;
class Config;
class LinkTable;
class Log;
class MBuf;
class PktQueue;
class Timer;
class Window;

class LAPB : public Object
{
public:
   static enum         { I              = 0x00,  // Information frames
                         S              = 0x01,  // Supervisory frames
                         RR             = 0x01,  // Receiver ready
                         RNR            = 0x05,  // Receiver not ready
                         REJ            = 0x09,  // Reject
                         U              = 0x03,  // Unnumbered frames
                         SABM           = 0x2f,  // Set Asynchronous Balanced Mode
                         DISC           = 0x43,  // Disconnect
                         DM             = 0x0f,  // Disconnected mode
                         UA             = 0x63,  // Unnumbered acknowledge
                         FRMR           = 0x87,  // Frame reject
                         UI             = 0x03,  // Unnumbered information
                         PF             = 0x10 };// Poll/final bit

   static enum         { DISCONNECTED   = 1,
                         LISTEN         = 2,
                         SETUP          = 3,
                         DISCPENDING    = 4,
                         CONNECTED      = 5,
                         RECOVERY       = 6 };

          int            oldState;               // previous state
          unsigned       paclen;                 // maximum outbound packet size, bytes
          char           proto;                  // protocol version
          char           reason;                 // reason for connection closing
          int            state;                  // link state
          unsigned       window;                 // local flow control limit, bytes

                         LAPB( Config& cfg, Window& win, Log& log );
                         ~LAPB();
          unsigned       bytesToSend();
          void           connect();
          void           disc();
          void           enqueue( MBuf& mb );
          int            input( int cmdrsp, MBuf& mb );
          void           link( Ax25& ax, LinkTable& linkTbl );
          int            output();
          void           pollThem();
          void           recover();
          int            sendCtl( int cmdrsp, int cmd );
          void           setState( int s );

private:
                         // Control field templates

   static enum         { UNKNOWN        = 0,     // C-bit stuff
                         COMMAND        = 1,
                         RESPONSE       = 2 };

   static enum         { LB_NORMAL      = 0,     // normal close
                         LB_DM          = 1,     // received DM from other end
                         LB_TIMEOUT     = 2 };   // excessive retries

   static enum         { SEG_FIRST      = 0x80,  // first segment of a sequence
                         SEG_REM        = 0x7f };// mask for # segments remaining

   static enum         { MMASK          = 7 };   // Mask for modulo-8 sequence numbers

                         // FRMR reason bits

   static enum         { W               = 1,    // Invalid control field
                         X               = 2,    // Unallowed I-field
                         Y               = 4,    // Too-long I-field
                         Z               = 8 };  // Invalid sequence number

          Ax25*          axp;
          Config&        cfg;
          int            delBuf;
          char           framesToQueue;
          int            maxframe;               // transmit flow control level, frames
          LinkTable*     linkTbl;
          Log&           log;
          unsigned long  mdev;                   // mean rtt deviation, ms
          unsigned       n2;                     // retry limit
          unsigned       pthresh;                // poll threshold, bytes
          MBuf*          rxasm;                  // receive reassembly buffer
          char           rejsent;                // REJ frame has been sent
          char           remotebusy;             // remote sent RNR
          char           response;               // response owed to other end
          char           retrans;                // a retransmission has occurred
          unsigned       retries;                // retry counter
          char           rtt_run;                // round trip "timer" is running
          unsigned       rtt_seq;                // sequence number being timed
          unsigned long  rtt_time;               // stored clock values for RTT, ticks
          PktQueue*      rxq;                    // receive queue
          int            segremain;              // segmenter state
          unsigned long  srt;                    // smoothed round-trip time, ms
          Timer*         t1;                     // retry timer
          T1CallUp       t1CallUp;               // T1 timer call-up function
          Timer*         t3;                     // keep-alive poll timer
          T3CallUp       t3CallUp;               // T3 timer call-up function
          PktQueue*      txq;                    // transmit queue
          char           unack;                  // number of unacked frames
          char           vr;                     // our receive state variable
          char           vs;                     // our send state variable
          Window&        win;

          int            ackOurs( unsigned n );
          void           clrEx();
          void           enqResp();
          void           estLink();
          void           handleIt( int pid, MBuf& mb );
          void           invRex();
          void           procData( MBuf& mb );
          void           sCall() const;
//        MBuf&          segmenter( MBuf& bp, unsigned ssize );
          void           txEnq();

          friend class   Ax25Hdr;
          friend class   Ax25;
};

#endif	 _LAPB_H
