//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// --------------------------------------------------------------------------
// Routines for frame encapsulation in KISS
// --------------------------------------------------------------------------

#ifndef  __KISS_H
#include "kiss.h"
#endif

#ifndef  __STDOUT_H
#include <stdio.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

Kiss::Kiss( unsigned& debug ) : L1Protocol()
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   this->debug = &debug;
}

void Kiss::link( L1Protocol& loPro, L2Protocol& hiPro )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   hiProto = &hiPro;
   loProto = &loPro;
}

void Kiss::showFrame( const MBuf& buf ) const
// --------------------------------------------------------------------------
// Display a KISS frame in hex; currently limited to the first two bytes.
// --------------------------------------------------------------------------
{
   sprintf( frWin->buf, "KISS : %02x %02x\n", buf.data[0], buf.data[1] );
   frWin->print( frWin->buf );
}

void Kiss::recvIn( MBuf& buf )
// --------------------------------------------------------------------------
// Handle an incoming KISS frame.
// --------------------------------------------------------------------------
{
   if (*debug > 2)                               // display incoming frame
      showFrame( buf );

   char kissType = buf.pullChar();               // retrieve and delete
   switch (kissType)                             // KISS frame type field
   {
      case DATA:                                 // should only get data
         if (hiProto)
            hiProto->recvIn( buf );
         else
            delete &buf;
         break;
      case TXDELAY:                              // should only get here when
      case PERSIST:                              // processing log files that
      case SLOTTIME:                             // contain KISS commands
      case TXTAIL:
      case FULLDUP:
      case HW:
      case OFF:
         delete &buf;
         break;
      default:                                   // error if we get here
         recvErrCnt++;
         if (eCallUp)                            // if we need to report the
            eCallUp->func();
         delete &buf;
   }
}

int Kiss::send( MBuf& buf )
// --------------------------------------------------------------------------
// Send data frame in KISS
// --------------------------------------------------------------------------
{
   buf.pushDown( 1 );                            // put type for data on front
   *buf.data = DATA;
   if (*debug > 2)                               // display line-ready frame
      showFrame( buf );
   if (loProto)
      return loProto->send( buf );               // output KISS frame
   else
      return 1;
}

long Kiss::send( enum KissVal cmd, const unsigned long val) const
// --------------------------------------------------------------------------
// Send control messages in KISS; return 0 if successful.
// --------------------------------------------------------------------------
{
   // At present, only certain parameters are supported in KISS.
   // As additional params are implemented, this will have to be edited.

   MBuf* bp = new MBuf( 2 );                     // allocate a frame
   switch( cmd )
   {
      case TXDELAY :                             // mediumn access control
      case PERSIST:
      case SLOTTIME:
      case TXTAIL:
      case FULLDUP:
      case HW:
         bp->cnt = 2;                            // set the data count
         bp->data[ 0 ] = cmd;                    // set the data
         bp->data[ 1 ] = (char) val;
         break;
      case OFF :
         bp = new MBuf( 1 );                     // allocate a frame
         bp->cnt = 1;                            // set the data count
         *bp->data = OFF;                        // set the data
         break;
      default :
         break;
   }
   if (!loProto || !bp->cnt)
   {
      delete bp;
      return 1;
   }
   if (*debug > 2)                            // dump line-ready frame
       showFrame( *bp );
   return (loProto )->send( *bp );            // output KISS frame
}
