//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __HWDEVICE_H
#define  __HWDEVICE_H

// Description
//
//    Defines the abstract base class HwDevice.  HwDevice is the class
//    at the root of all hardware devices and defines standard interface
//    functions for all devices.
//

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class MBuf;

class HwDevice : public Protocol
{
public:
           enum       devVal { devBAUDRATE  =  1,
                               devPARITY    =  2,
                               devDATABITS  =  3,
                               devSTOPBITS  =  4,
										 devDTR       =  5,
                               devOUT1      =  6,
                               devOUT2      =  7,
                               devRTS       =  8,
                               devCTSmode   =  9,
                               devRTSmode   = 10,
                               devSOFTFLOW  = 11,
                               devSTARTCHAR = 12,
                               devSTOPCHAR  = 13,
                               devDelay     = 14,
                               devInterval  = 15 };

                        HwDevice();
   virtual  int         close() = 0;
   virtual  int         dataReady() = 0;
   virtual  int         flush( const char ) const = 0;
				void        link( L1Protocol& hiPro );
   virtual  int         open() = 0;

                           // trigger the receiver function
   virtual  void        poll() = 0;

									// get from the receiver a pointer to an MBuf that
                           // the receiver created and filled with input
   virtual  int         recvOut( MBuf*& ) = 0;

                           // get from the receiver a character of input
   virtual  int         recvOut( char& ) = 0;

                           // get back from the receiver the input filled
                           // character array that the caller provides
   virtual  int         recvOut( char*, const unsigned len, unsigned &cnt ) = 0;

                           // give the transmitter an MBuf to send
   virtual  int         send( MBuf& ) = 0;

                           // give the transmitter a character to send
   virtual  int         send( const char ) = 0;

	virtual  int         send( const char*, const unsigned ) { return 1; }
	virtual  int         set( enum devVal param, const unsigned long ) = 0;

protected:
				unsigned    delayMs;                 // delay time, in millisecs
				L1Protocol* hiProto;
            unsigned    interval;                // characters between delays
   const    int         MAXPORT;
            int         port;
};

#endif  __HWDEVICE_H

