//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef __HOLFILE_H
#define __HOLFILE_H

// Forward References

class ActFile;
class Window;

typedef struct FPair
{
   char     offset[3];
   unsigned len;
} FPair;

class HolFile
{
public:
   static   enum          { SAVE, PURGE };
   static   enum          { MAX_PAIRS = 10, MAXBYTES = 64 };

            unsigned long   fileSize;
            unsigned        holCount;
            unsigned long   holTotal;

                            HolFile(       char*         path,
                                     const unsigned long fileNumber,
                                           Window&       frWin );
                            ~HolFile();
            void            open();
            void            close( const int closeAction );
            void            adjustLastHolDn();
            void            adjustLastHolUp( const unsigned long newSize );
   inline   unsigned long   firstHol();
   static   int             holeStrFromFile( const char*         path,
                                             const unsigned long fileNumber,
                                             FPair*              pr );
            int             holeStrFromMem( FPair* pr );
            int             needData( const unsigned long offset,
                                      const unsigned dLen,
                                      const char     flag );

private:
   typedef struct FHole
   {
                   unsigned long lowerLimit;
                   unsigned long upperLimit;
   } FHole;

   static   enum          { LIST_SIZE_START = 100,
                            LIST_SIZE_INC   = 25,
                            MAXLINE = 81 };

            char*           path;
   static   char            fileName[ MAXPATH ];
   static   char            inRec[ MAXBYTES ];
            unsigned long   fileNumber;
            Window&         frWin;
            FHole*          list;
            unsigned        listSize;

            void            addHol( const unsigned long loLimit,
                                    const unsigned long upLimit );
            void            deleteHol( const unsigned i );
};

#endif   __HOLFILE_H
