//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __HELP_H
#include "help.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __DIR_H
#include "dir.h"
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

Help::Help( const Config& cfg ) : cfg( cfg )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
}

unsigned Help::processKey( const char* section, const int key )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   switch( key )
   {
      case 'q':
      case 'Q':
      case 27:
         fclose( file );
         delete rec;
         delete win;
         return 0;
      case 0:
      {
         fileName = new char[ MAXPATH ];
         sprintf( fileName, "%sSATLINK.HLP", cfg.workDir );
         file = fopen( fileName, "rb" );
         delete fileName;
         if (!file)
            return 0;
         MsgLine* msg = new MsgLine( 24, cfg.msgLineBg, cfg.msgLineFg );
         delete msg;
         rec = new char[ 80 ];
         win = new Window( 1, 1, 80, 23, cfg.helpBg, cfg.helpFg );
      }
      default:                                   // note: fall through
         win->clear();
         while( fgets( rec, 80, file) != 0)
            if (strnicmp( rec, section, 4 ) == 0)
               break;
         while( fgets( rec, 80, file) != 0)
         {
            if (strnicmp( rec, "*END", 4 ) == 0)
               break;
            rec[ strlen( rec ) - 1 ] = 0;
            win->print( rec );
         }
         return 1;
   }
}
