//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __HDLNOL3_H
#include "hdlnol3.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __AXSOCK_H
#include "axsock.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

NoL3FrameMgr::NoL3FrameMgr( BeaconMgr& bm ) : bm( bm )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{}

void NoL3FrameMgr::recvIn( Level3Iface& l3If )
// --------------------------------------------------------------------------
//  Handle ordinary incoming data (no network protocol)
// --------------------------------------------------------------------------
{
   if (!l3If.l2p)
      bm.recvIn( l3If );
   else
   {
      Ax25* axp = (Ax25*)l3If.l2p;
      axp->rxEnqueue( *l3If.bp );                // data buffer pointer
      if (axp->rCallUp)
         axp->rCallUp->func();
   }
}
