//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __GETUE_H
#define  __GETUE_H

class ActList;
class Config;
class CmdLine;
class DirBcstMgr;
class Directory;
class EventQueue;
class FileBcstMgr;
class FTL0;
class FTL0User;
class HighTime;
class Help;
class StatusLine;
class StatusList;
class Terminal;
class Timer;
class TncMgr;
class Window;

class UserMgr
{
public:
          enum         { Normal,
                         Review_Directory,
                         No_File_Window,
                         FileSelect,
                         MainHelp,
                         DirectoryHelp,
                         Directory_Select,
                         Hightime_Adjust };

                         UserMgr( Config&      cfg,
                                  DirBcstMgr&  dbm,
                                  FileBcstMgr& fbm,
                                  Window&      fiWin,
                                  Window&      iWin,
                                  Window&      frWin,
                                  CmdLine&     cLine,
                                  StatusLine&  sLine,
                                  int&         screenCount,
                                  FTL0User&    ftl0User,
                                  HighTime&    hTime,
                                  Terminal&    terminal,
                                  FTL0&        ftl0,
                                  StatusList&  sList,
                                  TncMgr&      tnc,
                                  ActList&     actList,
                                  Directory&   dir,
                                  Timer&       exitAfterTimer,
                                  EventQueue&  pQ,
                                  Help&        help );
                         ~UserMgr();
   static       int      getFileNumber( char*          cp,
                                        char           key,
                                        unsigned long* file_number,
                                        CmdLine&       cLine );
          void           kbRecv();
          void           processKey( const int key );

private:
          ActList&       actList;
          FTL0User&      ftl0User;
          Config&        cfg;
          CmdLine&       cLine;
          DirBcstMgr&    dbm;
          Directory&     dir;
          Timer&         exitAfterTimer;
          FileBcstMgr&   fbm;
          Window&        fiWin;
          int            fiWinStateSave[ 5 ];
          Window&        frWin;
          int            frWinStateSave[ 5 ];
          FTL0&          ftl0;
          Help&          help;
          unsigned       lastCommand;
          HighTime&      hTime;
          Window&        iWin;
          int            iWinStateSave[ 5 ];
          EventQueue&    pQ;
          int&           screenCount;
          StatusLine&    sLine;
          StatusList&    sList;
          int            state;
          Terminal&      terminal;
          TncMgr&        tnc;

          void           bcstCommand( unsigned command );
          void           exitInfo( unsigned long exitAfterMs,
                                   unsigned long abortTime,
                                   unsigned long idleExitTime ) const;
          void           info() const;
          void           restoreScreen( int scope );
          void           saveScreen();
};

#endif __GETUE_H
