//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __DIR_H
#include <dir.h>
#endif

#include <fcntl.h>

#ifndef  __IO_H
#include <io.h>
#endif

#ifndef  __STAT_H
#include <sys/stat.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __AX25USER_H
#include "ax25User.h"
#endif

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef  __DIRDL_H
#include "dirdl.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __FTL0PKT_H
#include "ftl0pkt.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __TNCMGR_H
#include "tncmgr.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

FTL0Pkt& FTL0::readPkt( MBuf& mb )
// --------------------------------------------------------------------------
// Read FTL0 packets from the passed frames.
// Return a complete packet or NULPKT.
// --------------------------------------------------------------------------
{
   static FTL0Pkt*   pkt;
   static int        ftl0_pkt_end = 1;           // end of ftl0 pkt flag
          unsigned   length_LSB;                 // least significant bits
          unsigned   length_MSB;                 // most significant bits

   if (ftl0_pkt_end)
   {
      ftl0_pkt_end = 0;                          // reset "end rcvd" flag
      pkt = new FTL0Pkt;                         // allocate a packet
      pkt->l = 0;                                // zero the body length
   }

   if (pkt->l == 0)                              // if new pkt (zero body)
   {                                             //   then get packet length
      length_LSB = mb.data[ 0 ];                 // inefficient but clearer
      length_MSB = mb.data[ 1 ] >> 5;            // bits 7-5
      pkt->len  = length_LSB + (length_MSB << 8);
      if (pkt->len > 254)
      {
         frWin.print( "readPkt : FTL0 packet > 254" );
         pkt->l = 0;                             // zero the body length
         delete &mb;
         return NULPKT;
      }
      pkt->type  = mb.data[ 1 ] & 0x1f;          // bits 4-0
      dispPktType( pkt->type );                  // display type at beginning
   }
   if (pkt->l + mb.cnt > MAX_DATA)
   {
      frWin.print( "readPkt : bad FTL0 packet" );
      pkt->l = 0;                                // zero the body length
      delete &mb;
      return NULPKT;
   }
                                                 // add frame contents to pkt
   memcpy( pkt->c + pkt->l, mb.data, mb.cnt );
   pkt->l += mb.cnt ;                            // inc pkt body length
   delete &mb;

   // An assumption is that an AX.25 frame will not contain portions of
   // more than one FTL0 packet.  If this assumptions holds, then the
   // AX.25 frame will be no longer than necessary to hold the last
   // bytes of the FTL0 packet, and the the next line of code will test
   // for the end-of-FTL0-packet condition.

   if ((pkt->l >= 2) && (pkt->l == pkt->len + 2))
   {
      ftl0_pkt_end = 1;                          // complete FTL0 packet
      return *pkt;                               // return ptr to pkt
   }
   else
      return NULPKT;                             // more to come
}

int FTL0::transmit( int command )
// --------------------------------------------------------------------------
//  transmit an FTL0 packet
// --------------------------------------------------------------------------
{
   typedef struct DataCmd
   {
      unsigned      header;
      unsigned char c[ 1 ];                      // dummy element count
   } DataCmd;

   struct
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
   } dataEndCmd = {0, DATA_END};

   typedef struct DirCmd
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
      unsigned long file_no;
   } DirCmd;

   struct
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
      unsigned char register_dest;
   } dlAckCmd = {1, DL_ACK_CMD, 0x00};

   typedef struct DlCmd
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
      unsigned long file_no;
      unsigned long byte_offset;
      unsigned char lock_destination;
   } DlCmd;

   struct
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
   } dlNakCmd = {0, DL_NAK_CMD};

   typedef struct LVALUEt2
   {
      unsigned char relop;
      unsigned int  item_id;
      unsigned char length;
      unsigned long constant;
   } LVALUEt2;

   typedef struct LoginResp
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
      unsigned long login_time;
      unsigned char login_flags;
   } LoginResp;

   typedef struct SelAllCmd
   {
      unsigned char     length_lsb;
      unsigned char     pkt_type;
      LVALUEt2          v;
      unsigned char     end_flag;
   } SelAllCmd;

   typedef struct SelBulCmd
   {
      unsigned char     length_lsb;
      unsigned char     pkt_type;
      struct {                                   // LVALUEt1
         unsigned char     relop;
         unsigned int      item_id;
         unsigned char     length;
         unsigned char     constant[4];
      }                 v1;
      LVALUEt2          v2;
      unsigned char     lop;
      unsigned char     end_flag;
   } SelBulCmd;

   typedef struct SelMyCmd
   {
      unsigned char     length_lsb;
      unsigned char     pkt_type;
      struct {                                   // LVALUEt1
         unsigned char     relop;
         unsigned int      item_id;
         unsigned char     length;
         unsigned char     constant[7];          // variable length; max 7
      }                 v1;
      struct   LVALUEt2 v2;
      unsigned char     lop;
      unsigned char     end_flag;
   } SelMyCmd;

   typedef struct UlCmd
   {
      unsigned char length_lsb;
      unsigned char pkt_type;
      unsigned long continue_file_no;
      unsigned long file_length;
   } UlCmd;

   struct ffblk  fileinfo;

   typedef struct Dir {
      int  l;
      char c[256];
   } Dir;

          MBuf*         bp = 0;
//        unsigned      bytesToSend = 0;
   static DataCmd*      datCp = 0;               // ptr to FTL0 DATA frame
          char*         dl_file_name;
          char*         dp;
          Dir*          dir;
          DirCmd*       dirSCp;
          DirCmd*       dirLCp;
          DlCmd*        dlCp;
   static unsigned long file_length = 0;
   static char*         frRem = 0;               // ptr to remainder of FTL0
                                                 // frame not sent
          unsigned long offset;                  // file offset
   static unsigned      remCnt = 0;              // bytes in remainder
          int           rtnCode = 0;

   switch (command)
   {
      case DATA:

         // Note:  file_length was set with the UL_CMD.

         if (!datCp)
         {                                       // allocate frame data area
            datCp = (DataCmd*) new char[ 2 + cfg.ftl0Paclen ];
            if (!datCp)
               frWin.printFatal( "transmit : out of memory" );
         }

         bp = new MBuf( maxBytesToSend );        // allocate a new MBuf
         dp = bp->data;                          // set working data pointer

         if (frRem)                              // if there is a remainder
         {                                       // move it to outgoing MBuf
            if (remCnt <= maxBytesToSend)        // if room for entire remainder
            {
               memcpy( dp, frRem, remCnt );      // copy it
               dp += remCnt;                     // advance working pointer
               bp->cnt = remCnt;                 // update data count
               delete frRem;                     // delete the remainder
               frRem = 0;                        // zero the pointer
            }
            else                                 // else
            {                                    // do a partial copy
               memcpy( dp, frRem, maxBytesToSend );
               remCnt -= maxBytesToSend;         // shift the remainder
               memmove( frRem, frRem + maxBytesToSend, remCnt );
            }
         }

         while (bp->cnt < maxBytesToSend &&      // count not exceeded
                byteOffset < file_length)        // && file data not yet read
         {
            if (fseek( ulFile, byteOffset, SEEK_SET ) != 0)
            {
               sprintf( frWin.buf, "fseek error for file %-lx.PUL",
                                   serverFileNumber );
               frWin.print( frWin.buf );
               delete bp;
               return 1;
            }
            unsigned bytesRead = fread( datCp->c, 1, cfg.ftl0Paclen, ulFile );
            if (!bytesRead)
            {
               sprintf( frWin.buf, "fread zero bytes for file %-lx.PUL",
                                   serverFileNumber );
               frWin.print( frWin.buf );
               delete bp;
               return 1;
            }
            if (cfg.debug > 0)
            {
               sprintf( frWin.buf, "Sent data %-lx %lu %u",
                                   serverFileNumber, byteOffset, bytesRead );
               frWin.print( frWin.buf );
            }
            float percent = 100.0 * ftell( ulFile ) / file_length;
            sprintf( frWin.buf, "Upload of %-lx is now [ %li out of %lu ] "
                                "%.1f%% queued for transmission", serverFileNumber,
                                ftell( ulFile ), file_length, percent );
            frWin.print( frWin.buf );

            datCp->header = bytesRead;           // set data length
            unsigned frSize = 2 + bytesRead;     // calc frame size
                                                 // if room for entire frame
            if (bp->cnt + frSize <= maxBytesToSend)
            {
               memcpy( dp, datCp, frSize);       // copy it
               bp->cnt += frSize;                // update data count
            }
            else                                 // else
            {                                    // do a partial copy
               unsigned copyCnt = maxBytesToSend - bp->cnt;
               memcpy( dp, datCp, copyCnt );
               bp->cnt += copyCnt;               // update data count
               remCnt = frSize - copyCnt;        // calc remainder size
               frRem = new char[ remCnt ];       // construct remainder
                                                 // copy remainder data
               memcpy( frRem, (char*) datCp + copyCnt, remCnt );
            }

            if (!bytesUploaded)                  // if just starting to send
               startTime = Timer::msTime();      //   remember the time
            bytesUploaded += bytesRead;          // count just the data sent

            // The data length is limited to a maxium of 57,599 (0xe0ff) to
            // leave bits 4-0 for the FTL0 packet type.  The following step
            // would normally be necessary, except because "DATA" = 0,
            // the header already contains the FTL0 packet type after the
            // length is entered.
            //
            //    datCp->header &= (0xe0ff | DATA << 8);

            dp = bp->data + bp->cnt;             // advance working pointer
            byteOffset += bytesRead;             // and offset for next read
         }
         if (cfg.debug > 2)
            frWin.printHex( bp->data, bp->cnt );
         ftl0User->send( *ftl0User->bbsAxp, *bp, Ax25::PID_NO_L3 );
         lastSentTime = Timer::msTime();         // remember the time
         return 0;

      case DATA_END:

         if (cfg.debug > 0)
            frWin.print( "Sent data: DATA_END" );

         bp = new MBuf( sizeof( dataEndCmd ) + 17 );
         memcpy( bp->data, &dataEndCmd, sizeof( dataEndCmd ) );

         bp->cnt = sizeof( dataEndCmd );
         break;

      case DIR_LONG_CMD:

         bp = new MBuf( sizeof( DirCmd ) + 17 );
         dirLCp = ( DirCmd * )bp->data;

         dirLCp->length_lsb = 4;
         dirLCp->pkt_type = DIR_LONG_CMD;
         if (strcmp( selScope, "ONE" ) == 0)
         {
            sprintf( frWin.buf, "Requesting long directory for file %-lx",
                          dirFileNumber);
            frWin.print( frWin.buf );
            dirLCp->file_no = dirFileNumber;
         }
         else
         {
            frWin.print( "Requesting directory - long." );
            dirLCp->file_no = 0xffffffffL;
         }

         bp->cnt = sizeof( DirCmd );
         ddm.reset();                            // initialize dir accumulator
         break;

      case DIR_SHORT_CMD:

         bp = new MBuf( sizeof( DirCmd ) + 17 );
         dirSCp = ( DirCmd * )bp->data;

         dirSCp->length_lsb = 4;
         dirSCp->pkt_type = DIR_SHORT_CMD;
         if (strcmp( selScope, "ONE" ) == 0)
         {
            sprintf( frWin.buf, "Requesting short directory for file %-lx",
                                dirFileNumber);
            frWin.print( frWin.buf );
            dirSCp->file_no = dirFileNumber;
         }
         else
         {
            frWin.print( "Requesting directory - short." );
            dirSCp->file_no = 0xffffffffL;
         }

         bp->cnt = sizeof( DirCmd );
         ddm.reset();                            // initialize dir accumulator
         break;

      case DL_ACK_CMD:

         if (cfg.debug > 0)
            frWin.print( "Sent data: DL_ACK_CMD" );

         bp = new MBuf( sizeof( dlAckCmd ) + 17 );
         memcpy( bp->data, &dlAckCmd, sizeof( dlAckCmd ) );

         bp->cnt = sizeof( dlAckCmd );
         break;

      case DL_CMD:

         // check for file with DL or DLX extension
         if (sList.status( dlFileNumber )  == sList.DOWNLOADED)
         {
            sprintf( frWin.buf, "%-lx already downloaded", dlFileNumber);
            frWin.print( frWin.buf );
            rtnCode = 1;
            break;
         }
         dl_file_name = new char[ MAXPATH ];
         sprintf( dl_file_name, "%s%-lx.PDL", cfg.dlDir, dlFileNumber );
         sprintf( frWin.buf, "Downloading file %s", dl_file_name );
         log.write( frWin.buf );
         frWin.print( frWin.buf );
         if ((dlFile = open( dl_file_name, O_CREAT | O_APPEND | O_RDWR | O_BINARY,
                        S_IWRITE)) == -1)
         {
            sprintf( frWin.buf, "error opening download file %s, %s", dl_file_name,
                                sys_errlist[ errno ] );
            frWin.print( frWin.buf );
            rtnCode = 1;
            delete dl_file_name;
            break;
         }
         delete dl_file_name;
         sprintf( frWin.buf, "Requesting download of file %-lx", dlFileNumber );
         frWin.print( frWin.buf );

         bp = new MBuf( sizeof( DlCmd ) + 17 );
         dlCp = ( DlCmd * )bp->data;

         dlCp->length_lsb = 9;
         dlCp->pkt_type = DL_CMD;
         dlCp->file_no = dlFileNumber;

         // position file at end and get offset

         dlCp->byte_offset = lseek( dlFile, 0, SEEK_END );
         offset = dlCp->byte_offset; // save offset
         dlCp->lock_destination = 0;

         bp->cnt = sizeof( DlCmd );

         // If the offset > 0, try to get the file size from the file
         // header.  File size is needed for displaying percent complete;

         if (offset > 0)
         {
            dir = new Dir;
            lseek( dlFile, 0, SEEK_SET );       // go to beginning
            dir->l = ::read( dlFile, dir->c, 255 );
            lseek( dlFile, 0, SEEK_END );      // reposition
            if ((dlFileSize = ddm.getFileSize( dir->c, dir->l )) == 0)
               dlFileSize = 0xffffffffL;
            delete dir;
         }
         else
            dlFileSize = 0xffffffffL;
         break;

      case DL_NAK_CMD:

         if (cfg.debug > 0)
            frWin.print( "Sent data: DL_NAK_CMD" );

         bp = new MBuf( sizeof( dlNakCmd ) + 17 );
         memcpy( bp->data, &dlNakCmd, sizeof( dlNakCmd ) );

         bp->cnt = sizeof( dlNakCmd );
         break;

      case LOGIN_RESP:
      {
         if (cfg.debug > 0)
            frWin.print( "Sent data: LOGIN_RESP" );

         bp = new MBuf( sizeof( LoginResp ) + 17 );
         LoginResp* lrCp = ( LoginResp* )bp->data;

         lrCp->length_lsb = 5;
         lrCp->pkt_type = LOGIN_RESP;
         lrCp->login_time = time( 0 );
         lrCp->login_flags = 0x04;

         bp->cnt = sizeof( LoginResp );
         break;
      }
      case SELECT_CMD :

         if (hTime.get( &hTime.hightime, selScope, cfg.workDir) != 0)
         {
            rtnCode = 1;
            break;
         }
         sprintf( frWin.buf, "Selecting %s files newer than %s", selScope,
                             ctime( (time_t *)&hTime.hightime ) );
         // delete terminating carriage return
         frWin.buf[ (int)(strchr( frWin.buf, '\n' ) - frWin.buf) ] = 0;
         log.write( frWin.buf );
         frWin.print( frWin.buf );

         if (strcmp(selScope, "ALL" ) == 0)
         {
            bp = new MBuf( sizeof( SelAllCmd ) + 17 );
            SelAllCmd *saCp = ( SelAllCmd * )bp->data;

            saCp->length_lsb = 9;
            saCp->pkt_type = SELECT_CMD;
            saCp->v.relop = 0x90;
            saCp->v.item_id = UPLOAD_TIME;
            saCp->v.length = 4;
            saCp->v.constant = hTime.hightime;
            saCp->end_flag = 0x00;

            bp->cnt = sizeof( SelBulCmd );
         }
         else
         if (strcmp( selScope, "BUL" ) == 0)
         {
            bp = new MBuf( sizeof( SelBulCmd ) + 17 );
            SelBulCmd *sbCp = ( SelBulCmd * )bp->data;

            sbCp->length_lsb = 18;
            sbCp->pkt_type = SELECT_CMD;
            sbCp->v1.relop = 0x84;
            sbCp->v1.item_id = DESTINATION;
            sbCp->v1.length = 4;
            memcpy( sbCp->v1.constant, "all*", 4 );
            sbCp->v2.relop = 0x90;
            sbCp->v2.item_id = UPLOAD_TIME;
            sbCp->v2.length = 4;
            sbCp->v2.constant = hTime.hightime;
            sbCp->lop = 0x01;
            sbCp->end_flag = 0x00;

            bp->cnt = sizeof( SelBulCmd );
         }
         else
         if (strcmp( selScope, "MY" ) == 0)
         {
            bp = new MBuf( sizeof( SelMyCmd ) + 17 );
            char *tmp = bp->data;

            char callLen = strlen( cfg.mycall );
            *tmp++ = 15 + callLen;               // length_lsb
            *tmp++ = SELECT_CMD;                 // pkt_type
            *tmp++ = 0x84;                       // v1.relop
            *(unsigned *)tmp = DESTINATION;      // v1.item_id
            tmp += 2;
            *tmp++ = callLen + 1;                // v1.length
            memcpy( tmp, cfg.mycall, callLen );  // v1.constant
            tmp += callLen;
            *tmp++ = '*';
            *tmp++ = 0x90;                       // v2.relop
            *(unsigned *)tmp = UPLOAD_TIME;      // v2.item_id
            tmp += 2;
            *tmp++ = 4;                          // v2.length
            *(unsigned long *)tmp = hTime.hightime;// v2.constant
            tmp += 4;
            *tmp++ = 0x01;                       // lop
            *tmp++ = 0x00;                       // end_flag

            bp->cnt = sizeof( SelBulCmd ) - 6 + callLen;
         }
         break;

      case UL_CMD:

         sprintf( ulFileName, "%s*.PUL", cfg.ulDir );
         if (findfirst( ulFileName, &fileinfo, 0 ) != 0)
         {
            sprintf( ulFileName, "%s*.OUT", cfg.ulDir );
            findfirst( ulFileName, &fileinfo, 0 );
         }
         sprintf( frWin.buf, "Uploading file %s, %lu bytes",
                             fileinfo.ff_name, fileinfo.ff_fsize );
         log.write( frWin.buf );
         frWin.print( frWin.buf );
         sprintf( ulFileName, "%s%s", cfg.ulDir, fileinfo.ff_name );

         bp = new MBuf( sizeof( UlCmd ) + 17 );
         UlCmd *ulCp = ( UlCmd * )bp->data;

         ulCp->length_lsb = 8;
         ulCp->pkt_type = UL_CMD;
         if (strstr( fileinfo.ff_name, ".PUL" ) != NULL)
            sscanf( fileinfo.ff_name, "%lx", &ulCp->continue_file_no );
         else
            ulCp->continue_file_no = 0;
         file_length = ulCp->file_length = fileinfo.ff_fsize; // save length

         bp->cnt = sizeof( UlCmd );
         break;
   }

   if (bp)
   {
      if (cfg.debug > 1)
         frWin.printHex( bp->data, bp->cnt );
      ftl0User->send( *ftl0User->bbsAxp, *bp, Ax25::PID_NO_L3 );
   }
   return rtnCode;
}

void FTL0::dispPktType( int type )
// -------------------------------------------------------------------------
//  Display FTL0 packet type
// -------------------------------------------------------------------------
{
   char* str[18] = {"FTL0 packet: DATA",                          //  0
                    "FTL0 packet: DATA_END",                      //  1
                    "FTL0 packet: LOGIN_RESP",                    //  2
                    0,                                            //  3
                    "FTL0 packet: UL_GO_RESP",                    //  4
                    "FTL0 packet: UL_ERROR_RESP",                 //  5
                    "FTL0 packet: UL_ACK_RESP",                   //  6
                    "FTL0 packet: UL_NAK_RESP",                   //  7
                    0,                                            //  8
                    "FTL0 packet: DL_ERROR_RESP",                 //  9
                    "FTL0 packet: DL_ABORTED_RESP",               // 10
                    "FTL0 packet: DL_COMPLETED_RESP",             // 11
                    0,0,0,0,0,                                    // 12-16
                    "FTL0 packet: SELECT_RESP"};                  // 17

   if (cfg.debug < 1)
      return;
   frWin.print( str[ type ] );
}
