//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0_H
#define  __FTL0_H

#ifndef  __STDIO_H
#include "stdio.h"
#endif

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __DIR_H
#include "dir.h"
#endif

#ifndef  __OBJECT_H
#include "object.h"
#endif

class XmitCallUp : public CallUp
{
public:
                         XmitCallUp( Object& obj );
         void            func() const;
};

class Ax25;
class Config;
class DirDlMgr;
class Directory;
class EventQueue;
class FTL0Pkt;
class FTL0User;
class HighTime;
class Log;
class MBuf;
class StatusList;
class Window;

class FTL0 : public Object
{
public:
          unsigned long  dirFileNumber;
          unsigned long  dlFileNumber;
          unsigned       numToUpload;
          char*          selScope;
          XmitCallUp     tCallUp;

                        FTL0( Config&     cfg,
                              Window&     frWin,
                              Window&     iWin,
                              EventQueue& pQ,
                              HighTime&   hTime,
                              StatusList& sList,
                              Directory&  dir,
                              DirDlMgr&   ddm,
                              Log&        log,
                              FTL0User*&  ftl0User );
                        ~FTL0();
          int           filesToUpload();
          void          recv( MBuf& mb );
          void          tCall();

private:
                        // FTL0 Frame Types

          enum        { DATA              =  0,
                        DATA_END          =  1,
                        LOGIN_RESP        =  2,
                        UL_CMD            =  3,
                        UL_GO_RESP        =  4,
                        UL_ERROR_RESP     =  5,
                        UL_ACK_RESP       =  6,
                        UL_NAK_RESP       =  7,
                        DL_CMD            =  8,
                        DL_ERROR_RESP     =  9,
                        DL_ABORTED_RESP   = 10,
                        DL_COMPLETED_RESP = 11,
                        DL_ACK_CMD        = 12,
                        DL_NAK_CMD        = 13,
                        DIR_SHORT_CMD     = 14,
                        DIR_LONG_CMD      = 15,
                        SELECT_CMD        = 16,
                        SELECT_RESP       = 17,
                        C_CMD             = 21,  // TNC connect command
                        D_CMD             = 22 };// TNC disconnect command

                        // FTL0 Upload Error Responses

          enum        { ER_ILL_FORMED_COMMAND      =  1,
                        ER_BAD_CONTINUE            =  2,
                        ER_SERVER_FSYS             =  3,
                        ER_NO_SUCH_FILE_NUMBER     =  4,
                        ER_SELECTION_EMPTY         =  5,
                        ER_MANDATORY_FIELD_MISSING =  6,
                        ER_NO_PFH                  =  7,
                        ER_POORLY_FORMED_SEL       =  8,
                        ER_ALREADY_LOCKED          =  9,
                        ER_NO_SUCH_DESTINATION     = 10,
                        ER_PARTIAL_FILE            = 11,
                        ER_FILE_COMPLETE           = 12,
                        ER_NO_ROOM                 = 13,
                        ER_BAD_HEADER              = 14,
                        ER_HEADER_CHECK            = 15,
                        ER_BODY_CHECK              = 16 };

                        // FTL0 File Header Fields

         enum         { UPLOAD_TIME = 0x12,
                        DESTINATION =  0x14 };

                        // Download States

          enum        { DL_UNINIT,
                        DL_CMD_OK,
                        DL_WAIT,
                        DL_DATA,
                        DL_END,
                        DL_ABORT,
                        DL_DIR_WAIT,
                        DL_SEL,
                        DL_DIR_DATA
                      };
                        // Upload States

          enum        { UL_UNINIT,
                        UL_CMD_OK,
                        UL_WAIT,
                        UL_DATA,
                        UL_END
                      };

          enum        { MAX_PAIRS = 10 };        // max pairs in fill-file request
          enum        { SHORT, LONG };

          unsigned long byteOffset;
          unsigned long bytesUploaded;
          Config&       cfg;
          Directory&    dir;
          DirDlMgr&     ddm;
          int           dirLen;
          int           dlFile;
          unsigned long dlFileSize;
          int           dlState;
          Window&       frWin;
          FTL0User*&    ftl0User;
          HighTime&     hTime;
          Window&       iWin;
          unsigned long lastSentTime;
          Log&          log;
          unsigned      maxBytesToSend;
          EventQueue&   pQ;
          unsigned long serverFileNumber;
          StatusList&   sList;
          unsigned long startTime;
          FILE*         ulFile;
          char          ulFileName[ MAXPATH + 2 ];
          int           ulState;

          void          dispPkt( FTL0Pkt& pkt );
          void          dispPktType( int type );
          void          dispErrorResponse( const int, char* );
          int           fileOK();
          void          handleDlEvent( int eventType, FTL0Pkt& pkt );
          void          handleUlEvent( int eventType, FTL0Pkt& pkt );
          FTL0Pkt&      readPkt( MBuf& frame );
          int           storeData( FTL0Pkt& pkt );
          int           transmit( int command );
          void          throughput();

          friend class  FTL0User;
};

#endif  __FTL0_H
