//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __FTL0PKT_H
#include "ftl0pkt.h"
#endif

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0User.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MISC_H
#include "misc.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

FTL0::FTL0( Config&     cfg,
            Window&     frWin,
            Window&     iWin,
            EventQueue& pQ,
            HighTime&   hTime,
            StatusList& sList,
            Directory&  dir,
            DirDlMgr&   ddm,
            Log&        log,
            FTL0User*&  ftl0User )
          :
            cfg( cfg ),
            frWin( frWin ),
            iWin( iWin ),
            pQ( pQ ),
            hTime( hTime ),
            sList( sList ),
            dir( dir ),
            ddm( ddm ),
            log( log ),
            ftl0User( ftl0User ),
            bytesUploaded( 0 ),
            dlState( DL_UNINIT ),
            dlFileNumber( 0 ),
            dirLen( LONG ),
            dirFileNumber( 0 ),
            maxBytesToSend( 0 ),
            numToUpload( 0 ),
            selScope( "   " ),
            startTime( 0 ),
            lastSentTime( 0 ),
            ulState( UL_UNINIT ),
            tCallUp( XmitCallUp( *this ) )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{}

FTL0::~FTL0()
// --------------------------------------------------------------------------
// Destructor
// --------------------------------------------------------------------------
{}

void FTL0::dispPkt( FTL0Pkt& pkt )
// -------------------------------------------------------------------------
// Display FTL0 pkt
// -------------------------------------------------------------------------
{
   if (cfg.debug > 0)
   {
      sprintf( frWin.buf, "ftl0.l = %i, ftl0.len = %i", pkt.l, pkt.len);
      frWin.print( frWin.buf );
   }
   if (cfg.showDataHex)
      frWin.printHex( pkt.c, pkt.l );         // display data in hex
   else
      if (cfg.showData)
         frWin.print( pkt.c, pkt.l );         // display data in non-hex
}

void FTL0::dispErrorResponse( const int code, char* cp )
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
{
   char *ftl0Error[] = { "",                     // msgs from PG.EXE
                         "command bug",
                         "cannot continue ",
                         "probably PACSAT file system full",
                         "numbered file does not exist",
                         "no files selected",
                         "file header missing mandatory field",
                         "file header missing",
                         "selection equation bad",
                         "file locked already",
                         "incorrect destination number",
                         "file is partial",
                         "file is complete already",
                         "PACSAT file system full",
                         "file header incorrect",
                         "file header checksum failure",
                         "file body checksum failure" };

   char *msgBuf = new char[80];
   if (code >= 1 && code <= 16)
      sprintf( msgBuf, "%s%s", cp, ftl0Error[ code ] );
   else
      sprintf( msgBuf, "%sunknown code, [%i]", cp, code );
   log.write( msgBuf );
   frWin.printColor( cfg.highlight1Fg, cfg.highlight1Bg, msgBuf );
   delete msgBuf;
}

int FTL0::filesToUpload()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   struct ffblk* fileinfo = new struct ffblk;
   char* ul_file_name = new char[ MAXPATH ];;
   if (!ul_file_name)
      frWin.printFatal( "Out of memory" );
   int  count = 0;
   sprintf( ul_file_name, "%s*.PUL", cfg.ulDir );
   if (findfirst( ul_file_name, fileinfo, 0 ) == 0)
   {
      count++;
      while (findnext( fileinfo ) == 0)
         count++;
   }
   sprintf( ul_file_name, "%s*.OUT", cfg.ulDir );
   if (findfirst( ul_file_name, fileinfo, 0 ) == 0)
   {
      count++;
      while (findnext( fileinfo ) == 0)
         count++;
   }
   if (count)
   {
      sprintf( iWin.buf, "Found %i files to upload", count );
      iWin.print( frWin.buf );
   }
   else
      iWin.print( "Found no files to upload" );
   delete fileinfo;
   delete ul_file_name;
   return count;
}

void FTL0::recv( MBuf& mb )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   FTL0Pkt* pkt = &readPkt( mb );
   if (!pkt)
      return;
   if (cfg.debug)
      dispPkt( *pkt );
   int ftl0EventType;
   switch (pkt->type)
   {
      case  0 : ftl0EventType = Event::Rcv_DATA; break;
      case  1 : ftl0EventType = Event::Rcv_DATA_END; break;
      case  2 : ftl0EventType = Event::Rcv_LOGIN_RESP; break;
      case  4 : ftl0EventType = Event::Rcv_UL_GO_RESP; break;
      case  5 : ftl0EventType = Event::Rcv_UL_ERROR_RESP; break;
      case  6 : ftl0EventType = Event::Rcv_UL_ACK_RESP; break;
      case  7 : ftl0EventType = Event::Rcv_UL_NAK_RESP; break;
      case  9 : ftl0EventType = Event::Rcv_DL_ERROR_RESP; break;
      case 10 : ftl0EventType = Event::Rcv_DL_ABORTED_RESP; break;
      case 11 : ftl0EventType = Event::Rcv_DL_COMPLETED_RESP; break;
      case 17 : ftl0EventType = Event::Rcv_SELECT_RESP; break;
      default :
         sprintf( frWin.buf, "unknown FTL0 packet type: %i", pkt->type );
         frWin.print( frWin.buf );
         delete pkt;
         return;
   }
   if (cfg.debug)
      Event::display( ftl0EventType, frWin, cfg );

   // Process the FTL0 packets

   unsigned long val;
   unsigned char flag;
   unsigned      protoVer;
   unsigned char headerPfh;
   unsigned char selectionActive;
   switch (ftl0EventType)
   {
      case Event::Rcv_LOGIN_RESP:
//       unsigned long val = 0;
//       for (int i = 0; i < 4; i++)             // reverse the bytes
//          val |= (unsigned long) ((pkt.b).c[2 + i]) << (8 * i);
         val = *((unsigned long *)(pkt->c + 2));
         flag = *(pkt->c + 6);
         protoVer        = flag & 3;
         headerPfh       = flag & 4;
         selectionActive = flag & 8;

         // Display the login message

         sprintf( frWin.buf, "Logged in at %s", ctime((time_t *) &val));
         // delete terminating carriage return
         frWin.buf[ ( int )(strchr( frWin.buf, '\n' ) - frWin.buf) ] = 0;
         frWin.printColor( cfg.highlight2Fg, cfg.highlight2Bg, frWin.buf );
         sprintf( frWin.buf, "PACSAT protocol server version %02u", protoVer );
         frWin.printColor( cfg.highlight2Fg, cfg.highlight2Bg, frWin.buf );
         if (!headerPfh)
            frWin.printColor( cfg.highlight2Fg, cfg.highlight2Bg, "Non-compliant server" );
         if (selectionActive)
            frWin.printColor( cfg.highlight2Fg, cfg.highlight2Bg, "Old selection active" );

         handleUlEvent( Event::Rcv_LOGIN_RESP, NULPKT );// initialize ul & dl
         handleDlEvent( Event::Rcv_LOGIN_RESP, NULPKT );// state machines
         break;
      case Event::Rcv_DL_ERROR_RESP:
         dispErrorResponse( pkt->c[2], "Download rejected, " );
                                                 // note: fall thru
      case Event::Rcv_DATA:
      case Event::Rcv_DATA_END:
      case Event::Rcv_DL_ABORTED_RESP:
      case Event::Rcv_DL_COMPLETED_RESP:
      case Event::Rcv_SELECT_RESP:
         handleDlEvent( ftl0EventType, *pkt );
         break;
      case Event::Rcv_UL_ERROR_RESP:
      case Event::Rcv_UL_NAK_RESP:
         dispErrorResponse( pkt->c[2], "Upload rejected, " );
                                                 // note: fall thru
      case Event::Rcv_UL_GO_RESP:
      case Event::Rcv_UL_ACK_RESP:
         handleUlEvent( ftl0EventType, *pkt );
   }
   if (pkt)
   {
      delete pkt;
      pkt = 0;
   }
   // Check the for pending commands after an FTL0 frame have been processed.

   if ((ulState == UL_CMD_OK) && (dlState == DL_CMD_OK))
      ftl0User->checkQ();
}

