//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FILEINTF_H
#include "fileintf.h"
#endif

#ifndef  __DIR_DEF_
#include <dir.h>
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

FileIntf::FileIntf( unsigned& showDataHex, const char* dir )
                  :
                    HwDevice(),
                    dir( dir ), fileOpen( 0 ),
                    iBuffer( 0 ), recvOutSize( 512 )
// -------------------------------------------------------------------------
//  Constructor
//
//  The calling functions must be able to handle the size of the
//  MBuf returned by recvOut( MBuf*& bp ) which will be recvOutSize.
// -------------------------------------------------------------------------
{
   this->showDataHex = &showDataHex;
}

FileIntf::~FileIntf()
// -------------------------------------------------------------------------
//  Destructor
// -------------------------------------------------------------------------
{
   close();
}

int FileIntf::close()
// -------------------------------------------------------------------------
//  Close the open file.
//
//  The values returned are:
//           0 - file successfully closed.
//           1 - errors on closing file.
// -------------------------------------------------------------------------
{
   fileOpen = 0;
   return fclose( inFile );
}

int FileIntf::dataReady()
// --------------------------------------------------------------------------
//  Returns the status of the input file.
//
//  The values returned are:
//           0 - End of file, no more data read.
//           1 - Not at EOF.
// --------------------------------------------------------------------------
{
   return !(feof( inFile ) && (openNext() != 0));
}

int FileIntf::flush( const char ) const
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
{
   return 1;
}

int FileIntf::open()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   // The calling functions must be able to handle a buffer if recvOutSize
   // return by the recvOut( MBuf*& bp ) function.

   return open( recvOutSize );
}

int FileIntf::open( const unsigned recvOutSize )
// --------------------------------------------------------------------------
//  Open the interface and input file.
//
//  recvOutSize:   size of the receive buffers that are returned from the
//                 recvOut( MBuf*& bp ) function.  The calling functions must
//                 be able to handle a buffer this size.
//
//  The values returned are: 0 - File successfully opened.
//                           1 - Can't open file.
// --------------------------------------------------------------------------
{
   if (fileOpen)
      return 0;

   this->recvOutSize = recvOutSize;              // set the buffer size
   char* slipFileName = new char[ MAXPATH ];
   if (!slipFileName && frWin)
      frWin->printFatal( "Out of memory" );
   sprintf( slipFileName, "%s*.slp", dir );      // build search string
   if (findfirst( slipFileName, &fileBlock, 0 )) // look for first file
   {
      frWin->print( "No input files found for simulation" );
      delete slipFileName;
      return 1;
   }

   sprintf( slipFileName, "%s%s", dir, fileBlock.ff_name );
   int code = 0;
   if ((inFile = fopen( slipFileName, "rb")) == 0)
   {
      if (frWin)
      {
         sprintf( frWin->buf, "Error opening simulation input file: %s",
                  slipFileName );
         frWin->print( frWin->buf );
      }
      code = 1;
   }
   else
      fileOpen = 1;                           // say file is open
   delete slipFileName;                       // delete allocated memory
   return code;
}

int FileIntf::openNext()
// --------------------------------------------------------------------------
//  Open the next input file.
//
//  The values returned are:
//           0 - Next file successfully opened.
//           1 - Can't open next file.
// --------------------------------------------------------------------------
{
   static int noMoreFiles = 0;
   if (!fileOpen || noMoreFiles)                 // if open() not yet called
      return 1;
   if (findnext( &fileBlock ))                   // if no next file
   {
      noMoreFiles = 1;
      return 1;
   }

   fclose( inFile );                             // close the current file
   char* slipFileName = new char[ MAXPATH ];
   if (!slipFileName)
      frWin->printFatal( "Out of memory" );
   sprintf( slipFileName, "%s%s", dir, fileBlock.ff_name );
   int code = 0;
   if ((inFile = fopen( slipFileName, "rb")) == 0)
   {
      sprintf( frWin->buf, "Error opening simulation input file: %s",
               slipFileName );
      frWin->print( frWin->buf );
      fileOpen = 0;                           // say file is closed
      code = 1;
   }
   delete slipFileName;                       // delete allocated memory
   return code;
}

void FileIntf::poll()
// --------------------------------------------------------------------------
// Trigger the receiver function.  If the pointer isn't null, pass
// the buffer to the higher level protocol interface.
// --------------------------------------------------------------------------
{
   MBuf* bp;
   recvOut( bp );
   if (bp)
      if (hiProto)
         hiProto->recvIn( *bp );
      else
         delete bp;
}

int FileIntf::recvOut( MBuf*& bp )
// --------------------------------------------------------------------------
//  Construct and fill an MBuf from the file.
//
//  The values returned are:
//           0 - Character buffer successfully returned.
//           1 - Can't allocate receive buffer
//          10 - At end of file; there are no characters to read.
// --------------------------------------------------------------------------
{
   bp = 0;                                       // zero pointer to start
   if (feof( inFile ) && (openNext() != 0))
      return 10;

   bp = new MBuf( recvOutSize );
   if (!bp)
      return 1;

   return recvOut( bp->data, bp->size, bp->cnt );
}

int FileIntf::recvOut( char* bp, const unsigned len, unsigned &cnt )
// --------------------------------------------------------------------------
//  Fill an array from the file.
//
//  The values returned are:
//           0 - Character buffer successfully returned.
//           1 - Invalid buffer pointer.
//          10 - At end of file; there are no characters to read.
// --------------------------------------------------------------------------
{
   cnt = 0;
   if (feof( inFile ) && (openNext() != 0))
      return 10;
   if (!bp)
      return 1;
	if ((cnt = fread( bp, 1, len, inFile )) == 0)
      return 10;
// recvBytesOut += bp->cnt;                      // not really needed here
// recvFramesOut++;
   if (*showDataHex & RECV_OUT)
      frWin->printHex( bp, cnt );
   return 0;
}

int FileIntf::recvOut( char& c )
// -------------------------------------------------------------------------
//  Returns a character from the input file.
//
//  The values returned are:
//           0 - Character successfully returned.
//          10 - At end of file; there are no characters to read.
// -------------------------------------------------------------------------
{
   if (feof( inFile ) && (openNext() != 0))
      return 10;
   if (!fread( (char *)c, 1, 1, inFile ))
      return 10;
// recvBytesOut++;                               // not really needed here
// recvFramesOut++;
   if (*showDataHex & RECV_OUT)
      frWin->printHex( &c, 1 );
   return 0;
}

int FileIntf::send( MBuf& buf )
// --------------------------------------------------------------------------
//  Dummy function.  Deletes the MBuf.
//  The values returned are:
//           0 - Normal return;
// --------------------------------------------------------------------------
{
// sendBytesOut += buf.cnt;                      // not really needed here
// sendFramesOut++;
   if (*showDataHex & SEND_OUT)
      frWin->printHex( buf.data, buf.cnt );
   delete &buf;
   return 0;
}


int FileIntf::send( const char* data, const unsigned cnt )
// --------------------------------------------------------------------------
//  Dummy send for debugging.   Return 0, bytes successfully written.
// --------------------------------------------------------------------------
{
   if (*showDataHex & SEND_OUT)
      frWin->printHex( data, cnt );
   return 0;
}

int FileIntf::set( enum devVal, const unsigned long )
// --------------------------------------------------------------------------
//  Dummy function
// --------------------------------------------------------------------------
{
   return 1;
}

