//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FILEBCST_H
#define  __FILEBCST_H

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class FileFrInfo                                  // file frame information
{
public:
          unsigned char  flag;                   // flag byte
          unsigned long  file_number;            // server file number
          unsigned char  file_type;
          unsigned long  offset;                 // file offset
          char*          hdr;                    // ptr to header
          unsigned       flen;                   // length of bcst frame
          char*          data;                   // ptr to data
          unsigned       dlen;                   // length of data portion
   static FileFrInfo*    ZERO;
};

#define NOFRINFO *(FileFrInfo::ZERO)

class ActList;
class Ax25;
class Config;
class MBuf;
class Window;
class StatusList;
class StatusLine;

class FileBcstMgr : public L3Protocol
{
public:
          enum         { BEGIN_BCST_CMD = 18,    // file broadcast frames
                         STOP_BCST_CMD = 19,
                         FILL_FILE_CMD = 20 };

                         unsigned long bcstFileNumber;

                         FileBcstMgr( Config&     cfg,
                                      Window&     frWin,
                                      Window&     iWin,
                                      StatusLine& sLine,
                                      ActList&    actList,
                                      StatusList& sList,
                                      char&       bcstAddr,
                                      char&       myAddr,
                                      Protocol&    logProto );
                         ~FileBcstMgr();
          int            bcstSend( int command );
          void           link( Ax25*& axpr ) { axp = axpr; }
          void           recvIn( Level3Iface& l3If );
          void           saveFrame( MBuf* bp );
          int            send( int command );

private:
          enum         { MAX_PAIRS = 10 };

          ActList&       actList;
          Ax25*&         axp;
          char&          bcstAddr;
          unsigned       bcstPacLen;
          Config&        cfg;
          unsigned       exitOnSatCallError;
          Window&        frWin;
          unsigned*      grabAll;
          unsigned       highlightBg;
          unsigned       highlightFg;
          char*          holFileDir;
          Window&        iWin;
          Protocol&      logProto;
          unsigned       logFileFrames;
          unsigned*      loggingStatus;
          unsigned*      logInFrames;
          unsigned       maxPfhSize;
          unsigned*      monitor;
          char&          myAddr;
          char*          mycall;
          unsigned       showGrabs;
          unsigned       simulate;
          StatusLine&    sLine;
          StatusList&    sList;
          unsigned*      trace;

          int            decodeHdr( FileFrInfo& fr );
};

#endif __FILEBCST_H
