//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FILEBCST_H
#include "filebcst.h"
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __ACTFILE_H
#include "actfile.h"
#endif

#ifndef  __ACTLIST_H
#include "actlist.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __DIRBCST_H
#include "dirbcst.h"         // get_pfh(), fstatus()
#endif

#ifndef  __HOLFILE_H
#include "holfile.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __MISC_H
#include "misc.h"
#endif

#ifndef  __SATLINK_H
#include "satlink.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

FileBcstMgr::FileBcstMgr( Config&     cfg,
                          Window&     frWin,
                          Window&     iWin,
                          StatusLine& sLine,
                          ActList&    actList,
                          StatusList& sList,
                          char&       bcstAddr,
                          char&       myAddr,
                          Protocol&   logProto )
                        :
                          L3Protocol(),
                          cfg( cfg ),
                          frWin( frWin ),
                          iWin( iWin ),
                          sLine( sLine ),
                          actList( actList ),
                          sList( sList ),
                          bcstAddr( bcstAddr ),
                          myAddr( myAddr ),
                          logProto( logProto ),
                          axp( Ax25::ZERO ),
                          bcstFileNumber( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   bcstPacLen = cfg.bcstPaclen;
   debug = &cfg.debug;
   exitOnSatCallError = cfg.exitOnSatCallError;
   grabAll = &cfg.grabAll;
   highlightBg = cfg.highlight1Bg;
   highlightFg = cfg.highlight1Fg;
   holFileDir = cfg.dlDir;
   loggingStatus = &cfg.loggingStatus;
   logFileFrames = cfg.logFileFrames;
   logInFrames = &cfg.logInFrames;
   maxPfhSize = cfg.maxPfhSize;
   monitor = &cfg.monitor;
   mycall = cfg.mycall;
   showData = &cfg.showData;
   showDataHex = &cfg.showDataHex;
   showGrabs = cfg.showGrabs;
   simulate = cfg.simulate;
   trace = &cfg.trace;
}

FileBcstMgr::~FileBcstMgr()
// --------------------------------------------------------------------------
//  Destructor
// --------------------------------------------------------------------------
{}

void FileBcstMgr::saveFrame( MBuf* bp )
// --------------------------------------------------------------------------
// Save the data from a broadcast file
// --------------------------------------------------------------------------
{
   enum                  pids {DIR_BCST, FILE_BCST};
   FileFrInfo            fr;                     // decoded frame info
   static unsigned long  last_number = 0;

   // AX.25 header should have striped off at this point.  The remainder
   // should be a file broadcast frame.

   recvBytesIn += bp->cnt;                       // inc total bytes received
   if (calcrc(bp->data, bp->cnt) != 0)           // if CRC error
   {
      recvErrCnt++;                              // increment error count
      if (eCallUp)                               // if we need to report the
         eCallUp->func();
      if (showGrabs)
         iWin.print( "Bad file frame CRC." );
      return;
   }
   bp->cnt -= 2;                                 // exclude the CRC
   fr.hdr = bp->data;                            // get the starting point;
   fr.flen = bp->cnt;                            // frame length to start

   if (decodeHdr( fr ) != 0)                     // if bad frame/frame hdr
   {
      recvErrCnt++;                              // increment error count
      if (eCallUp)                               // if we need to report the
         eCallUp->func();
      if (showGrabs)
         iWin.print( "Bad file frame header." );
      return;
   }
   if (*debug > 1)
   {
      sprintf( frWin.buf, "file %8lx, offset %9lu, type %3i, E-bit %c, L-bit %c, "
                          "data-len %u",
                          fr.file_number, fr.offset, int( fr.file_type ),
                          fr.flag & 0x20 ? 'T' : 'F', fr.flag & 1 ? 'T' : 'F',
                          fr.dlen);
      frWin.print( frWin.buf );
   }

   sLine.fileTotal( recvBytesIn );               // display the total
   if (showGrabs && fr.file_number != last_number) // when the file changes
   {
      sprintf( iWin.buf, "Message %-lx heard.", fr.file_number );
      iWin.print( iWin.buf );                    // display in info window
      last_number = fr.file_number;              // save the file number
   }

   // Determine if we want to save the data by a) checking the current
   // status of the file on the status list and b) checking the hole list
   // to determine if the data is needed.  The latter also tells us if the
   // file will be complete once the data is writen to the file.  The
   // frame_save function needs to know this to close the file and display
   // a message on the screen.

   // These tests can't be done at the next higher function level because
   // the broadcast frame header must be decoded to get the file_id.

   int status;
   int blockedFlag;
   sList.status( fr.file_number, status, blockedFlag );
   if (status >= 0)                              // if file on sList
   {
      switch (status)
      {
         case sList.DOWNLOADED :
            if (showGrabs)
               iWin.print( "Ignoring already downloaded file." );
            return;
         case sList.NEVER :
            if (showGrabs)
               iWin.print( "Ignoring N file." );
            return;
         case sList.ERROR :
            if (showGrabs)
            {
               sprintf( iWin.buf, "File %lx in error", fr.file_number);
               iWin.print( iWin.buf );
            }
            return;
         case sList.PRIORITY :
         case sList.AUTOMATIC :
            break;
         default :                               // normal GRAB status
            if (blockedFlag > 0)                 // if file is blocked
            {
               if (showGrabs)
                  iWin.print( "Ignoring blocked file type." );
               return;
            }
            if (*grabAll)
               break;
            else
               return;
      }
   }
   else
   {
      // The file_type is not checked first so that PRIORITY or AUTOMATIC
      // can override the supression of files that are blocked.

      if (cfg.blockedFType( fr.file_type ))
      {
         if (showGrabs)
            iWin.print( "Ignoring blocked file type." );
         return;                                 // discard the data
      }
      if (*grabAll)
         sList.set( fr.file_number, sList.GRAB );// put on sList
      else
         return;                                 // else discard data
   }
   actList.save( fr );
}

int FileBcstMgr::decodeHdr( FileFrInfo& fr )
//--------------------------------------------------------------------------
// Decode the header fields in the broadcast frame
//--------------------------------------------------------------------------
{
   char* cp = fr.hdr;                            // point to header start
   fr.flag = *cp++;

   if (fr.flen < 9)                              // if too short to be valid
      return 1;
   if ((fr.flag & 1) && fr.flen < 11)            // if length field present
      return 1;

   fr.file_number = 0;
   int i;
   for (i = 0; i < 4; i++)                       // reverse the bytes
      fr.file_number |= ((unsigned long) *cp++) << (8 * i);
   fr.file_type = *cp++;
   fr.offset = 0;
   for (i = 0; i < 3; i++)                       // reverse the bytes
      fr.offset |= ((unsigned long) *cp++) << (8 * i);

   //@@@@@@@@@@@@@@@@
   // The following "if" statement is a fix for the occasional file that has
   // the high order byte in the offset set to 0xff.  This fix will cause
   // problems someday no doubt.

   if (fr.offset > 0xff0000L)
      fr.offset -= 0xff0000L;

   fr.dlen = 0;
   if (fr.flag & 1)                              // if length field present
   {
      for (i = 0; i < 2; i++)                    // reverse the bytes
         fr.dlen |= unsigned( *cp++ ) << (8 * i);
      fr.data = fr.hdr + 11;                     // set data pointer
   }
   else                                          // length field not present
   {
      fr.dlen = fr.flen - 9;                     // use frame size - 9;
      fr.data = fr.hdr + 9;                      // set data pointer
   }
   return 0;
}

void FileBcstMgr::recvIn( Level3Iface& l3If )
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
{
   MBuf* bp = l3If.bp;                          // data buffer pointer
   if (!Ax25::addrEq( l3If.src, &bcstAddr ))
   {
      char call[ 11 ];
      Ax25::pAx25( call, l3If.src );
      sprintf( iWin.buf, "ERROR - Broadcasts from %s heard but ignored.",
                         call );
      iWin.print( iWin.buf );
      delete bp;
      delete &l3If;
      if (exitOnSatCallError)
      {
         iWin.print( "Program exit requested." );
         satLink->exitProgram( SatLink::EXITONSATERROR );
      }
      return;
   }
   if (memcmp( bp->data, "NO -2", 5 ) == 0)      // if permanent problem
      if (memcmp( bp->data + 6, mycall, strlen( mycall ) ) == 0) // if it's to us
                                                 // set file status as ERROR
         sList.set( bcstFileNumber, StatusList::ERROR );
                                                 // else ignore

   // If the flag is "OK" and directed to us, we don't inhibit the retry
   // at this point.  Retries are triggered after examining the
   // broadcast queue frame and seeing we aren't in the queue.

   if (memcmp( bp->data, "NO", 2 ) == 0 || memcmp( bp->data, "OK", 2 ) == 0)
   {
      if (!*trace && *monitor)
      {
         bp->data[ bp->cnt ] = 0;                // make it a string;
         frWin.print( bp->data );
         char* callPtr = strstr( bp->data, mycall );
         if (callPtr)
         {
            unsigned offset = (unsigned)(callPtr - bp->data);
            frWin.highlight( strlen( bp->data ), offset, strlen( mycall ), highlightFg, highlightBg );
         }
      }
   }
   else
   {
      if (!*trace && *monitor)
         if (*showDataHex)
            frWin.printHex( bp->data, bp->cnt ); // display data in hex
         else
            if (*showData)
               frWin.print( bp->data, bp->cnt ); // display data in non-hex
      saveFrame( bp );                          // this does not "free" bp
      if (!simulate && *loggingStatus && !*logInFrames && logFileFrames)
         logProto.logRecvIn();
   }
   delete bp;
   delete &l3If;
}

int FileBcstMgr::send( int command )
// --------------------------------------------------------------------------
//  Send a given broadcast protocol command
// --------------------------------------------------------------------------
{
   typedef struct file_req_header
   {
      char          flags;
      unsigned long file_id;
      int           block_size;
   } file_req_header;

   file_req_header* frh;
   int              numpairs;
   MBuf*            bp;
   char*            cp;
   int              pid;

   switch (command)
   {
      case BEGIN_BCST_CMD:
         bp = new MBuf( sizeof( file_req_header ) + 17 );
         frh = (file_req_header *)bp->data;      // point to the data
         frh->flags = 0x10;                      // CC bits = 00
         frh->file_id = bcstFileNumber;
         frh->block_size = bcstPacLen;
         bp->cnt = sizeof(file_req_header);
         pid = 0xbb;                             // pid: bcst file
         break;

      case STOP_BCST_CMD:
         bp = new MBuf( sizeof( file_req_header ) + 17 );
         frh = (file_req_header *)bp->data;      // point to the data
         frh->flags = 0x11;                      // CC bits = 01
         frh->file_id = bcstFileNumber;
         frh->block_size = bcstPacLen;
         bp->cnt = sizeof(file_req_header);
         pid = 0xbb;                             // pid: bcst file
         break;

      case FILL_FILE_CMD:
         bp = new MBuf( sizeof( file_req_header ) +
                         MAX_PAIRS * sizeof( FPair ) + 17 );
         frh = (file_req_header *)bp->data;      // point to the data
         frh->flags = 0x12;                      // CC bits = 10
         frh->file_id = bcstFileNumber;
         frh->block_size = bcstPacLen;
         cp = bp->data + sizeof(file_req_header);// set working pointer

         // We need the entire file if the holecount is zero (i.e., the file
         // is not on the hole list and there is no .HOL file) or there is
         // one hole and the hole size is the maximum size that we can
         // request.  In these cases, change the request to a BEGIN_BCST_CMD
         // by changing the flag field to 0x00;

         ActFile* aFile;
         if ((aFile = actList.onList( frh->file_id, 0)) != 0)
            numpairs = aFile->holFile->holeStrFromMem( (FPair*)cp );
         else
            numpairs = HolFile::holeStrFromFile( holFileDir, bcstFileNumber, (FPair*) cp );
         if (numpairs == 0 ||
            (numpairs == 1 && ((FPair*)cp)->len == 0xffff))
         {
            frh->flags = 0x10;                   // CC bits = 00
            bp->cnt = sizeof(file_req_header);
         }
         else
            bp->cnt = sizeof(file_req_header) + numpairs * sizeof(FPair);
         pid = 0xbb;                             // pid: bcst file
         break;
   }
   if (*debug > 1)
   {
      frWin.print( "broadcast command:" );
      frWin.printHex( bp->data, bp->cnt );
   }
   if (axp )
      axp->output( &bcstAddr, &myAddr, pid, *bp );// send AX.25 UI frame
   return 0;
}
