//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __DIRFILE_H
#define  __DIRFILE_H

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

class Window;

class DirFileMgr
{
public:
          FILE*         file;                    // PB__xxxx.PFH file handle

                        DirFileMgr( char*         workDir,
                                    unsigned long maxDirFileSize,
                                    unsigned      nDupeSearch,
                                    Window&       frWin );
                        ~DirFileMgr();
          void          ckDirSize( unsigned cnt );
          void          checkFiles();
          unsigned      onDirList( const unsigned long fileNumber );
          void          saveData( const char* bp, const unsigned len );

private:
   struct ffblk         dirblk;                  // dir file control block
          char          fileName[ MAXPATH ];     // directory file name
          Window&       frWin;
          unsigned long maxDirFileSize;
          unsigned      nDupeSearch;
          unsigned      seqNum;                  // xxxx in PB__xxxx.PFH
          char*         workDir;

};

#endif   __DIRFILE_H