//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __DIRECTRY_H
#define  __DIRECTRY_H

// Forward references

class Config;
class CmdLine;
class Directory;
class DirFileMgr;
class DirIterator;
class Equation;
class Help;
class PFileHeader;
class PFileHeader;
class SemanticsAnalyzer;
class StatusList;
class SyntaxAnalyzer;
class UserMgr;
class Window;

class Directory
{
public:
                      Directory(       SyntaxAnalyzer*    parser,
                                       SemanticsAnalyzer* sem,
                                       CmdLine&           cLine,
                                 const Config&            cfg,
                                 const StatusList&        sList,
                                       DirFileMgr&        dfm,
                                       Window&            iWin,
                                       int&               screenCount,
                                       Help&              help );
                      ~Directory();
      void            addPfh( PFileHeader& pfh );
      unsigned        addPfh( const PFileHeader& pfh,
                              const int          direction,
                              const unsigned     makeSpace );
      unsigned        displayContents( const unsigned keyVal );
//      unsigned long   fileSize( const unsigned long fileNumber ) const;
//      PFileHeader*    getPfh( const unsigned long fileNumber );
      PFileHeader*    getPfh( const unsigned long fileNumber );
      void            init( const char* pathName, const char* myCall );
      void            setStatus( const unsigned long fileNumber,
                                 const char          status );

private:
      enum           { DIRLIST, EXPANDPFH, HELP, FIND, MAIN, ARCHIVE, OPENED,
                       CLOSED, OPEN_ARCHIVE, CLOSE_ARCHIVE, DISPLAY_MAIN,
                       DISPLAY_ARCHIVE };

      unsigned       activeArray;
      PFileHeader**  mainArray;
      unsigned long  bytesUsed;
const Config&        cfg;
      CmdLine&       cLine;
      unsigned       currentDisplayKey;
      int            currentLineIndex;
      DirFileMgr&    dfm;
static unsigned      DIR_BUFSIZE;
      unsigned       dirInitialized;
      unsigned       displayCount;
      Window*        dWin;
      Equation*      eqnF1;
      Equation*      eqnF2;
      Equation*      eqnF3;
      Equation*      eqnF4;
      Equation*      eqnF5;
      Equation*      eqnF6;
      Equation*      eqnF7;
      Equation*      eqnF8;
      Equation*      eqnF9;
      Equation*      eqnF10;
      Equation*      eqnF11;
      Equation*      eqnF12;
      Equation*      eqnCurrent;
      unsigned       firstSeq;
      unsigned       itemsInContainer;
      Window&        iWin;
      int            lastElementIndex;
      int            lastRec;
      int            lastSeq;
      char           myCall[ 10 ];
      unsigned       mainItemsInContainer;
      unsigned long  maxDirLoad;
      unsigned long  maxDirArchLoad;
      unsigned       panFlag;
      SyntaxAnalyzer* parser;
      char           pathName[ 80 ];
      int            pfhIndex[ 20 ];
      int&           screenCount;
      SemanticsAnalyzer* sem;
const StatusList&    sList;
      unsigned       state;
      PFileHeader**  theArray;
      int            typesToDisplay;
      unsigned       upperbound;

      void           activateDisplay();
      void           add( PFileHeader& );
      void           archCommand();
      void           entriesToDisplay( const unsigned keyVal );
      void           firstPage();
      Help&          help;
      DirIterator&   initIterator() const;
      void           lastPage();
      void           mainCommand();
      void           nextPage();
      void           nextRec();
      void           panLeft();
      void           panRight();
      void           previousRec();
      void           previousPage();
      unsigned       readDir( const int direction, const unsigned makeSpace );
      unsigned       remove( const unsigned spaceToFree,
                             const int      whichToRemove );
      void           restoreScreen();
      void           saveScreen();
      unsigned       setArray( const unsigned action );
      void           setStatus( const int status ) const;
      void           viewPage();
};

#endif  __DIRECTRY_H
