//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef __DIRECTRY_H
#include "directry.h"
#endif

#ifndef  __ALLOC_H
#include <alloc.h>
#endif

#ifndef  __ASSERT_H
#include <assert.h>
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __DIRBCST_H
#include "dirbcst.h"
#endif

#ifndef  __DIRFILE_H
#include "dirfile.h"
#endif

#ifndef  __GETUE_H
#include "getue.h"
#endif

#ifndef  __HELP_H
#include "help.h"
#endif

#ifndef  __LEXICAL_H
#include "lexical.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  _PFHEADER_H
#include "pfheader.h"
#endif

#ifndef  __SEMANTIC_H
#include "semantic.h"
#endif

#ifndef  __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __SYNTAX_H
#include "syntax.h"
#endif

#ifndef  __WIN_H
#include "win.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

unsigned Directory::DIR_BUFSIZE = 2048;

Directory::Directory(       SyntaxAnalyzer*    parser,
                            SemanticsAnalyzer* sem,
                            CmdLine&           cLine,
                      const Config&            cfg,
                      const StatusList&        sList,
                            DirFileMgr&        dfm,
                            Window&            iWin,
                            int&               screenCount,
                            Help&              help )
                      :
                      parser( parser ),
                      sem( sem ),
                      cLine( cLine ),
                      cfg( cfg ),
                      sList( sList ),
                      dfm( dfm ),
                      iWin( iWin ),
                      screenCount( screenCount ),
                      help( help ),
                      activeArray( MAIN ),
                      currentDisplayKey( 187 ),
                      currentLineIndex( 4 ),
                      dirInitialized( 0 ),
                      displayCount( 0 ),
                      itemsInContainer( 0 ),
                      lastElementIndex( -1 ),
                      lastSeq( -1 ),
                      mainItemsInContainer( 0 ),
                      state( CLOSED )
// --------------------------------------------------------------------
//  Constructor for a Directory.
// --------------------------------------------------------------------
{
   eqnF1 = 0;
   eqnF2 = 0;
   eqnF3 = 0;
   eqnF4 = 0;
   eqnF5 = 0;
   eqnF6 = 0;
   eqnF7 = 0;
   eqnF8 = 0;
   eqnF9 = 0;
   eqnF10 = 0;
   eqnF11 = 0;
   eqnF12 = 0;
   eqnCurrent = 0;
   maxDirLoad = cfg.maxDirLoad;
   maxDirArchLoad = cfg.maxDirArchLoad;
   upperbound = unsigned( maxDirLoad / 150 );
   theArray = new PFileHeader* [ upperbound + 1 ];
   if (!theArray)
      iWin.printFatal( "Dir error 1: out of memory" );
   for (unsigned i = 0; i < upperbound + 1; i++)
      theArray[ i ] = PFileHeader::ZERO;
   bytesUsed = (upperbound + 1) * sizeof( PFileHeader* );

   // Get the equation id for the equation name to be used as default

   parser->lex.initLexicalyzer( cfg.defaultSel );
   int defaultId = parser->lex.getSymbol();

   for (i = 0; i < parser->eqnCount; i++)
   {
      Equation* eqn = parser->eqnList[ i ];
      switch (eqn->id)
      {
         case LexicalAnalyzer::F1 :
            eqnF1 = eqn;
            if (!eqnCurrent)
               eqnCurrent = eqnF1;
            break;
         case LexicalAnalyzer::F2 :
            eqnF2 = eqn;
            break;
         case LexicalAnalyzer::F3 :
            eqnF3 = eqn;
            break;
         case LexicalAnalyzer::F4 :
            eqnF4 = eqn;
            break;
         case LexicalAnalyzer::F5 :
            eqnF5 = eqn;
            break;
         case LexicalAnalyzer::F6 :
            eqnF6 = eqn;
            break;
         case LexicalAnalyzer::F7 :
            eqnF7 = eqn;
            break;
         case LexicalAnalyzer::F8 :
            eqnF8 = eqn;
            break;
         case LexicalAnalyzer::F9 :
            eqnF9 = eqn;
            break;
         case LexicalAnalyzer::F10 :
            eqnF10 = eqn;
            break;
         case LexicalAnalyzer::F11 :
            eqnF11 = eqn;
            break;
         case LexicalAnalyzer::F12 :
            eqnF12 = eqn;
            break;
      }
      if (defaultId == eqn->id)
         eqnCurrent = eqn;
   }
   if (!eqnCurrent)
      eqnCurrent = eqnF1;
   pfhIndex[ 0 ] = 0;
}

Directory::~Directory()
// --------------------------------------------------------------------
//  Destructor for a Directory.
// --------------------------------------------------------------------
{
   setArray( DISPLAY_MAIN );
   for (int i = 0; i <= lastElementIndex; i++)
         delete theArray[ i ];
   delete theArray;
   setArray( CLOSE_ARCHIVE );
}

void Directory::add( PFileHeader& toAdd )
// ---------------------------------------------------------------------
//  Add PFileHeader to the directory.
// ---------------------------------------------------------------------
{
   if ( lastElementIndex == upperbound )
      iWin.printFatal( "Dir error 6: directory overrun" );

   int insertionPoint = 0;
   while (insertionPoint <= lastElementIndex &&
          *theArray[ insertionPoint ] > toAdd)
      insertionPoint++;

   if (*theArray[ insertionPoint ] == toAdd)     // don't add dupes; display
   {                                             // the most recent time
      if ((*theArray[ insertionPoint ]).upload_time < toAdd.upload_time)
      {
         bytesUsed -= theArray[ insertionPoint ]->pFileHeaderSize;
         delete theArray[ insertionPoint ];
         theArray[ insertionPoint ] = &toAdd;
         bytesUsed += theArray[ insertionPoint ]->pFileHeaderSize;
      }
      else
         delete &toAdd;
      return;
   }

   memmove( &theArray[ insertionPoint+1 ], &theArray[ insertionPoint ],
            sizeof( PFileHeader* ) * (lastElementIndex - insertionPoint + 1) );
   theArray[ insertionPoint ] = &toAdd;
   bytesUsed += theArray[ insertionPoint ]->pFileHeaderSize;
   itemsInContainer++;
   lastElementIndex++;
}

void Directory::addPfh( PFileHeader& pfh )
// ---------------------------------------------------------------------
//  If the active array is not main, then switch to it.  New entries are
//  to be added only to the main array.
//
//  Refresh the directory screen if main is active.  If archive is active,
//  it shouldn't change.
//
//  Note that if directory viewing was exited with the archivew active,
//  this function will switch and leave the main active.  Main will be
//  active when the directory is next viewed.
// ---------------------------------------------------------------------
{
   unsigned archiveWasActive = 0;                // remember what's active
   if (activeArray == ARCHIVE )
   {
      archiveWasActive = 1;
      setArray( DISPLAY_MAIN );                  // set activeARRAY == MAIN
   }
   addPfh( pfh, 1, 1 );
   switch (state)
   {
      case DIRLIST:
         if (archiveWasActive)
            setArray( DISPLAY_ARCHIVE );         // switch back to archive
         else
         {
            lastRec = pfhIndex[ 0 ] - 1;         // end of previous page
            viewPage();                          // refresh page
         }
         break;
      case EXPANDPFH:
      case HELP:
      case FIND:
         if (archiveWasActive)
            setArray( DISPLAY_ARCHIVE );         // switch back to archive
         break;
      case CLOSED:
         break;
   }
}

unsigned Directory::addPfh( const PFileHeader& pfh,
                            const int          direction,
                            const unsigned     makeSpace )
// ---------------------------------------------------------------------
// Add a pfh to the viewable directory.
// Return: 0 - pfh added
//         1 - pfh not added, no space
// ---------------------------------------------------------------------
{
  if (!maxDirLoad)                               // in case it's zero
     return 1;
   PFileHeader* newRec = new PFileHeader( pfh );
   if (!newRec)
      iWin.printFatal( "Dir error 5: out of memory" );
   newRec->displayThis = sem->resolve( eqnCurrent, newRec );

   // Restrict the viewable directory to the specified number og bytes.  If
   // out of space and the makeSpace flag is raised, then delete the lowest
   // or highest based, on the direction flag, until there is sufficient
   // space.

   if (bytesUsed + newRec->pFileHeaderSize > maxDirLoad)// if out of space and
      if (!makeSpace ||                                 // won't make it
         remove( newRec->pFileHeaderSize, direction ) != 0)
      {                                                 // or can't make it
         delete newRec;
         return 1;
      }
   int status = sList.status( newRec->file_number, newRec->file_type );
   if (status >= 0)
      newRec->status = char( status );
   add( *newRec );
   dfm.onDirList( newRec->file_number );        // add to recent dir list
   return 0;
}

void Directory::activateDisplay()
// -------------------------------------------------------------------------
// Initialize the screen for viewing
// -------------------------------------------------------------------------
{
   clrscr();                                     // clean up screen
   mainCommand();                                // set command line

   ::window( 1, 2, 80, 3 );
   textcolor( cfg.directoryFg );                 // set colors
   textbackground( cfg.directoryBg );
   clrscr();
   gotoxy( 1, 1 );
   cputs( "Message \xb3S\xb3           Subject            \xb3  To  \xb3 From \xb3 Posted at \xb3 Size" );
   gotoxy( 1, 2 );
   cputs( "" );

   ::window( 1, 24, 80, 24 );
   textcolor( cfg.msgLineFg );              // set colors
   textbackground( cfg.msgLineBg );
   clrscr();

   ::window( 1, 4, 80, 23 );
   textcolor( cfg.directoryFg );            // set colors
   textbackground( cfg.directoryBg );
   clrscr();

   if (eqnCurrent)
   {
      writeat( 68, 1, cfg.cmdLineBg, LIGHTGRAY, "             " );
      char ch = eqnCurrent->keyTitle[ 13 ];      // limit to 13 chars
      eqnCurrent->keyTitle[ 13 ] = 0;
      writeatnc( 68,  1, eqnCurrent->keyTitle );
      eqnCurrent->keyTitle[ 13 ] = ch;
      writeatnc(  2, 24, eqnCurrent->keyTitle );
   }

   _setcursortype( _NOCURSOR );
   panFlag = 0;
}

void Directory::archCommand()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   writeat( 1, 1, cfg.cmdLineFg, cfg.cmdLineBg,
      "ARCHVIEW.  D return to main.  - for older  + for newer    Select = " );
}

void Directory::entriesToDisplay( const unsigned keyVal )
// ---------------------------------------------------------------------
//  Iterate through each record in the directory to set its display
//  flag if it is a qualifying entry.
// ---------------------------------------------------------------------
{
   switch (keyVal)
   {
      case 187:                                  // F1
         eqnCurrent = eqnF1;
         break;
      case 188:                                  // F2
         eqnCurrent = eqnF2;
         break;
      case 189:                                  // F3
         eqnCurrent = eqnF3;
         break;
      case 190:                                  // F4
         eqnCurrent = eqnF4;
         break;
      case 191:                                  // F5
         eqnCurrent = eqnF5;
         break;
      case 192:                                  // F6
         eqnCurrent = eqnF6;
         break;
      case 193:                                  // F7
         eqnCurrent = eqnF7;
         break;
      case 194:                                  // F8
         eqnCurrent = eqnF8;
         break;
      case 195:                                  // F9
         eqnCurrent = eqnF9;
         break;
      case 196:                                  // F10
         eqnCurrent = eqnF10;
         break;
      case 261:                                  // F11
         eqnCurrent = eqnF11;
         break;
      case 262:                                  // F12
         eqnCurrent = eqnF12;
   }

   if (eqnCurrent)
   {
      writeat( 2, 24, cfg.msgLineFg, cfg.msgLineBg,
                        "-<searching>-                             " );
      int i;
      for (i = 0; i < itemsInContainer; i++)
         theArray[ i ]->displayThis = sem->resolve( eqnCurrent, theArray[ i ] );

      writeat( 68, 1, cfg.cmdLineBg, LIGHTGRAY, "             " );
      char ch = eqnCurrent->keyTitle[ 13 ];      // limit to 13 chars
      eqnCurrent->keyTitle[ 13 ] = 0;
      writeatnc( 68, 1, eqnCurrent->keyTitle );
      eqnCurrent->keyTitle[ 13 ] = ch;
      writeatnc( 1, 24, "                                          " );
      writeatnc( 2, 24, eqnCurrent->keyTitle );
   }
}

unsigned Directory::displayContents( const unsigned keyVal )
// ---------------------------------------------------------------------
//  Display the directory on the screen.
//
// Return values
//      0 - continue using directory
//      1 - can't initialize directory or directory use is terminated
// ---------------------------------------------------------------------
{
   static unsigned long findFileNumber = 0;
          unsigned      rtnCode ;

   if (!dirInitialized)
      return 1;

   switch (state)
   {
      case CLOSED:
         if (keyVal != 0)
            return 1;
         dWin = new Window( 1, 1, 80, 23, cfg.directoryBg, cfg.directoryFg );
//         window( 0 );
         activateDisplay();
         firstPage();
         if (activeArray == ARCHIVE)
            archCommand();
         state = DIRLIST;
         break;

      case DIRLIST:
         switch (keyVal)
         {
            case  13:
            {                                  // CR
               PFileHeader& pfhRecord = *theArray[ pfhIndex[ currentLineIndex - 4 ] ];
               saveScreen();
               pfhRecord.displayOnScreen();      // display expanded header
               state = EXPANDPFH;
               break;
            }
            case 'a':
            case 'A':
               setStatus( sList.AUTOMATIC );
               nextRec();
               break;
            case 'f':
            case 'F':
               cLine.msg( "Find", findFileNumber, "\x0" );
               state = FIND;
               break;
            case 'g':
            case 'G':
               setStatus( sList.GRAB );
               nextRec();
               break;
            case 'd':
            case 'D':
               if (activeArray == MAIN)
                  break;
               mainCommand();
               setArray( DISPLAY_MAIN );
               entriesToDisplay( currentDisplayKey );
               firstPage();
               break;
            case 'h' :
            case 'H' :
               saveScreen();
               if (help.processKey( "*DIR", 0 ))
                  state = HELP;
               else
                  restoreScreen();
               break;
            case 'm':
            case 'M':
            case  27:                                  // Esc
//             window( 1 );                            // restore the display
               delete dWin;
               state = CLOSED;
               return 1;                               // terminate directory use
            case 'n':
            case 'N':
               setStatus( sList.NEVER );
               nextRec();
               break;
            case 'p':
            case 'P':
               setStatus( sList.PRIORITY );
               nextRec();
               break;
            case 'r':
            case 'R':
               if (activeArray == ARCHIVE)
                  break;
               if( setArray( DISPLAY_ARCHIVE ) == 0)
               {
                  rtnCode = 0;
                  if (!itemsInContainer)
                     rtnCode = readDir( 2, 0 );        // current pfh file
                  entriesToDisplay( currentDisplayKey );
                  firstPage();
                  archCommand();
                  if (rtnCode == 1)
                     writeatnc( 1, 24, "Partial archive; increase maxDirArchLoad" );
                  if (rtnCode == 2)
                     writeatnc( 1, 24, "Archive file not loaded" );
               }
               break;
            case 260:                                  // ctrl-page-up
               firstPage();
               break;
            case 187:                                  // F1
            case 188:                                  // F2
            case 189:                                  // F3
            case 190:                                  // F4
            case 191:                                  // F5
            case 192:                                  // F6
            case 193:                                  // F7
            case 194:                                  // F8
            case 195:                                  // F9
            case 196:                                  // F10
            case 261:                                  // F11
            case 262:                                  // F12
               currentDisplayKey = keyVal;
               entriesToDisplay( currentDisplayKey );
               firstPage();
               break;
            case 200:                                  // up
               previousRec();
               break;
            case 201:                                  // page-up
               previousPage();
               break;
            case 203:                                  // left
            case 199:                                  // home
               panLeft();
               break;
            case 205:                                  // right
            case 207:                                  // end
               panRight();
               break;
            case  32:                                  // space
            case 208:                                  // down
               nextRec();
               break;
            case 209:                                  // page-down
               nextPage();
               break;
            case 246:                                  // ctrl-page-down
               lastPage();
               break;
            case '+':
               setArray( CLOSE_ARCHIVE );
               if( setArray( DISPLAY_ARCHIVE ) == 0)
               {
                  rtnCode = readDir( +1, 0 );         // next pfh file
                  entriesToDisplay( currentDisplayKey );
                  firstPage();
                  archCommand();
                  if (rtnCode == 1)
                     writeatnc( 1, 24, "Partial archive; increase maxDirArchLoad" );
                  if (rtnCode == 2)
                     writeatnc( 1, 24, "No more files" );
               }
               break;
            case '-':
               setArray( CLOSE_ARCHIVE );
               if( setArray( DISPLAY_ARCHIVE ) == 0)
               {
                  rtnCode = readDir( -1, 0 );         // previous pfh file
                  entriesToDisplay( currentDisplayKey );
                  firstPage();
                  archCommand();
                  if (rtnCode == 1)
                     writeatnc( 1, 24, "Partial archive; increase maxDirArchLoad" );
                  if (rtnCode == 2)
                     writeatnc( 1, 24, "No more files" );
               }
               break;
         }
         break;

      case EXPANDPFH:                            // expanded header visible
         restoreScreen();
         state = DIRLIST;
         break;

      case FIND:
         rtnCode = UserMgr::getFileNumber( "Find", keyVal, &findFileNumber,
                                           cLine );
         switch (rtnCode)
         {
            case 0:
               if (activeArray == MAIN )
                  mainCommand();
               else
                  archCommand();
               int i;
               for (i = 0; i <= lastElementIndex; i++)
               if (findFileNumber == (*theArray[ i ]).file_number)
               {
                  lastRec = i - 1;
                  viewPage();
               }
               state = DIRLIST;
               break;
            case 1:
               break;
            case 2:
               cLine.init();
               state = DIRLIST;
         }
         break;

      case HELP:
         if (!help.processKey( "*DIR", keyVal ))
         {
            restoreScreen();
            state = DIRLIST;
         }
         break;
   }
   return 0;
}

void Directory::saveScreen()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   screenCount++;
   create_screen( screenCount, 23 );
   save_screen( screenCount );
   ::window( 1, 2, 80, 23 );
   textcolor( cfg.directoryFg );              // set colors
   textbackground( cfg.directoryBg );
}

void Directory::restoreScreen()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   restore_screen( screenCount );
   dispose_screen( screenCount );             // recover the memory
   screenCount--;
   _setcursortype( _NOCURSOR );
}

/*
unsigned long Directory::fileSize( const unsigned long fileNumber ) const
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   int            itemsCount;
   PFileHeader**  array;

   if (activeArray == MAIN)
   {
      itemsCount = itemsInContainer;
      array = theArray;
   }
   else
   {
      itemsCount = mainItemsInContainer;
      array = mainArray;
   }

   for (int i = 0; i < itemsCount; i++)
      if (array[ i ]->file_number == fileNumber)
         return array[ i ]->file_size;
   return 0;
}
*/

void Directory::firstPage( void )
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   lastRec = -1;
   currentLineIndex = 4;
   viewPage();
}

PFileHeader* Directory::getPfh( const unsigned long fileNumber )
// ---------------------------------------------------------------------
//  If the active array is not main, then switch to it.  Only search for
//  entries in the main array.
// ---------------------------------------------------------------------
{
   int            itemsCount;
   PFileHeader**  array;

   if (activeArray == MAIN)
   {
      itemsCount = itemsInContainer;
      array = theArray;
   }
   else
   {
      itemsCount = mainItemsInContainer;
      array = mainArray;
   }
   for (int i = 0; i < itemsCount; i++)
      if (array[ i ]->file_number == fileNumber)
      {
         // If the record is for a file with a blocked fileType, make sure
         // the StatusList is current.

         if (cfg.blockedFType( array[ i ]->file_type ))
            sList.status( array[ i ]->file_number, array[ i ]->file_type );
         return array[ i ];
      }
   return 0;
}

void Directory::init( const char *pathName, const char *myCall )
// ---------------------------------------------------------------------
//  We read the "PFH__????.PFH files from lowest to the highest
//  adding each of the pfh pbjects to our directory object.
// ---------------------------------------------------------------------
{
   strcpy( this->pathName, pathName );           // save the path name
   strcpy( this->myCall, myCall );
   char* pfhFileName = new char[ MAXPATH ];
   if (!pfhFileName)
      iWin.printFatal( "Out of Memory" );
   strcpy( pfhFileName, pathName );              // build search string
   strcat( pfhFileName, "pb__????.pfh" );

   struct ffblk fileBlock;
   if (findfirst( pfhFileName, &fileBlock, 0 ))  // look for first file
   {
      delete pfhFileName;
      return;
   }

   int seq;
   sscanf( fileBlock.ff_name, "PB__%u", &seq);   // get sequence number
   lastSeq = firstSeq = seq;                     // track lowest & highest

   while (!findnext( &fileBlock ))
   {
      sscanf( fileBlock.ff_name, "PB__%u", &seq ); // get sequence number
      if (seq < firstSeq)
         firstSeq = seq;
      if (seq > lastSeq)
         lastSeq = seq;
   }
   delete pfhFileName;
   unsigned rtnCode = readDir( 0, 0 );           // initial read
   switch (rtnCode)
   {
      case 0:
         while (readDir( -1, 0) == 0);           // read backwards to fill up
      case 1:                                    // note: fall through
         dirInitialized = 1;
         break;
      //case 2:                                  // not initialized
   }
   iWin.print( "Directory loading is complete" );
}

void Directory::lastPage()
// -------------------------------------------------------------------------
// View the last page of records
// -------------------------------------------------------------------------
{
   // Derive the starting point of the last page by working backwards.

   int index = lastElementIndex;
   int count = 0;
   while (index >= 0 && count < 20)
   {
      PFileHeader& pfhRecord = *theArray[ index-- ];
      if (pfhRecord.displayable())
         count++;
   }
   lastRec = index;
   currentLineIndex = count + 4;
   viewPage();
}

void Directory::mainCommand()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   writeat( 1, 1, cfg.cmdLineFg, cfg.cmdLineBg,
      "Keys: Prio Auto Grab Never Find aRchview Quit Help Main   Select = " );
}

void Directory::nextPage()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   int index = lastRec + 1;
   while (index <= lastElementIndex)
   {
      PFileHeader& pfhRecord = *theArray[ index++ ];
      if (pfhRecord.displayable())               // if more records to display
      {
         viewPage();
         return;
      }
   }
}

void Directory::nextRec()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   if ((displayCount < 20) &&
       (currentLineIndex - 3 >= displayCount))
   return;

   attrib( 1, currentLineIndex, 8, currentLineIndex,
           cfg.directoryFg, cfg.directoryBg );

   if (currentLineIndex < 23)
   {
      currentLineIndex++;
      attrib( 1, currentLineIndex, 8, currentLineIndex,
              cfg.directoryBg, LIGHTGRAY );
      return;
   }

   ::window( 1, 4, 80, 23 );
   gotoxy( 80, 20 );
   textcolor( cfg.directoryFg );            // set colors
   textbackground( cfg.directoryBg );
   while (lastRec < lastElementIndex)
   {
      PFileHeader& pfhRecord = *theArray[ ++lastRec ];
      if (pfhRecord.displayable())
      {
         memmove( &pfhIndex[ 0 ], &pfhIndex[ 1 ], sizeof( int )*19 );
         pfhIndex[ 19 ] = lastRec;
         cputs("\r\n");
         pfhRecord.displayOnScreen( panFlag );
         break;
      }
   }

   attrib( 1, currentLineIndex, 8, currentLineIndex,
           cfg.directoryBg, LIGHTGRAY );
}

void Directory::panLeft( void )
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   if (panFlag == 0)
      return;
   ::window(1, 2, 80, 3);
   textcolor( cfg.directoryFg );            // set colors
   textbackground( cfg.directoryBg );
   gotoxy(1, 1);
   cputs("Message \xb3S\xb3           Subject            \xb3  To  \xb3 From \xb3 Posted at \xb3 Size");
   gotoxy(1, 2);
   cputs("");
   ::window(1, 4, 80, 23);
   panFlag = 0;
   lastRec = pfhIndex[ 0 ] - 1;                  // find start for this page
   viewPage();
}

void Directory::panRight( void )
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   if (panFlag == 1)
      return;
   ::window(1, 2, 80, 3);
   textcolor( cfg.directoryFg );            // set colors
   textbackground( cfg.directoryBg );
   gotoxy(1, 1);
   cputs("Message \xb3S\xb3                Subject                 \xb3         Keywords    ");
   gotoxy(1, 2);
   cputs("");
   ::window(1, 4, 80, 23);
   panFlag = 1;
   lastRec = pfhIndex[ 0 ] - 1;                  // find start for this page
   viewPage();
}

void Directory::previousRec()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   if (!displayCount)
      return;
   attrib( 1, currentLineIndex, 8, currentLineIndex,
           cfg.directoryFg, cfg.directoryBg );

   if (currentLineIndex > 4)
   {
      currentLineIndex--;
      attrib( 1, currentLineIndex, 8, currentLineIndex,
              cfg.directoryBg, LIGHTGRAY );
      return;
   }
   int index = pfhIndex[ 0 ] - 1;                // find start for this page
   ::window( 1, 4, 80, 23 );
   textcolor( cfg.directoryFg );            // set colors
   textbackground( cfg.directoryBg );
   while (index >= 0)
   {
      PFileHeader& pfhRecord = *theArray[ index-- ];
      if (pfhRecord.displayable())
      {
         memmove( &pfhIndex[ 1 ], &pfhIndex[ 0 ], sizeof( int )*19 );
         pfhIndex[ 0 ] = index + 1;
         gotoxy( 1, 1 );
         insline();
         pfhRecord.displayOnScreen( panFlag );
         if (displayCount < 20)
            displayCount++;
         lastRec = pfhIndex[ displayCount - 1 ];
         gotoxy( 80, 20 );                         // reposition cursor
         break;
      }
   }
   attrib( 1, currentLineIndex, 8, currentLineIndex,
           cfg.directoryBg, LIGHTGRAY );
}

void Directory::previousPage()
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
{
   int index = lastRec;
   int count = 0;
   int skipCount = displayCount + 20;
   while (index >= 0 && count < skipCount)
   {
      PFileHeader& pfhRecord = *theArray[ index-- ];
      if (pfhRecord.displayable())
         count++;
   }
   if (count <= 20)                              // if no previous page
      currentLineIndex = 4;
   lastRec = index;
   viewPage();
}

unsigned Directory::readDir( const int direction, const unsigned makeSpace )
// ---------------------------------------------------------------------
// Direction: -1  -  read next lower directory in sequence
//             0  -  first time through; read highest sequenced directory
//             1  -  read next higher directory in sequence
//             2  -  read the directory with the currentSequence number
//
// Return: 0 - entire directory file successfully loaded
//         1 - partial directory file loaded
//         2 - directory file not loaded
// ---------------------------------------------------------------------
{
   // The last directory in the PB__????.PFH sequence is already open.
   // Therefore do not open and close this file.

   if (lastSeq < 0)
   {
      cputs( "No pb__????.pfh files found in current directory" );
      return 2;
   }
   char* pfhFileName = new char[ MAXPATH ];      // make filename
   if (!pfhFileName)
      iWin.printFatal( "Dir error 3: out of memory" );
   static int currentSeqNumber = -1;
   FILE* file = 0;
   do
   {
      switch (direction)
      {
         case -1:
            if (currentSeqNumber - 1 >= int( firstSeq ))
               currentSeqNumber--;
            else                                 // already loaded first one
            {
               delete pfhFileName;
               return 2;
            }
            break;
         case 0:
            currentSeqNumber = lastSeq;          // first time through
            file = dfm.file;
            break;
         case 1:
            if (currentSeqNumber + 1 <= int( lastSeq ))
               currentSeqNumber++;
            else                                 // already loaded last one
            {
               delete pfhFileName;
               return 2;
            }
            break;
         case 2:
            break;                               // reload current one
         default:
            if (currentSeqNumber == -1)
               return 2;
            ;                                    // use current sequence number
      }
      sprintf( pfhFileName, "%sPB__%04u.PFH", pathName, currentSeqNumber );
      if (file != dfm.file)
         file = fopen( pfhFileName, "rb" );      // open file
   }
   while (file == 0);

   rewind( file );                               // for when file == dfm.file

   char* buf = new char[ DIR_BUFSIZE ];          // input buffer
   if (!buf)
      iWin.printFatal( "Dir error 4: out of memory" );
   sprintf( iWin.buf, "Reading PB__%04u.PFH", currentSeqNumber );
   iWin.print( iWin.buf );

   unsigned       bufleft   = DIR_BUFSIZE;       // buffer space available
   unsigned       cnt       = 0;                 // bytes read
   unsigned       len       = 0;                 // data length in buffer
   char*          bp        = buf;               // working pointer
   PFileHeader    pfh( iWin );
   int            hdrlen;
   unsigned       rtnCode   = 0;
   while (!feof( file ))                         // if data left
   {
      cnt = fread(bp, 1, bufleft, file);         // read into space available
      len += cnt;                                // data bytes in buffer
      bp += cnt;                                 // next free space in buffer
      bufleft -= cnt;                            // buffer space available
      while (len)
      {                                          // add it to the directory
         if ((hdrlen = pfh.get( buf, len )) == 0)
            break;
         len -= hdrlen;                          // dec length of data left
         bp -= hdrlen;                           // dec free space start
         bufleft += hdrlen;                      // inc free space
         memmove( buf, buf + hdrlen, len );      // delete pfh from buffer
         if ((rtnCode = addPfh( pfh, direction, makeSpace )) != 0)
            break;
      }
      if (rtnCode)                               // if full directory
         break;
      if (!bufleft)
      {
         sprintf( iWin.buf, "directory file <%s> corrupted", pfhFileName );
         iWin.print( iWin.buf );
         bp = buf;                               // re-init buffer
         bufleft = DIR_BUFSIZE;                  // do discard bad pfh
         cnt = len = 0;
      }
   }
   if (file != dfm.file)
      fclose(file);                              // close it
   lastRec = -1;
   if (direction != 0)
      writeatnc( 1, 24, "                                          " );
   delete pfhFileName;
   delete buf;
   if (rtnCode)
      return 1;
   else
      return 0;
}

unsigned Directory::remove( const unsigned spaceToFree,
                            const int      whichToRemove )
// ---------------------------------------------------------------------
//  Removes the oldest or youngest PFileHeader instances from the
//  directory to make space for the specified number of bytes.
//
//  Return 0 if space is successfully freed, otherwise return 1;
// ---------------------------------------------------------------------
{
   if (!itemsInContainer || spaceToFree > bytesUsed
                         || spaceToFree > maxDirLoad)
      return 1;
   while (itemsInContainer && bytesUsed + spaceToFree > maxDirLoad)
   {
      unsigned detachPoint;
      if (whichToRemove < 0)
         detachPoint = 0;                        // start with youngest
      else
         detachPoint = lastElementIndex;         // start with oldest
      if (theArray[ detachPoint ] == PFileHeader::ZERO)
         return 1;
      bytesUsed -= theArray[ detachPoint ]->pFileHeaderSize;
      delete theArray[ detachPoint ];
      memmove( &theArray[ detachPoint ], &theArray[ detachPoint + 1 ],
               sizeof( PFileHeader* ) * (lastElementIndex - detachPoint) );
      theArray[ lastElementIndex ] = PFileHeader::ZERO;
      lastElementIndex--;
      itemsInContainer--;
   }
   return 0;
}

unsigned Directory:: setArray( const unsigned action )
// -------------------------------------------------------------------------
// Set the active array to be either the main array or the archive array.
// -------------------------------------------------------------------------
{
   static unsigned long mainMaxDirLoad;
// static unsigned long archMaxDirLoad;          // not needed
   static unsigned      mainUpperBound;
   static unsigned      archUpperBound;
   static PFileHeader**     archArray;
   static int           mainCurrentLineIndex;
   static int           archCurrentLineIndex;
   static unsigned      mainDisplayCount;
   static unsigned      archDisplayCount;
   static unsigned      archItemsInContainer;
   static int           mainLastElementIndex;
   static int           archLastElementIndex;
   static unsigned long mainBytesUsed;
   static unsigned long archBytesUsed;
   static unsigned      archiveState = CLOSED;

   switch (action)
   {
      case DISPLAY_ARCHIVE:
         if (activeArray == ARCHIVE)
            return 1;
         if (archiveState == CLOSED)
         {
            if (1.1 * maxDirArchLoad > farcoreleft())
            {
               writeatnc( 1, 24, "Insufficient memory to read archive file" );
               return 1;
            }
            archUpperBound = unsigned( maxDirArchLoad / 150 );
            archCurrentLineIndex = 4;
            archDisplayCount = 0;
            archItemsInContainer = 0;
            archLastElementIndex = -1;
            archArray = new PFileHeader* [ archUpperBound + 1 ];
            if (!archArray)
               iWin.printFatal( "Dir error 7: out of memory" );
            for (unsigned i = 0; i < archUpperBound + 1; i++)
               archArray[ i ] = PFileHeader::ZERO;

            archBytesUsed = (archUpperBound + 1) * sizeof( PFileHeader* );
            archiveState = OPENED;
         }
         activeArray = ARCHIVE;

         mainMaxDirLoad = maxDirLoad;
         maxDirLoad = maxDirArchLoad;

         mainUpperBound = upperbound;
         upperbound = archUpperBound;

         mainCurrentLineIndex = currentLineIndex;
         currentLineIndex = archCurrentLineIndex;

         mainDisplayCount = displayCount;
         displayCount = archDisplayCount;

         mainItemsInContainer = itemsInContainer;
         itemsInContainer = archItemsInContainer;

         mainLastElementIndex = lastElementIndex;
         lastElementIndex = archLastElementIndex;

         mainArray = theArray;
         theArray = archArray;

         mainBytesUsed = bytesUsed;
         bytesUsed = archBytesUsed;
         break;

      case CLOSE_ARCHIVE:
         if (archiveState != OPENED)
            return 1;
         if (activeArray == ARCHIVE)
            archLastElementIndex = lastElementIndex;
         int i;
         for (i = 0; i <= archLastElementIndex; i++)
               delete archArray[ i ];
         delete archArray;
         archiveState = CLOSED;
         if (activeArray == MAIN)
            break;
                                                 // note: fall thorugh
      case DISPLAY_MAIN:
         if (activeArray == MAIN)
            return 1;
         activeArray = MAIN;

         maxDirLoad = mainMaxDirLoad;

         archUpperBound = upperbound;
         upperbound = mainUpperBound;

         archCurrentLineIndex = currentLineIndex;
         currentLineIndex = mainCurrentLineIndex;

         archDisplayCount = displayCount;
         displayCount = mainDisplayCount;

         archItemsInContainer = itemsInContainer;
         itemsInContainer = mainItemsInContainer;

         archLastElementIndex = lastElementIndex;
         lastElementIndex = mainLastElementIndex;

         archArray = theArray;
         theArray = mainArray;

         archBytesUsed = bytesUsed;
         bytesUsed = mainBytesUsed;
         break;
   }
   return 0;
}

void Directory::setStatus( const int status ) const
// ---------------------------------------------------------------------
// Update the status of a directory entry using the currentLine Index
// to get the record in the directory.  Update the display and the status
// in the sList.
// ---------------------------------------------------------------------
{
   PFileHeader& pfhRecord = *theArray[ pfhIndex[ currentLineIndex - 4 ] ];
   pfhRecord.status = status;                    // update the record
   char* str = " ";
   *str = PFileHeader::statusChar[ status ];
   writeatnc( 10, currentLineIndex, str );       // update the display
   sList.set( pfhRecord.file_number, (StatusList::sCode) status );   // update the status list
}

void Directory::setStatus( const unsigned long file_number,
                           const char          status )
// -------------------------------------------------------------------------
// Update status of a directry entry using file number to locate the entry.
// -------------------------------------------------------------------------
{
   for (int i = 0; i < itemsInContainer; i++)
      if (theArray[ i ]->file_number == file_number)
      {
         theArray[ i ]->status = status;
         theArray[ i ]->displayThis = sem->resolve( eqnCurrent, theArray[ i ] );
         switch (state)
         {
            case DIRLIST:
               if (displayCount == 20)
                  lastRec = pfhIndex[ 0 ] - 1;   // end of previous page
               else
                  lastRec = -1;
               viewPage();
            case EXPANDPFH:
            case FIND:
            case HELP:
            case CLOSED:
               break;
         }
         break;
      }
}

void Directory::viewPage( void )
// -------------------------------------------------------------------------
// View a page of records
// -------------------------------------------------------------------------
{
   ::window( 1, 4, 80, 23 );
   textcolor( cfg.directoryFg );            // set colors
   textbackground( cfg.directoryBg );
   gotoxy( 1, 1 );
   displayCount = 0;
   while (lastRec < lastElementIndex && displayCount < 20)
   {
      PFileHeader& pfhRecord = *theArray[ ++lastRec ];
      if (pfhRecord.displayOnScreen( panFlag ))
      {
         pfhIndex[ displayCount ] = lastRec;
         displayCount++;
         if (displayCount < 20)
            cputs( "\r\n" );
      }
   }
   int x = wherex();                             // remember cursor position
   int y = wherey();
   int i = displayCount;
   while (i < 20)                                // blank any remaining lines
   {
      i++;
      cputs( "                              "
             "                              "
             "                   " );
      if (i < 20)
         cputs( "\r\n" );
   }
   gotoxy( x, y );                               // restore cursor position
   if (currentLineIndex > displayCount + 3)
      currentLineIndex = displayCount ? displayCount + 3 : 4;
   attrib( 1, currentLineIndex, 8, currentLineIndex, cfg.directoryBg,
           LIGHTGRAY );
}
