//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __DIRBCST_H
#define  __DIRBCST_H

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class MBuf;
class StatusLine;
class Window;

class DirFrHdr                                   // directory frame header
{
public:
          char          lastFrame;
          char          newestFile;
          unsigned long fileId;
          unsigned long offset;
          unsigned long tOld;
          unsigned long tNew;
   static DirFrHdr*     ZERO;
};

#define NOFRHDR *(DirFrHdr::ZERO)

class DPair
{
public:
          unsigned long tOld;
          unsigned long tNew;
};

class Ax25;
class Config;
class Directory;
class DirFileMgr;
class Equation;
class Level3Iface;
class MBuf;
class MsgLine;
class Protocol;
class SemanticsAnalyzer;
class StatusLine;
class StatusList;
class SyntaxAnalyzer;
class Timer;
class Window;

class DirBcstMgr : public L3Protocol
{
public:
          DPair*             dHoles;
          Timer*             dirRqstWaitTimer;
          int                dirHoleCount;
          unsigned           upToDate;

                             DirBcstMgr( char&              bcstAddr,
                                         char&              myAddr,
                                         Protocol&          logProto,
                                         DirFileMgr&        dfm,
                                         Directory&         dir,
                                         SyntaxAnalyzer&    parser,      // select equation parser
                                         SemanticsAnalyzer& sem,         // eqn semantics analyzer
                                         StatusList&        sList,       // download file status list
                                         Config&            cfg,
                                         Window&            frWin,
                                         Window&            iWin,
                                         StatusLine&        sLine );
                             ~DirBcstMgr();
          void               link( Ax25*& axpr ) { axp = axpr; }
          void               recvIn( Level3Iface& l3If );
          void               rqstFill();

private:
   static enum             { DIR_LIST_SIZE_START = 10 };
   static enum             { DIR_LIST_SIZE_INC = 10 };
   static enum             { MAX_PAIRS = 10, MAXLINE = 81 };

          unsigned           autoSelect;
          Ax25*&             axp;
          char&              bcstAddr;
          unsigned           bcstPacLen;
          DirFileMgr&        dfm;
          Directory&         dir;
          char*              dirData;            // accumulator
          int                dirCnt;             // bytes in accumulator
          char*              dirCp;              // working pointer
          unsigned           dirHoleListSize;
          Equation*          eqnAuto;            // automatic select equation
          Equation*          eqnPriority;        // priority select equation
          Equation*          eqnNever;           // never select equation
          unsigned           exitOnSatCallError;
          Window&            frWin;              // frame window
          unsigned           highlightBg;
          unsigned           highlightFg;
          Window&            iWin;               // information window
          unsigned*          loggingStatus;
          unsigned           logDirFrames;
          unsigned*          logInFrames;
          Protocol&          logProto;           // protocol to log raw frames
          unsigned           maxPfhSize;
          unsigned*          monitor;
          char&              myAddr;
          char*              mycall;
          SyntaxAnalyzer&    parser;             // select equation parser
          char*              pfhDir;
          SemanticsAnalyzer& sem;                // eqn semantics analyzer
          unsigned           simulate;
          StatusLine&        sLine;              // status line
          StatusList&        sList;              // download file status list
          unsigned*          trace;

          void               addHole( DPair* newp );
          DirFrHdr&          decodeHdr( MBuf& mb );
          void               deleteHole( int i );
          unsigned           dirUpToDate( const unsigned long tNew );
          int                needEntry( DirFrHdr& hdr );
          void               readHoles();
          void               saveFrame( MBuf& mb );
          void               writeHoles();
};

#endif __DIRBCST_H
