//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __CONFIG_H
#define  __CONFIG_H

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

class Config
{
public:
   enum        { ReviewDirectory, NoFileWindow };
   enum        { KissMode, TermMode };

   unsigned long abortInterval;              // interval until abort time
   unsigned long abortTime;                  // time to abort program
   unsigned      actDays;                    // inactivity purge interval
   unsigned      aeaDelay;                   // AEA TNC additional delay
   char          alias[ 41 ];                // user alias
   unsigned      automode;
   unsigned      autoSelect;                 // auto message selection
   unsigned      autoUpload;                 // automatic uploading
   unsigned long axIRTT;                     // frack
   unsigned      axPacLen;
   unsigned      axVersion;
   unsigned      axWindow;
   unsigned      backOffSlot;                // size of a backoff slot
   char*         bats1;                      // 1st string POSTPASS.BAT
   char*         bats2;                      // 2nd string POSTPASS.BAT
   char          bbscall[ 10 ];              // satellite BBS call sign
   char          bcstcall[ 10 ];             // satellite bcst call sign
   unsigned      bcstPaclen;
   unsigned long bLimit;
   char          blockFType[ 20 ];           // blocked file types
   unsigned      blockLogs;                  // block all log files
   unsigned      breakDelay;                 // delay after break to TNC
   unsigned      capture;                    // capture screen
   unsigned      charDelay;                  // ms. delay bytes to TNC
   unsigned      commandDelay;               // delay after command to TNC
   char          currentSat[ 16 ];           // bbs call w/o SSID
   unsigned      databits;                   // serial port data bits
   unsigned      debug;                      // amt of debug info
   unsigned      debugAx25;                  // display Ax25 header in hex
   unsigned      debugPortDataHex;           // show serial port data
   char          defaultSel[ 4 ];            // default select equation
   unsigned      delayInterval;              // delay after "n" chars
   unsigned long dirUpdateMs;                // wait time in millisecs
   char          dlDir[ MAXPATH+1 ];         // loc of uploadable files
   unsigned long exitAfterMs;                // idle mins until exiting
   int           exitCode;                   // reason for program exit
   char*         exitInfoFile;               // file of exit times
   unsigned      exitOnSatCallError;         // exit if another heard
   unsigned      ftl0Paclen;
   unsigned long fullDupCmdInterval;         // fulldup command interval
   unsigned      fullDuplex;                 // AX.25 fullduplex
   unsigned      grabAll;                    // grab all files flag
   char          hideCalls[ 20 ][ Ax25::AXALEN ]; // hide data for callsigns
   unsigned long idleExitTime;               // exit time if idle
   unsigned      kissTnc;                    // flag for a KISS TNC
   char          logcall[ 10 ];
   unsigned      logDirFrames;               // log broadcast dir frames
   unsigned      logFileFrames;              // log broadcast file frames
   unsigned      loggingStatus;              // SLIP frame logging status
   unsigned      logInFrames;                // log incoming SLIP frames
   unsigned      logOutFrames;               // log outgoing SLIP frames
   unsigned      makeBat;                    // batch file generation
   unsigned      maxBackOff;                 // maximum backoff slots
   unsigned      maxFrame;
   unsigned long maxDirArchLoad;             // max archive bytes
   unsigned long maxDirFileSize;             // maximum dir file size
   unsigned long maxDirLoad;                 // max directory bytes
   unsigned      maxPfhSize;                 // max pfh size people create
// unsigned      maxHandleCount;             // max DOS file handles
   unsigned      monitor;
   char          mycall[ 10 ];               // user call sign
   unsigned      n2;                         // retries
   unsigned      nDupeSearch;
   unsigned      numCallsToHide;             // number of callsigns to hide
   unsigned      numTypesBlocked;            // number blocked file types
   int           orbitDrvInterrupt;          // OrbitDRV interrupt vector
   char          parity;                     // serial port parity
   unsigned      persistence;                // AX.25 persistence
   unsigned      port;                       // serial port to TNC
   unsigned      portAddr;                   // serial port address
   unsigned      portIrq;                    // serial port IRQ
   unsigned      pThresh;
   unsigned      purgeN;                     // purge "NEVER" files
   unsigned      responseDelay;              // ms delay for TNC to respond
   unsigned      restartDelay;               // delay after TNC restart
   unsigned      screenMode;                 // screen start mode
   char          select[ MAXPATH+1 ];        // select equation file name
   unsigned      setClockToSat;              // set CPU time from sat time
   unsigned      showData;                   // show frame data
   unsigned      showDataHex;                // show data in hex
   unsigned      showGrabs;                  // show grabbing reasons
   unsigned      showLoopSpeed;              // show commutator loop speed
   unsigned      showHeaders;                // show AX.25 headers
   unsigned      showMemory;                 // show memory
   unsigned      showTimerActivity;          // show timer starting / stopping
   unsigned      silent;                     // turn off warning bells
   unsigned      simulate;                   // receive from sim file
   unsigned      simulationDelay;            // delay input from file
   unsigned      slotTime;                   // AX.25 slottime
   unsigned      speed;                      // serial port speed
   unsigned      stopbits;                   // serial port stop bit time
   unsigned long t3Init;
   unsigned      tncId;                      // multi drop KISS address
   char          tncInitFile[ MAXPATH+1 ];   // TNC initialization file
   unsigned      tncStartMode;               // TNC startup mode
   char          tncTermFile[ MAXPATH+1 ];   // TNC termination file
   unsigned      trace;
   unsigned      txd;                        // AX.25 txdelay
   char          ulDir[ MAXPATH+1 ];         // loc of downloaded files
   char          workDir[ MAXPATH+1 ];       // loc of work files

   unsigned      borderFg;
   unsigned      borderBg;
   unsigned      cmdLineFg;
   unsigned      cmdLineBg;
   unsigned      dataWinFg;
   unsigned      dataWinBg;
   unsigned      directoryFg;
   unsigned      directoryBg;
   unsigned      fileWinFg;
   unsigned      fileWinBg;
   unsigned      helpFg;
   unsigned      helpBg;
   unsigned      highlight1Fg;
   unsigned      highlight1Bg;
   unsigned      highlight2Fg;
   unsigned      highlight2Bg;
   unsigned      highlight3Fg;
   unsigned      highlight3Bg;
   unsigned      hightimeBorFg;
   unsigned      hightimeBorBg;
   unsigned      hightimeHighFg;
   unsigned      hightimeHighBg;
   unsigned      hightimeTextFg;
   unsigned      hightimeTextBg;
   unsigned      infoWinFg;
   unsigned      infoWinBg;
   unsigned      msgLineFg;
   unsigned      msgLineBg;
   unsigned      statusLineFg;
   unsigned      statusLineBg;

                 Config();
                 ~Config() {}
   unsigned      blockedFType( const char fileType ) const;
   void          getExitInfo();
   void          read( char* argv[] );
   void          putExitInfo();
};

#endif   __CONFIG_H
