//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __AXSOCK_H
#define  __AXSOCK_H

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class Config;
class DirBcstMgr;
class FileBcstMgr;
class FTL0User;
class Level3Iface;
class QueueFrameMgr;
class StatusLine;
class StatusList;
class Window;

class BeaconMgr : public L3Protocol
{
public:
                         BeaconMgr( Config&        cfg,
                                    Window&        iWin,
                                    Window&        frWin,
                                    FTL0User&      ftl0User,
                                    char&          bbsAddr,
                                    char&          bcstAddr,
                                    char&          myAddr,
                                    DirBcstMgr&    dbm,
                                    FileBcstMgr&   fbm,
                                    StatusLine&    sLine,
                                    StatusList&    sList );
          void           recvIn( Level3Iface& l3If );
          void           recvQFrame( MBuf& mb );

private:
          unsigned*      automode;
          char&          bbsAddr;
          char&          bcstAddr;
          unsigned       bcstPacLen;
          unsigned       dataWinBg;
          DirBcstMgr&    dbm;
          unsigned       exitOnSatCallError;
          FileBcstMgr&   fbm;
          Window&        frWin;
          char           (*hideCalls)[ Ax25::AXALEN ]; // hide data for callsigns
          unsigned       highlightBg;
          unsigned       highlightFg;
          unsigned long* idleExitTime;
          Window&        iWin;
          unsigned*      monitor;
          char&          myAddr;
          char*          mycall;
          unsigned       numCallsToHide;         // number of callsigns to hide
          unsigned       setClockToSat;
          StatusLine&    sLine;
          StatusList&    sList;
          unsigned*      trace;
          FTL0User&      ftl0User;
};

class IdleCallUp : public CallUp
{
public:
                         IdleCallUp( Object& obj, int exitCode );
         void            func() const;

private:
         int             exitCode;
};

#endif   __AXSOCK_H
