//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __AX25USER_H
#define  __AX25USER_H

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __OBJECT_H
#include "object.h"
#endif

class Ax25;

class RecvCallUp : public CallUp
{
public:
         Ax25*           axp;

                         RecvCallUp( Object& obj );
         void            func() const;
};

class StatusCallUp : public CallUp
{
public:
         Ax25*           axp;

                         StatusCallUp( Object& obj );
         void            func() const;
};

class Ax25ConnTbl;
class Config;
class MBuf;
class L1Protocol;
class LinkTable;
class Log;
class Rotor;
class StatusLine;
class Window;

class Ax25User : public Object
{
public:
                         Ax25User( Config&     cfg,
                                   Window&     iWin,
                                   Window&     frWin,
                                   StatusLine& sLine,
                                   L1Protocol& loProto,
                                   char&       logAddr,
                                   Log&        log,
                                   LinkTable&  link,
                                   CallUp&     eCallUp,
                                   Rotor&      antennaControl );
  virtual                ~Ax25User() {}
          Ax25&          open( char&    local,    // local address
                               char&    remote,   // remote address
                               int      mode,     // active/passive/server
                               unsigned window,   // window size in bytes
                               CallUp&  tCallUp,  // transmit call up function
                               CallUp&  eCallUp );// error call up fuction
          void           reset( Ax25& ax );
          int            send( Ax25& ax, MBuf& mb, int pid );

protected:
                                                 // codes for the open call
   static enum         { AX_PASSIVE    = 0,
                         AX_ACTIVE     = 1,
                         AX_SERVER     = 2 };    // passive, clone on opening

          Rotor&         antennaControl;
          Config&        cfg;
          CallUp&        eCallUp;
          Window&        frWin;
          Window&        iWin;
          LinkTable&     link;
          Log&           log;
          L1Protocol&    loProto;
          char&          logAddr;
          StatusLine&    sLine;

  virtual void           rCall( Ax25& ) {};
  virtual void           sCall( Ax25& ) {};

          friend class   RecvCallUp;
          friend class   StatusCallUp;
};

#endif  __AX25USER_H
