//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __AX25USER_H
#include "ax25User.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

Ax25User::Ax25User( Config&     cfg,
                    Window&     iWin,
                    Window&     frWin,
                    StatusLine& sLine,
                    L1Protocol& loProto,
                    char&       logAddr,
                    Log&        log,
                    LinkTable&  link,
                    CallUp&     eCallUp,
                    Rotor&      antennaControl )
                  :
                    Object(),
                    cfg( cfg ),
                    iWin( iWin ),
                    frWin( frWin ),
                    sLine( sLine ),
                    loProto( loProto ),
                    logAddr( logAddr ),
                    log( log ),
                    link( link ),
                    eCallUp( eCallUp ),
                    antennaControl( antennaControl )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{}

/*
int Ax25User::kick()
// --------------------------------------------------------------------------
// Force a retransmission
// --------------------------------------------------------------------------
{
   if (!val())
      return -1;
   recover( *axp );
   return 0;
}
*/

Ax25& Ax25User::open( char&    local,            // local address
                      char&    remote,           // remote address
                      int      mode,             // active/passive/server
                      unsigned window,           // window size in bytes
                      CallUp&  tCallUp,          // transmit call up fuction
                      CallUp&  eCallUp )         // error call up fuction
// --------------------------------------------------------------------------
// Open an AX.25 connection
// --------------------------------------------------------------------------
{
   char* remote1 = &remote;
   if (!remote1)
   {
      char remtmp[ Ax25::AXALEN ];
      remote1 = remtmp;
      Ax25::setCall( remote1, " " );
   }
   Ax25* axp = Ax25::connTbl.find( *remote1 );
   if (axp && axp->state() != LAPB::DISCONNECTED)
      return NULAX25;                            // only one to a customer

   if (!axp)
   {
      RecvCallUp* rCallUp = new RecvCallUp( *this );
      StatusCallUp* sCallUp = new StatusCallUp( *this );
      axp = &Ax25::create( cfg, iWin, frWin, sLine, loProto, local,
                           *remote1, logAddr, log, link, window,
                           *rCallUp, *sCallUp, tCallUp, eCallUp,
                           *this, antennaControl );
      if (!axp)
      {
         delete rCallUp;
         delete sCallUp;
         return NULAX25;
      }
      rCallUp->axp = axp;                        // pass the address to
      sCallUp->axp = axp;                        // the callups
   }

   switch( mode )
   {
      case AX_SERVER:
         axp->clone = 1;
      case AX_PASSIVE:                            // note fall-thru
//         axp->setState( LAPB::LISTEN );
         return *axp;
      case AX_ACTIVE:
         break;
   }
   axp->connect();
   return *axp;
}

/*
MBuf& Ax25User::recv( unsigned cnt )
// --------------------------------------------------------------------------
// Receive incoming data on an AX.25 connection
// --------------------------------------------------------------------------
{
   MBuf* bp;

   if (!axp->rxq)
      return 0;

   if (cnt == 0)
   {
      // This means we want it all
      bp = axp->rxq;
      axp->rxq = 0;
   }
   else
   {
      bp = ambufw( cnt );
      mb.cnt = pullup( &axp->rxq, mb.data, cnt );
   }
   // If this has un-busied us, send a RR to reopen the window
   if (len_p( axp->rxq ) < axp->window &&
       (len_p( axp->rxq ) + mb.cnt) >= axp->window)
      sendctl( axp, LAPB_RESPONSE, RR );

   return bp;
}
*/

void Ax25User::reset( Ax25& ax )
// --------------------------------------------------------------------------
// Abruptly terminate an AX.25 connection
// --------------------------------------------------------------------------
{
   if (&ax)
      ax.reset();
}

int Ax25User::send( Ax25& ax, MBuf& mb, int pid )
// --------------------------------------------------------------------------
// Send data on an AX.25 connection. Caller provides optional PID. If
// a PID is provided, then operate in stream mode, i.e., a large packet
// is automatically packetized into a series of paclen-sized data fields.
//
// If pid == -1, it is assumed the packet (which may actually be a queue
// of distinct packets) already has a PID on the front and it is passed
// through directly even if it is very large.
// --------------------------------------------------------------------------
{
   if (!&ax || !&mb)
   {
      delete &mb;
      return -1;
   }
   unsigned offset, len;
   if (pid != -1)
   {
      offset = 0;
      len = mb.cnt;

      // It is important that all the pushdowns be done before
      // any part of the original packet is freed.
      // Otherwise the pushdown might erroneously overwrite
      // a part of the packet that had been duped and freed.

      MBuf* bp1;
      while (len != 0)
      {
         unsigned size = len < ax.pacLen ? len : ax.pacLen;
         bp1 = new MBuf( mb, offset, size );
         bp1->reAlloc( size + 17 );              // make room for the header
         len -= size;
         offset += size;
         bp1->pushDown( 1 );
         bp1->data[ 0 ] = pid;
         ax.txEnqueue( *bp1 );
      }
      delete &mb;
   }
   else
      ax.txEnqueue( mb );

   return ax.output();
}

/*
int Ax25User::val()
// --------------------------------------------------------------------------
// Verify that axp is a valid ax25 objcet
// --------------------------------------------------------------------------
{
   return = Ax25::connTbl.validate( axp );
}
*/

StatusCallUp::StatusCallUp( Object& obj )
                          :
                            CallUp( obj ), axp( 0 )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void StatusCallUp::func() const
// -------------------------------------------------------------------------
// Ax25User status call up function
// -------------------------------------------------------------------------
{
   if (axp)
      ((Ax25User&) obj).sCall( *axp );
}

RecvCallUp::RecvCallUp( Object& obj )
                      :
                        CallUp( obj ), axp( 0 )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void RecvCallUp::func() const
// -------------------------------------------------------------------------
// program exit function
// -------------------------------------------------------------------------
{
   if (axp)
      ((Ax25User&) obj).rCall( *axp );
}

