//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// These functions were developed from Phil Karn's (KA9Q) NOS source code
// dated 920621.  Unused lines of code are commented out but retained for
// reference.

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __ALLOC_H
#include <alloc.h>
#endif

#ifndef  __CTYPE_H
#include <ctype.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __AX25USER_H
#include "ax25User.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __HDLNOL3_H
#include "hdlnol3.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

#ifndef  __SATLINK_H
#include "satlink.h"
#endif

#ifndef  __PKTQUEUE_H
#include "pktqueue.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

Ax25ConnTbl  Ax25::connTbl;
Ax25*        Ax25::ZERO = 0;

// If a specific processing is required for a multicast addressee, e.g., "TLM",
// put it in the Axmulti table.  All the various satelllite utility callsigns
// may have not been included.

char         Ax25::multi[ 19 ][ Ax25::AXALEN ] =
{
   {'Q'<<1, 'S'<<1, 'T'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1},   // QST
   {'Q'<<1, 'S'<<1, 'T'<<1, ' '<<1, ' '<<1, ' '<<1, '1'<<1},   // QST1
   {'P'<<1, 'B'<<1, 'L'<<1, 'I'<<1, 'S'<<1, 'T'<<1, '0'<<1},   // PBLIST
   {'P'<<1, 'B'<<1, 'F'<<1, 'U'<<1, 'L'<<1, 'L'<<1, '0'<<1},   // PBFULL
   {'B'<<1, 'B'<<1, 'S'<<1, 'T'<<1, 'A'<<1, 'T'<<1, '0'<<1},   // BBSTAT
   {'N'<<1, 'E'<<1, 'W'<<1, 'S'<<1, ' '<<1, ' '<<1, '0'<<1},   // NEWS
   {'H'<<1, 'I'<<1, 'T'<<1, 'V'<<1, 'E'<<1, 'R'<<1, '0'<<1},   // HITVER
   {'T'<<1, 'L'<<1, 'M'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1},   // TLM
   {'S'<<1, 'T'<<1, 'A'<<1, 'T'<<1, 'U'<<1, 'S'<<1, '0'<<1},   // STATUS
   {'W'<<1, 'O'<<1, 'D'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1},   // WOD
   {'M'<<1, 'A'<<1, 'I'<<1, 'L'<<1, ' '<<1, ' '<<1, '0'<<1},   // MAIL
   {'N'<<1, 'O'<<1, 'D'<<1, 'E'<<1, 'S'<<1, ' '<<1, '0'<<1},   // NODES
   {'I'<<1, 'D'<<1, ' '<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1},   // ID
   {'O'<<1, 'P'<<1, 'E'<<1, 'N'<<1, ' '<<1, ' '<<1, '0'<<1},   // OPEN
   {'C'<<1, 'Q'<<1, ' '<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1},   // CQ
   {'B'<<1, 'E'<<1, 'A'<<1, 'C'<<1, 'O'<<1, 'N'<<1, '0'<<1},   // BEACON
   {'R'<<1, 'M'<<1, 'N'<<1, 'C'<<1, ' '<<1, ' '<<1, '0'<<1},   // RMNC
   {'A'<<1, 'L'<<1, 'L'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1},   // ALL
   {'\x0'}
};

Ax25::Ax25( Config&     cfg,
            Window&     iWin,
            Window&     frWin,
            StatusLine& sLine,
            Ax25User&   user,
            char&       myAddr,
            char&       logAddr,
            Log&        log,
            Rotor&      antennaControl )
          :
            L2Protocol(),
            cfg( cfg ),
            iWin( iWin ),
            frWin( frWin ),
            sLine( sLine ),
            myAddr( myAddr ),
            logAddr( logAddr ),
            log( log ),
            antennaControl( antennaControl ),
            linkTbl( 0 ),
            next( 0 ),
            clone( 0 ),
            user( user )
// -------------------------------------------------------------------------
//  Constructor for an AX.25 link layer object
// -------------------------------------------------------------------------
{
   eCallUp = 0;                        // error call up
   logCall = cfg.logcall;
   loggingStatus = &cfg.loggingStatus;
   logInFrames = &cfg.logInFrames;
   logOutFrames = &cfg.logOutFrames;
   monitor = &cfg.monitor;
   pacLen = cfg.axPacLen;
   rCallUp = 0;                        // receive call up
   sCallUp = 0;                        // status change call up
   showData = &cfg.showData;
   showDataHex = &cfg.showDataHex;
   showGrabs = cfg.showGrabs;
   showHeaders = &cfg.showHeaders;
   showInFrames = &cfg.debugAx25;
   simulate = cfg.simulate;
   tCallUp = 0;                        // transmit call up
   trace = &cfg.trace;
   lapb = new LAPB( cfg, frWin, log );           // note: link() LAPB when
   *local = 0;                                   // Ax25::link() is called
   *remote = 0;
}

Ax25::~Ax25()
// -------------------------------------------------------------------------
//  Destructor for an AX.25 link object.
// -------------------------------------------------------------------------
{
   delete lapb;
}

unsigned Ax25::bytesToSend() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   return lapb->bytesToSend();
}

void Ax25::connect() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   lapb->connect();
}

Ax25& Ax25::create( Config&     cfg,
                    Window&     iWin,
                    Window&     frWin,
                    StatusLine& sLine,
                    L1Protocol& loPro,
                    char&       local,
                    char&       remote,
                    char&       logAddr,
                    Log&        log,
                    LinkTable&  linkTbl,
                    unsigned    window,          // window size in bytes
                    CallUp&     rCallUp,         // receive call up function
                    CallUp&     sCallUp,         // status change call up function
                    CallUp&     tCallUp,         // transmit call up fuction
                    CallUp&     eCallUp,         // error call up fuction
                    Ax25User&   user,            // user linkage
                    Rotor&      antennaControl )
// -------------------------------------------------------------------------
// Create an ax25 link object and add it to the connection table.  The caller
// is still responsible for filling in the reply address.
// -------------------------------------------------------------------------
{
   if (!&remote)
      return NULAX25;

   Ax25* axp = connTbl.find( remote );
   if (!axp)
   {
      axp = new Ax25( cfg, iWin, frWin, sLine, user, local, logAddr, log,
                      antennaControl );          // create it
      if (!axp)
         return NULAX25;
      axp->link( loPro, linkTbl );               // add the links
      connTbl.add( *axp );                       // add it to the table
      memcpy( axp->remote, &remote, Ax25::AXALEN );
      memcpy( axp->local, &local, Ax25::AXALEN );
      axp->lapb->window = window;
      axp->rCallUp = &rCallUp;
      axp->sCallUp = &sCallUp;
      axp->tCallUp = &tCallUp;
      axp->eCallUp = &eCallUp;
   }
   return *axp;
}

void Ax25::disconnect() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   lapb->disc();
}

unsigned Ax25::ftype( unsigned control )
// -------------------------------------------------------------------------
// ftype : Figure out the frame type from the control field
//         This is done by masking out any sequence numbers and the
//         poll/final bit after determining the general class (I/S/U) of
//         the frame.
// -------------------------------------------------------------------------
{
   if ((control & 1) == 0)        // an I-frame is an I-frame...
      return LAPB::I;
   if (control & 2)               // U-frames use all except P/F bit for type
      return control & ~LAPB::PF;
   else                           // S-frames use low order 4 bits for type
      return control & 0x0f;
}

void Ax25::link( L1Protocol& loPro, LinkTable& tbl )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   loProto = &loPro;
   linkTbl = &tbl;
   lapb->link( *this, tbl );     // set links for LAPB protocol
}

int Ax25::oldState() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   return lapb->oldState;
}

int Ax25::output() const
// --------------------------------------------------------------------------
//  Output enqueued frames
// --------------------------------------------------------------------------
{
   return lapb->output();
}

int Ax25::output ( char* dest,   // destination AX.25 address (7 bytes, shifted)
                   char* source, // source AX.25 address (7 bytes, shifted)
                   int   pid,    // protocol ID
                   MBuf& mb )    // data field (follows PID)
// --------------------------------------------------------------------------
// Add header and send connectionless (UI) AX.25 packet.
// --------------------------------------------------------------------------
{
   mb.pushDown( 1 );                            // prepend pid to data
   mb.data[0] = (char)pid;
   return send( dest, source, LAPB::COMMAND, LAPB::UI, mb );
}

void Ax25::recvIn( MBuf& mb )
// --------------------------------------------------------------------------
//  Process incoming AX.25 packets.
//
//  After optional tracing, the address field is examined. If it is directed
//  to us as a digipeater, repeat it.  If it is addressed to us or to QST-0,
//  kick it upstairs depending on the protocol ID.
// --------------------------------------------------------------------------
{
   recvFramesIn++;
   char* hp = mb.data;                           // remember start of header
   unsigned cnt = mb.cnt;                        // for debugging purposes
   if (*showInFrames)
      frWin.printHex( mb.data, 26 );             // show header only

   // Pull header off packet and convert to host structure

   Ax25Hdr hdr;
   if (hdr.nToH( mb ) < 0)                       // if something wrong with
   {                                             // the header
      recvErrCnt++;                              // increment error count
      if (eCallUp)                               // if we need to report the
         eCallUp->func();
      if (showGrabs)
         iWin.print( "Received bad AX.25 header" );
      if (*debug)
         frWin.printHex( hp, cnt );
      delete &mb;                                // deallocate incoming buffer
      return;
   }

   // If there were digis in this packet and at least one has
   // been passed, then the last passed digi is the immediate source.
   // Otherwise it is the original source.

// char* isrc;                                   // "immediate" srce and dest
// if (hdr.ndigis != 0 && hdr.nextdigi != 0)
//    isrc = hdr.digis[ hdr.nextdigi - 1 ];
// else
//    isrc = hdr.source;

   // If there are digis in this packet and not all have been passed,
   // then the immediate destination is the next digi. Otherwise it
   // is the final destination.

   char* idest;
   if (hdr.ndigis != 0 && hdr.nextdigi != hdr.ndigis)
      idest = hdr.digis[ hdr.nextdigi ];
   else
      idest = hdr.dest;

   // Don't log our own packets if we overhear them, as they're
   // already logged by Ax25::send() and by the digipeater code.

// if (!addrEq( isrc, iface->hwaddr ))
// {
//    logsrc( iface, isrc );
//    logdest( iface, idest );
// }

   if (!simulate && *loggingStatus && !*logInFrames &&
       *logCall && addrEq( idest, &logAddr ))
      loProto->logRecvIn();

   // Examine immediate destination for a multicast address

   int mcast = 0;
   char (*mpp)[ Ax25::AXALEN ];
   for (mpp = multi; (*mpp)[0] != 0; mpp++)
      if (addrEq( idest, (char *) *mpp ))
      {
         mcast = 1;
         break;
      }

   char control;
   if (*monitor)                                 // if we're not connected
   {
      if ((control = *mb.data & ~LAPB::PF) != LAPB::UI)
      {                                          // connected mode frames
         if (*trace || *showHeaders)
            hdr.dump( mb, frWin );               // show the header
      }
      else                                       // UI frames
         if (!*trace && *showHeaders)
            hdr.dump( mb, frWin );               // show the header
   }
   else                                          // we're connected
      if (*showHeaders && mpp ==  &multi[ 4 ])   // BBSTAT
         hdr.dump( mb, frWin );                  // show the header

   if (!mcast && !addrEq( idest, &myAddr ))
   {
      // Not a broadcast, and not addressed to us. Inhibit
      // transmitter to avoid colliding with addressed station's
      // response, and discard packet.

//    if(iface->ioctl != 0)
//       (*iface->ioctl)(iface,PARAM_MUTE,1,-1);

      if (*monitor)
      {
         control = mb.pullChar() & ~LAPB::PF;            // get ctrl
         mb.pullChar();                                  // delete PID
         if (*showDataHex)
         {
            if ((control == LAPB::UI && !*trace) ||      // non-multicast UI
                (control == LAPB::I))                    // connected mode I
               frWin.printHex( mb.data, mb.cnt );        // show in hex
         }
         else
            if ((control == LAPB::UI && !*trace) ||      // non-multicast UI
                (control == LAPB::I && *showData))       // connected mode I
               frWin.print( mb.data, mb.cnt );           // show non-hex
      }
      delete &mb;
      return;
   }

// if (!mcast && iface->ioctl != 0)
//    // Packet was sent to us; abort transmit inhibit
//    (*iface->ioctl)(iface,PARAM_MUTE,1,0);

   // At this point, packet is either addressed to us, or is
   // a multicast.

   if (hdr.nextdigi < hdr.ndigis)
   {
//    // Packet requests digipeating. See if we can repeat it.
//    if(Digipeat && !mcast){
//       // Yes, kick it back out. htonax25 will set the
//       // repeated bit.
//
//       hdr->nextdigi++;
//       MBuf* hbp;
//       if ((hbp = htonax25(&hdr,bp)) != 0)
//       {
//          if (iface->forw != 0)
//          {
//             logsrc( iface->forw, iface->forw->hwaddr );
//             logdest( iface->forw, hdr->digis[hdr->nextdigi] );
//             (*iface->forw->raw)(iface->forw,hbp);
//          }
//          else
//          {
//             logsrc( iface, iface->hwaddr );
//             logdest( iface, hdr->digis[hdr->nextdigi] );
//             (*iface->raw)( iface, hbp );
//          }
//          bp = 0;
//       }
//    }
      delete &mb;                                // dispose if not forwarded
      return;
   }

   // If we reach this point, then the packet has passed all digis,
   // and is either addressed to us or is a multicast.

// if (!bp == 0)
// {
//    delete hdr;
//    return;                                    // nothing left
// }

   // If there's no locally-set entry in the routing table and
   // this packet has digipeaters, create or update it. Leave
   // local routes alone.

// AxRoute* axr;
// if (((axr = ax_lookup( hdr->source )) == 0 || axr->type == AX_AUTO)
//     && hdr->ndigis > 0)
// {
//    char digis[MAXDIGIS][Ax25::AXALEN];
//    int i,j;
//
//    // Construct reverse digipeater path
//    for (i = hdr->ndigis-1, j = 0; i >= 0; i--, j++)
//    {
//       memcpy( digis[ j ], hdr->digis[ i ], AXALEN );
//       digis[j][ALEN] &= ~(E|REPEATED);
//    }
//    ax_add(hdr->source,AX_AUTO,digis,hdr->ndigis);
// }

   // Sneak a peek at the control field. This kludge is necessary because
   // AX.25 lacks a proper protocol ID field between the address and LAPB
   // sublayers; a control value of UI indicates that LAPB is to be
   // bypassed.

   control = *mb.data & ~LAPB::PF;
   if (control == LAPB::UI)
   {
      mb.pullChar();
      int pid;
      if ((pid = mb.pullChar()) == -1)          // if no PID
      {
         delete &mb;
         return;
      }

      // Find network level protocol and hand it off

      if (linkTbl)
      {
         L3Protocol* ip = (L3Protocol*) &linkTbl->lookup( pid );
         if (ip)
         {
            Level3Iface *l3If = new Level3Iface( 0, hdr.source, hdr.dest,
                                                 &mb, mcast );
            ip->recvIn( *l3If );                 // kick it up
            return;
         }
      }
      delete &mb;                                // ignore if not in table
      return;
   }

   // Everything from here down is connected-mode LAPB, so ignore
   // multicasts

   if (mcast)
   {
      delete &mb;
      return;
   }

   if (!*monitor)                                // if we're connected
   {                                             // and we want to see our
      if (*showHeaders)                          // incoming headers and data
         hdr.dump( mb, frWin );
                                                 // note: skip ctrl
      if (*showDataHex)                          // show data in hex
         frWin.print( mb.data + 1, mb.cnt - 1 );
      else
         if (*showData)                          // show data in non-hex
            frWin.print( mb.data + 1, mb.cnt - 1 );
   }

   // Find the source address in hash table

   Ax25* axp;
   if ((axp = Ax25::connTbl.find( *hdr.source )) == 0)
   {
      // Create a new ax25 entry for this guy, insert into hash table keyed
      // on his address.

      RecvCallUp* rcu = new RecvCallUp( user );
      StatusCallUp* scu = new StatusCallUp( user );
      if ((axp = &create( cfg, iWin, frWin, sLine, *loProto, myAddr,
                          *hdr.source, logAddr, log, *linkTbl,
                          cfg.axWindow,          // window size in bytes
                          *rcu,                  // receive call up function
                          *scu,                  // status change call up function
                          *this->tCallUp,        // transmit call up fuction
                          *this->eCallUp,        // error call up fuction
                          user,                  // user linkage
                          antennaControl )) == 0)
      {
         delete &mb;
         delete rcu;
         delete scu;
         return;
      }
      memcpy( axp->remote, hdr.source, Ax25::AXALEN );// swap source and
      memcpy( axp->local, hdr.dest, Ax25::AXALEN );   // destination
      rcu->axp = axp;                                 // pass the address to
      scu->axp = axp;                                 // the callups
   }
   if (hdr.cmdrsp == LAPB::UNKNOWN)
      lapb->proto = V1;                          // old protocol in use

   axp->lapb->input( hdr.cmdrsp, mb );           // process buffer

   // It is not necessary to delete the buffer (mb) at this point.
   // LAPB::input() either deletes or queues the buffer.
}

void Ax25::reset() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   lapb->setState( LAPB::DISCONNECTED );
   Ax25::connTbl.del( *this );
}

int Ax25::send( char*   dest,     // destination AX.25 address (7 bytes, shifted)
                char*   source,   // source AX.25 address (7 bytes, shifted)
                int     cmdrsp,   // command/response indication
                int     ctl,      // control field
                MBuf&   mb     )  // data field (follows PID)
// --------------------------------------------------------------------------
// Common subroutine for sendFrame() and axOutput()
// --------------------------------------------------------------------------
{
   // If the source addr is unspecified, use the interface address
// if (*source == 0)
//    source = iface->hwaddr;

   // If there's a digipeater route, get it
// struct ax_route* axr = ax_lookup( dest );

   Ax25Hdr  addr;
   memcpy( addr.dest, dest, Ax25::AXALEN );
   memcpy( addr.source, source, Ax25::AXALEN );
   addr.cmdrsp = cmdrsp;

// char* idest;
// if (axr)
// {
//    memcpy( addr.digis, axr->digis, axr->ndigis * Ax25::AXALEN );
//    addr.ndigis = axr->ndigis;
//    idest = addr.digis[0];
// }
// else
// {
      addr.ndigis = 0;
//    idest = dest;
// }
   addr.nextdigi = 0;

   // Allocate MBuf for control field, and fill in

   mb.pushDown( 1 );
   mb.data[ 0 ] = ctl;

   MBuf* data = &addr.hToN( mb );
   if (data == &NULBUF)
   {
      delete &mb;
      return -1;
   }

   // This shouldn't be necessary because redirection has already been
   // done at the IP router layer, but just to be safe...

// if (iface->forw)
// {
//    logsrc( iface->forw, iface->forw->hwaddr );
//    logdest( iface->forw, idest );
//    rval = (*iface->forw->raw)( iface->forw, data );
// }
// else
// {
//     logsrc( iface, iface->hwaddr );
//   logdest( iface, idest );
//   rval = (*iface->raw)( iface, data );
// }
// return rval;
   if (*showInFrames)
//    frWin.printHex( data->data, data->cnt );   // show entire frame
      frWin.printHex( data->data, 26 );          // show header only
   if (*showHeaders)
   {
      Ax25Hdr hdr;
      MBuf* dupData = new MBuf( *data, 0, data->cnt );
      if (hdr.nToH( *dupData ) >= 0)
         hdr.dump( *dupData, frWin );
      delete dupData;
   }
   return loProto->send( *data );
}

MBuf& Ax25::rxDequeue() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   return *lapb->rxq->dequeue();
}

void Ax25::rxEnqueue( MBuf& mb ) const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   lapb->rxq->enqueue( &mb );
}

int Ax25::sendFrame( int cmdrsp, int ctl, MBuf& data )
// --------------------------------------------------------------------------
//  General purpose AX.25 frame output
// --------------------------------------------------------------------------
{
   return send( remote, local, cmdrsp, ctl, data );
}

void Ax25::txEnqueue( MBuf& mb ) const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   lapb->enqueue( mb );
}

int Ax25::setCall( char* out, char* call )
// -------------------------------------------------------------------------
//  Convert callsign plus substation ID of the form "NZ3F-0" to AX.25
//  (shifted) address format.  Address extension bit is left clear.
//  Return 1 on error, 0 if OK.
// -------------------------------------------------------------------------
{

   if (out == 0 || call == 0 || *call == 0)
      return 1;

   // Find dash, if any, separating callsign from ssid.  Then compute
   // length of callsign field and make sure it isn't excessive.

   int csize;
   char* dp = strchr(call,'-');
   if (dp == 0)
      csize = strlen(call);
   else
      csize = ( int )(dp - call);
   if (csize > ALEN)
      return 1;

   // Now find and convert ssid, if any

   unsigned ssid;
   if (dp != 0)
   {
      dp++;                                      // skip dash
      ssid = atoi(dp);
      if (ssid > 15)
         return 1;
   }
   else
      ssid = 0;

   // Copy upper-case callsign, left shifted one bit

   int i;
   for (i=0; i < csize; i++)
      *out++ = toupper(*call++) << 1;

   // Pad with shifted spaces if necessary

   for (; i < ALEN; i++)
      *out++ = ' ' << 1;

   // Insert substation ID field and set reserved bits

   *out = 0x60 | (ssid << 1);
   return 0;
}

void Ax25::setState( const int state ) const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   lapb->state = state;
}

int Ax25::state() const
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   return lapb->state;
}

int Ax25::addrEq( char* a, char* b )
// -------------------------------------------------------------------------
//  Detemine if addresses are equal.  Same callsign but different SSID are
//  not equal
// -------------------------------------------------------------------------
{
   if (memcmp( a, b, ALEN ) != 0 || ((a[ALEN] ^ b[ALEN]) & SSID) != 0)
      return 0;
   else
      return 1;
}

char* Ax25::pAx25( char* e, char* addr )
// -------------------------------------------------------------------------
//  Convert encoded AX.25 address to printable string
// -------------------------------------------------------------------------
{
   char* cp = e;
   for (int i = ALEN; i != 0; i--)
   {
      char c = (*addr++ >> 1) & 0x7f;
      if (c != ' ')
         *cp++ = c;
   }
   if ((*addr & SSID) != 0)
      sprintf( cp,"-%d",(*addr >> 1) & 0xf );    // ssid
   else
      *cp = 0;
   return e;
}

Ax25ConnTbl::Ax25ConnTbl() : list( 0 )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

Ax25ConnTbl::~Ax25ConnTbl()
// -------------------------------------------------------------------------
//  Destructor
// -------------------------------------------------------------------------
{}

void Ax25ConnTbl::add( Ax25& ax )
// -------------------------------------------------------------------------
//  Add entry to connection table at the head of the chain
// -------------------------------------------------------------------------
{
   ax.next = list;
   list = &ax;
}

Ax25* Ax25ConnTbl::find( char& addr )
// -------------------------------------------------------------------------
//  Look up entry in connection table
// -------------------------------------------------------------------------
{
   Ax25* axp;
   Ax25* axlast = 0;

   // Search list

   for (axp = list; axp; axlast = axp, axp = axp->next)
      if (Ax25::addrEq( axp->remote, &addr))
      {
         if (axlast)
         {
            axlast->next = axp->next;            // move entry to top of list
            axp->next = list;                    // to speed future searches
            list = axp;
         }
         return axp;
      }
   return 0;
}

void Ax25ConnTbl::del( const Ax25& conn )
// -------------------------------------------------------------------------
//  Remove entry from connection table
// -------------------------------------------------------------------------
{
   Ax25* axp;
   Ax25* axlast = 0;

   for (axp = list; axp; axlast = axp, axp = axp->next)
      if (axp == &conn)
         break;
   if (!axp)
      return;                                    // not found
   if (axlast)                                   // remove from list
      axlast->next = axp->next;
   else
      list = axp->next;
}

int Ax25ConnTbl::validate( Ax25& ax )
// -------------------------------------------------------------------------
//  Determine if an entry in connection table
// -------------------------------------------------------------------------
{
   Ax25* axp;

   for (axp = list; axp != 0; axp = axp->next)
      if (&ax == axp)
         return 1;
   return 0;
}
